/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.standalone.plugins.manager;

import es.gob.afirma.standalone.plugins.GenericMenuOption;
import es.gob.afirma.standalone.plugins.Permission;
import es.gob.afirma.standalone.plugins.PluginButton;
import es.gob.afirma.standalone.plugins.PluginCommand;
import es.gob.afirma.standalone.plugins.PluginInfo;
import es.gob.afirma.standalone.plugins.manager.PluginException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;

public class PluginInfoLoader {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    static PluginInfo parseInfo(InputStreamReader inputStreamReader) throws PluginException {
        PluginInfo pluginInfo;
        try (JsonReader jsonReader = Json.createReader((Reader)inputStreamReader);){
            JsonObject jsonObject = jsonReader.readObject();
            pluginInfo = PluginInfoLoader.parseInfoObject(jsonObject);
            Permission[] permissionArray = PluginInfoLoader.parsePermissionsObject(jsonObject);
            if (permissionArray != null) {
                pluginInfo.setPermissions(permissionArray);
            }
            String string = PluginInfoLoader.parseInlineProcessor(jsonObject);
            pluginInfo.setInlineProcessorClassname(string);
            GenericMenuOption genericMenuOption = PluginInfoLoader.parseMenuObject(jsonObject);
            pluginInfo.setMenu(genericMenuOption);
            PluginButton[] pluginButtonArray = PluginInfoLoader.parseButtonsObject(jsonObject);
            pluginInfo.setButtons(pluginButtonArray);
            PluginCommand[] pluginCommandArray = PluginInfoLoader.parseCommandsObject(jsonObject);
            pluginInfo.setCommands(pluginCommandArray);
        }
        return pluginInfo;
    }

    private static PluginInfo parseInfoObject(JsonObject jsonObject) throws PluginException {
        int n;
        String[] stringArray;
        JsonArray jsonArray;
        JsonObject jsonObject2 = jsonObject.getJsonObject("info");
        if (!jsonObject2.containsKey((Object)"name") || !jsonObject2.containsKey((Object)"title")) {
            throw new PluginException("El plugin no define la informacion basica necesaria ('name' y 'title')");
        }
        PluginInfo pluginInfo = new PluginInfo(jsonObject2.getString("name"), jsonObject2.getString("title"));
        pluginInfo.setVersionCode(jsonObject2.getInt("version_code", 1));
        pluginInfo.setVersion(jsonObject2.getString("version", "1.0"));
        pluginInfo.setDescription(jsonObject2.getString("description"));
        if (jsonObject2.containsKey((Object)"authors")) {
            jsonArray = jsonObject2.getJsonArray("authors");
            stringArray = new String[jsonArray.size()];
            for (n = 0; n < jsonArray.size(); ++n) {
                stringArray[n] = jsonArray.getString(n);
            }
            pluginInfo.setAuthors(stringArray);
        }
        if (jsonObject2.containsKey((Object)"contacts")) {
            jsonArray = jsonObject2.getJsonArray("contacts");
            stringArray = new String[jsonArray.size()];
            for (n = 0; n < jsonArray.size(); ++n) {
                stringArray[n] = jsonArray.getString(n);
            }
            pluginInfo.setContacts(stringArray);
        }
        if (jsonObject2.containsKey((Object)"configuration_panel")) {
            pluginInfo.setConfigPanel(jsonObject2.getString("configuration_panel"));
        }
        return pluginInfo;
    }

    private static Permission[] parsePermissionsObject(JsonObject jsonObject) {
        JsonArray jsonArray = jsonObject.getJsonArray("permissions");
        if (jsonArray == null) {
            return new Permission[0];
        }
        HashSet<Permission> hashSet = new HashSet<Permission>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Permission permission3;
            JsonString jsonString = (JsonString)jsonArray.get(i);
            try {
                permission3 = Permission.forName((String)jsonString.getString());
            }
            catch (Exception exception) {
                LOGGER.warning("Permiso no reconocido: " + jsonString.getString());
                continue;
            }
            hashSet.add(permission3);
        }
        Permission[] permissionArray = hashSet.toArray(new Permission[0]);
        Arrays.sort(permissionArray, (permission, permission2) -> permission.getOrder() < permission2.getOrder() ? -1 : (permission.getOrder() == permission2.getOrder() ? 0 : 1));
        return permissionArray;
    }

    private static String parseInlineProcessor(JsonObject jsonObject) {
        JsonString jsonString = jsonObject.getJsonString("inline_processor");
        String string = null;
        if (jsonString != null && jsonString.getString() != null) {
            string = jsonString.getString();
        }
        return string;
    }

    private static GenericMenuOption parseMenuObject(JsonObject jsonObject) throws PluginException {
        JsonObject jsonObject2 = jsonObject.getJsonObject("menu");
        if (jsonObject2 == null) {
            return null;
        }
        if (!jsonObject2.containsKey((Object)"title") || !jsonObject2.containsKey((Object)"items") && !jsonObject2.containsKey((Object)"action")) {
            throw new PluginException("Se han encontrado menus del plugin mal definidos");
        }
        GenericMenuOption genericMenuOption = new GenericMenuOption(jsonObject2.getString("title"));
        if (jsonObject2.containsKey((Object)"action")) {
            genericMenuOption.setDialogClass(jsonObject2.getString("action"));
        } else {
            JsonArray jsonArray = jsonObject2.getJsonArray("items");
            PluginInfoLoader.parseItemsObject(genericMenuOption, jsonArray);
        }
        return genericMenuOption;
    }

    private static void parseItemsObject(GenericMenuOption genericMenuOption, JsonArray jsonArray) throws PluginException {
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonArray jsonArray2;
                JsonObject jsonObject = jsonArray.getJsonObject(i);
                if (!jsonObject.containsKey((Object)"title") || !jsonObject.containsKey((Object)"items") && !jsonObject.containsKey((Object)"action")) {
                    throw new PluginException("Se han encontrado sub-menus del plugin mal definidos");
                }
                GenericMenuOption genericMenuOption2 = new GenericMenuOption(jsonObject.getString("title"));
                if (jsonObject.containsKey((Object)"items")) {
                    jsonArray2 = jsonObject.getJsonArray("items");
                    if (jsonArray2 != null && jsonArray2.size() > 0) {
                        PluginInfoLoader.parseItemsObject(genericMenuOption2, jsonArray2);
                    }
                } else if (jsonObject.containsKey((Object)"action")) {
                    jsonArray2 = jsonObject.getJsonString("action");
                    genericMenuOption2.setActionClassName(jsonArray2.getString());
                }
                genericMenuOption.addSubMenu(genericMenuOption2);
            }
        }
    }

    private static PluginButton[] parseButtonsObject(JsonObject jsonObject) throws PluginException {
        JsonArray jsonArray = jsonObject.getJsonArray("buttons");
        if (jsonArray == null || jsonArray.size() == 0) {
            return null;
        }
        ArrayList<PluginButton> arrayList = new ArrayList<PluginButton>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
            if (!jsonObject2.containsKey((Object)"title") && !jsonObject2.containsKey((Object)"icon")) {
                throw new PluginException("No se ha indicado el titulo ni el icono de un boton del plugin");
            }
            if (!jsonObject2.containsKey((Object)"action")) {
                throw new PluginException("No se ha definido una accion para un boton");
            }
            if (!jsonObject2.containsKey((Object)"window")) {
                throw new PluginException("No se ha definido la ventana para un boton");
            }
            PluginButton pluginButton = new PluginButton();
            pluginButton.setTitle(jsonObject2.getString("title", null));
            pluginButton.setIcon(jsonObject2.getString("icon", null));
            pluginButton.setToolTip(jsonObject2.getString("tooltip", null));
            pluginButton.setAccesibleDescription(jsonObject2.getString("accesible_description", null));
            pluginButton.setAfirmaWindow(jsonObject2.getString("window"));
            pluginButton.setActionClassName(jsonObject2.getString("action"));
            arrayList.add(pluginButton);
        }
        return arrayList.toArray(new PluginButton[arrayList.size()]);
    }

    private static PluginCommand[] parseCommandsObject(JsonObject jsonObject) throws PluginException {
        JsonArray jsonArray = jsonObject.getJsonArray("commands");
        if (jsonArray == null || jsonArray.size() == 0) {
            return null;
        }
        ArrayList<PluginCommand> arrayList = new ArrayList<PluginCommand>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
            if (!jsonObject2.containsKey((Object)"name")) {
                throw new PluginException("No se ha indicado el nombre de un comando del plugin");
            }
            if (!jsonObject2.containsKey((Object)"action")) {
                throw new PluginException("No se ha definido una clase de accion para un comando");
            }
            PluginCommand pluginCommand = new PluginCommand(jsonObject2.getString("name"));
            pluginCommand.setCommandActionClass(jsonObject2.getString("action"));
            pluginCommand.setDescription(jsonObject2.getString("description"));
            arrayList.add(pluginCommand);
        }
        return arrayList.toArray(new PluginCommand[arrayList.size()]);
    }
}

