/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.standalone.plugins.manager;

import es.gob.afirma.standalone.plugins.manager.JarNoSignedException;
import java.io.File;
import java.io.IOException;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarVerifier {
    private static final long THRESHOLD_FILE_SIZE = 100000000L;

    private JarVerifier() {
    }

    public static List<X509Certificate[]> verify(File file) throws IOException, SecurityException, JarNoSignedException {
        if (file.length() >= 100000000L) {
            throw new IOException("El archivo tiene un tamano superior al permitido.");
        }
        ArrayList<X509Certificate[]> arrayList = new ArrayList<X509Certificate[]>();
        try (JarFile jarFile = new JarFile(file, true, 1);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                throw new SecurityException("No se ha encontrado el manifest en el archivo");
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || jarEntry.getName().contains("META-INF")) continue;
                byte[] byArray = new byte[8096];
                CodeSigner[] codeSignerArray = null;
                try (CodeSigner[] codeSignerArray2 = jarFile.getInputStream(jarEntry);){
                    while (codeSignerArray2.read(byArray, 0, byArray.length) != -1) {
                    }
                }
                catch (Throwable object) {
                    codeSignerArray = object;
                    throw object;
                }
                codeSignerArray2 = jarEntry.getCodeSigners();
                if (codeSignerArray2 == null) {
                    throw new JarNoSignedException("Se han encontrado entradas sin firmar: " + jarEntry.getName());
                }
                if (!arrayList.isEmpty()) continue;
                for (CodeSigner codeSigner : codeSignerArray2) {
                    List<? extends Certificate> list = codeSigner.getSignerCertPath().getCertificates();
                    arrayList.add(list.toArray(new X509Certificate[0]));
                }
            }
        }
        return arrayList;
    }
}

