/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import es.gob.afirma.core.misc.SecureXmlBuilder;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.dereference.CustomUriDereferencer;
import es.gob.afirma.signvalidation.SignValider;
import es.gob.afirma.signvalidation.SignValidity;
import es.gob.afirma.signvalidation.SignatureFormatDetectorXades;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ValidateXMLSignature
extends SignValider {
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public List<SignValidity> validate(byte[] byArray) {
        return this.validate(byArray, true);
    }

    @Override
    public List<SignValidity> validate(byte[] byArray, Properties properties) {
        return this.validate(byArray, true);
    }

    @Override
    public List<SignValidity> validate(byte[] byArray, boolean bl) {
        Document document;
        List<SignValidity> list = new ArrayList<SignValidity>();
        try {
            document = SecureXmlBuilder.getSecureDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN));
            return list;
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN));
            return list;
        }
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Object object2;
                DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeyValueKeySelector(), nodeList.item(i));
                dOMValidateContext.setURIDereferencer((URIDereferencer)new CustomUriDereferencer());
                XMLSignature xMLSignature = Utils.getDOMFactory().unmarshalXMLSignature(dOMValidateContext);
                if (!xMLSignature.validate(dOMValidateContext) && !bl2) {
                    LOGGER.info("La firma es invalida");
                    list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA));
                    bl2 = true;
                }
                if (!xMLSignature.getSignatureValue().validate(dOMValidateContext) && !bl2) {
                    LOGGER.info("El valor de la firma es invalido");
                    list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA));
                    bl2 = true;
                }
                Iterator<Reference> iterator = xMLSignature.getSignedInfo().getReferences().iterator();
                boolean bl4 = false;
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    if (object2.validate(dOMValidateContext)) continue;
                    LOGGER.info("La referencia '" + object2.getURI() + "' de la firma es invalida");
                    list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA));
                    bl4 = true;
                }
                if (bl) {
                    object2 = XMLSignatureFactory.getInstance("DOM");
                    object = ((XMLSignatureFactory)object2).unmarshalXMLSignature(dOMValidateContext);
                    KeyInfo keyInfo = object.getKeyInfo();
                    X509Certificate x509Certificate = null;
                    for (XMLStructure xMLStructure : keyInfo.getContent()) {
                        if (!(xMLStructure instanceof X509Data)) continue;
                        X509Data x509Data = (X509Data)xMLStructure;
                        List<?> list2 = x509Data.getContent();
                        for (int j = 0; j < list2.size(); ++j) {
                            if (!(list2.get(j) instanceof X509Certificate)) continue;
                            x509Certificate = (X509Certificate)list2.get(j);
                            try {
                                x509Certificate.checkValidity();
                                continue;
                            }
                            catch (CertificateExpiredException certificateExpiredException) {
                                if (bl3) continue;
                                list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_EXPIRED, certificateExpiredException));
                                bl3 = true;
                                continue;
                            }
                            catch (CertificateNotYetValidException certificateNotYetValidException) {
                                list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_NOT_VALID_YET, certificateNotYetValidException));
                            }
                        }
                    }
                }
                if ("XAdES B-Level".equals(object = SignatureFormatDetectorXades.resolveSignerXAdESFormat((Element)(object2 = (Element)nodeList.item(i)))) || "No reconocido".equals(object) || "XAdES B-B-Level".equals(object) || "XAdES-BES".equals(object) || "XAdES-EPES".equals(object)) continue;
                list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, SignValidity.VALIDITY_ERROR.SIGN_PROFILE_NOT_CHECKED));
            }
        }
        catch (XMLSignatureException xMLSignatureException) {
            LOGGER.log(Level.WARNING, "La firma no esta formada correctamente: " + xMLSignatureException, xMLSignatureException);
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.BAD_BUILD_SIGN, xMLSignatureException));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "No se ha podido validar la firma: " + exception, exception);
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, SignValidity.VALIDITY_ERROR.UNKOWN_ERROR, exception));
        }
        list = ValidateXMLSignature.checkLongStandingValiditySign(list);
        if (list.size() == 0) {
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null));
        }
        return list;
    }

    public static List<SignValidity> validateSign(Element element, String string, boolean bl) {
        ArrayList<SignValidity> arrayList = new ArrayList<SignValidity>();
        if (!bl) {
            boolean bl2 = true;
            try {
                DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeyValueKeySelector(), (Node)element);
                dOMValidateContext.setURIDereferencer((URIDereferencer)new CustomUriDereferencer());
                boolean bl3 = false;
                XMLSignature xMLSignature = Utils.getDOMFactory().unmarshalXMLSignature(dOMValidateContext);
                if (!xMLSignature.validate(dOMValidateContext)) {
                    LOGGER.info("La firma es invalida");
                    bl2 = false;
                    bl3 = true;
                }
                if (!xMLSignature.getSignatureValue().validate(dOMValidateContext)) {
                    LOGGER.info("El valor de la firma es invalido");
                    bl2 = false;
                    bl3 = true;
                }
                for (Reference reference : xMLSignature.getSignedInfo().getReferences()) {
                    if (reference.validate(dOMValidateContext)) continue;
                    LOGGER.info("La referencia '" + reference.getURI() + "' de la firma es invalida");
                    bl2 = false;
                    bl3 = true;
                }
                if (bl3) {
                    arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA));
                }
            }
            catch (XMLSignatureException xMLSignatureException) {
                LOGGER.log(Level.WARNING, "La firma no esta formada correctamente: " + xMLSignatureException, xMLSignatureException);
                bl2 = false;
                arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.BAD_BUILD_SIGN, xMLSignatureException));
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "No se ha podido validar la firma: " + exception, exception);
                bl2 = false;
                arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, SignValidity.VALIDITY_ERROR.UNKOWN_ERROR, exception));
            }
            if (!("XAdES B-Level".equals(string) || "No reconocido".equals(string) || "XAdES B-B-Level".equals(string) || "XAdES-BES".equals(string) || "XAdES-EPES".equals(string))) {
                bl2 = false;
                arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, SignValidity.VALIDITY_ERROR.SIGN_PROFILE_NOT_CHECKED));
            }
            if (bl2) {
                arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null));
            }
        } else {
            arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, SignValidity.VALIDITY_ERROR.CANT_VALIDATE_EXTERNALLY_DETACHED));
        }
        return arrayList;
    }

    private static final class SimpleKeySelectorResult
    implements KeySelectorResult {
        private final PublicKey pk;

        SimpleKeySelectorResult(PublicKey publicKey) {
            this.pk = publicKey;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }

    static final class KeyValueKeySelector
    extends KeySelector {
        KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Objeto KeyInfo nulo");
            }
            List<XMLStructure> list = keyInfo.getContent();
            try {
                xMLCryptoContext.setURIDereferencer((URIDereferencer)new CustomUriDereferencer());
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido instalar un dereferenciador a medida: " + exception);
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                XMLStructure xMLStructure = list.get(i);
                if (xMLStructure instanceof KeyValue) {
                    try {
                        object = ((KeyValue)xMLStructure).getPublicKey();
                    }
                    catch (KeyException keyException) {
                        throw new KeySelectorException(keyException);
                    }
                    return new SimpleKeySelectorResult((PublicKey)object);
                }
                if (!(xMLStructure instanceof X509Data)) continue;
                object = ((X509Data)xMLStructure).getContent();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Certificate)) continue;
                    return new SimpleKeySelectorResult(((Certificate)e).getPublicKey());
                }
            }
            throw new KeySelectorException("No se ha encontrado la clave publica dentro del XML firmado");
        }
    }
}

