/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import com.aowagie.text.pdf.AcroFields;
import com.aowagie.text.pdf.PdfArray;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfPKCS7;
import com.aowagie.text.pdf.PdfReader;
import es.gob.afirma.core.RuntimeConfigNeededException;
import es.gob.afirma.signers.pades.PdfUtil;
import es.gob.afirma.signers.pades.common.PdfFormModifiedException;
import es.gob.afirma.signers.pades.common.SuspectedPSAException;
import es.gob.afirma.signvalidation.DataAnalizerUtil;
import es.gob.afirma.signvalidation.SignValider;
import es.gob.afirma.signvalidation.SignValidity;
import es.gob.afirma.signvalidation.SignatureFormatDetectorPadesCades;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public final class ValidatePdfSignature
extends SignValider {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final PdfName PDFNAME_ETSI_RFC3161 = new PdfName("ETSI.RFC3161");
    private static final PdfName PDFNAME_DOCTIMESTAMP = new PdfName("DocTimeStamp");
    private static final String DEFAULT_PAGES_TO_CHECK_PSA = "10";

    @Override
    public List<SignValidity> validate(byte[] byArray) throws RuntimeConfigNeededException, IOException {
        return this.validate(byArray, true);
    }

    @Override
    public List<SignValidity> validate(byte[] byArray, boolean bl) throws RuntimeConfigNeededException, IOException {
        Properties properties = new Properties();
        properties.setProperty("checkCertificates", Boolean.toString(bl));
        try {
            return this.validate(byArray, properties);
        }
        catch (RuntimeConfigNeededException runtimeConfigNeededException) {
            throw new IOException("No se dispone de la informacion necesaria para completar la validacion", runtimeConfigNeededException);
        }
    }

    @Override
    public List<SignValidity> validate(byte[] byArray, Properties properties) throws RuntimeConfigNeededException, IOException {
        Object object;
        PdfArray pdfArray;
        PdfDictionary pdfDictionary;
        Object object2;
        Object object3;
        AcroFields acroFields;
        PdfReader pdfReader;
        Properties properties2 = properties != null ? properties : new Properties();
        List<SignValidity> list = new ArrayList<SignValidity>();
        try {
            boolean bl = Boolean.parseBoolean(properties2.getProperty("headless"));
            pdfReader = PdfUtil.getPdfReader((byte[])byArray, (Properties)properties2, (boolean)bl);
            acroFields = pdfReader.getAcroFields();
        }
        catch (Exception exception) {
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN));
            return list;
        }
        List list2 = acroFields.getSignatureNames();
        if (list2.size() == 0) {
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN));
            return list;
        }
        String string = properties2.getProperty("allowModifiedForm");
        boolean bl = Boolean.parseBoolean(string);
        boolean bl2 = false;
        if (!bl && acroFields.getTotalRevisions() > 1 && (object3 = DataAnalizerUtil.checkPDFForm(pdfReader)) != null && !object3.isEmpty()) {
            if (string == null && this.isRelaxed()) {
                throw new PdfFormModifiedException("Se han detectado cambios en un formulario posteriores a la primera firma");
            }
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.MODIFIED_FORM));
            bl2 = true;
        }
        object3 = properties2.getProperty("allowShadowAttack");
        boolean bl3 = Boolean.parseBoolean((String)object3);
        String string2 = properties2.getProperty("pagesToCheckShadowAttack", DEFAULT_PAGES_TO_CHECK_PSA);
        boolean bl4 = false;
        if (bl || bl2) {
            bl4 = true;
        }
        if (!bl4 && !bl3 && acroFields.getTotalRevisions() > 1 && acroFields.getRevision((String)list2.get(0)) < acroFields.getTotalRevisions()) {
            object2 = acroFields.extractRevision((String)list2.get(0));
            Object object4 = null;
            try {
                Object object5 = DataAnalizerUtil.checkPdfShadowAttack(byArray, (InputStream)object2, string2);
                if (object5 != null) {
                    if (this.isRelaxed() && ((SignValidity)object5).getValidity() == SignValidity.SIGN_DETAIL_TYPE.PENDING_CONFIRM_BY_USER && object3 == null) {
                        throw new SuspectedPSAException("PDF sospechoso de haber sufrido PDF Shadow Attack");
                    }
                    if (((SignValidity)object5).getValidity() == SignValidity.SIGN_DETAIL_TYPE.PENDING_CONFIRM_BY_USER) {
                        object5 = new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, ((SignValidity)object5).getError());
                    }
                    list.add((SignValidity)object5);
                }
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object4 != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        object2 = SignatureFormatDetectorPadesCades.resolvePDFFormat(byArray);
        for (Object object5 : list2) {
            boolean bl5 = Boolean.parseBoolean(properties2.getProperty("checkCertificates"));
            pdfDictionary = ValidatePdfSignature.validateSign((String)object5, acroFields, (String)object2, bl5);
            pdfArray = pdfDictionary.iterator();
            while (pdfArray.hasNext()) {
                object = pdfArray.next();
                if (list.contains(object)) continue;
                if (SignValidity.SIGN_DETAIL_TYPE.UNKNOWN.equals((Object)((SignValidity)object).getValidity())) {
                    list.add(0, (SignValidity)object);
                    continue;
                }
                if (((SignValidity)object).getValidity() == SignValidity.SIGN_DETAIL_TYPE.OK) continue;
                list.add((SignValidity)object);
            }
        }
        int n = 0;
        if (pdfReader.getCertificationLevel() == 1 && list.size() == 0) {
            for (String string3 : list2) {
                PdfDictionary pdfDictionary2;
                pdfDictionary = acroFields.getSignatureDictionary(string3);
                if (pdfDictionary.get(PdfName.REFERENCE) == null || (pdfDictionary2 = (PdfDictionary)((ArrayList)(object = (pdfArray = (PdfArray)pdfDictionary.get(PdfName.REFERENCE)).getArrayList())).get(0)).get(PdfName.TRANSFORMMETHOD) == null) continue;
                n = acroFields.getRevision(string3);
            }
        }
        if (pdfReader.getCertificationLevel() == 1 && list.size() == 0) {
            for (String string4 : list2) {
                int n2 = acroFields.getRevision(string4);
                if (n2 == acroFields.getTotalRevisions() && n2 <= n) {
                    list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null));
                    continue;
                }
                if (n2 < acroFields.getTotalRevisions() && n2 <= n) {
                    list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null));
                    continue;
                }
                list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFIED_SIGN_REVISION));
            }
        }
        list = ValidatePdfSignature.checkValidityKOPriority(list);
        if ((list = ValidatePdfSignature.checkLongStandingValiditySign(list)).size() == 0) {
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null));
        }
        return list;
    }

    public static List<SignValidity> validateSign(String string, AcroFields acroFields, String string2, boolean bl) throws RuntimeConfigNeededException, IOException {
        PdfDictionary pdfDictionary;
        ArrayList<SignValidity> arrayList = new ArrayList<SignValidity>();
        PdfPKCS7 pdfPKCS7 = acroFields.verifySignature(string);
        if (pdfPKCS7.getStrictHashAlgorithm() == null) {
            arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.ALGORITHM_NOT_SUPPORTED));
        }
        if (!PDFNAME_ETSI_RFC3161.equals((Object)(pdfDictionary = acroFields.getSignatureDictionary(string)).get(PdfName.SUBFILTER)) && !PDFNAME_DOCTIMESTAMP.equals((Object)pdfDictionary.get(PdfName.SUBFILTER))) {
            try {
                if (!pdfPKCS7.verify()) {
                    arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA));
                }
            }
            catch (Exception exception) {
                LOGGER.warning("Error validando una de las firmas del PDF: " + exception);
                arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CORRUPTED_SIGN, exception));
            }
        }
        if (bl) {
            X509Certificate x509Certificate = pdfPKCS7.getSigningCertificate();
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_EXPIRED, certificateExpiredException));
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_NOT_VALID_YET, certificateNotYetValidException));
            }
        }
        if (!("PAdES-Basic".equals(string2) || "No reconocido".equals(string2) || "PAdES-BES".equals(string2) || "PAdES B-Level".equals(string2) || "PAdES B-B-Level".equals(string2) || "PAdES-EPES".equals(string2))) {
            arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, SignValidity.VALIDITY_ERROR.SIGN_PROFILE_NOT_CHECKED));
        }
        if (arrayList.size() == 0) {
            arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null));
        }
        return arrayList;
    }
}

