/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.cms.AOCMSSigner;
import es.gob.afirma.signvalidation.CertHolderBySignerIdSelector;
import es.gob.afirma.signvalidation.SignValider;
import es.gob.afirma.signvalidation.SignValidity;
import es.gob.afirma.signvalidation.SignatureFormatDetectorPadesCades;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessable;
import org.spongycastle.cms.CMSProcessableByteArray;
import org.spongycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.cms.CMSSignerDigestMismatchException;
import org.spongycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.spongycastle.cms.SignerInformation;
import org.spongycastle.cms.SignerInformationVerifier;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.operator.ContentVerifierProvider;
import org.spongycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.spongycastle.operator.DigestCalculatorProvider;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.spongycastle.operator.bc.BcDigestCalculatorProvider;
import org.spongycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.spongycastle.util.Selector;
import org.spongycastle.util.Store;

public final class ValidateBinarySignature
extends SignValider {
    @Override
    public List<SignValidity> validate(byte[] byArray) throws IOException {
        return ValidateBinarySignature.validate(byArray, null, true);
    }

    @Override
    public List<SignValidity> validate(byte[] byArray, boolean bl) throws IOException {
        return ValidateBinarySignature.validate(byArray, null, bl);
    }

    @Override
    public List<SignValidity> validate(byte[] byArray, Properties properties) throws IOException {
        return ValidateBinarySignature.validate(byArray, null, true);
    }

    public static List<SignValidity> validate(byte[] byArray, byte[] byArray2) throws IOException {
        return ValidateBinarySignature.validate(byArray, byArray2, true);
    }

    public static List<SignValidity> validate(byte[] byArray, byte[] byArray2, boolean bl) throws IOException {
        List<SignValidity> list = new ArrayList<SignValidity>();
        if (byArray == null) {
            throw new IllegalArgumentException("La firma a validar no puede ser nula");
        }
        AOCAdESSigner aOCAdESSigner = new AOCAdESSigner();
        if (!aOCAdESSigner.isSign(byArray) && !(aOCAdESSigner = new AOCMSSigner()).isSign(byArray)) {
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN));
            return list;
        }
        byte[] byArray3 = null;
        try {
            byte[] byArray4 = byArray3 = byArray2 != null ? byArray2 : aOCAdESSigner.getData(byArray);
            if (byArray3 == null) {
                Logger.getLogger("es.gob.afirma").info("Se ha pedido validar una firma explicita sin proporcionar los datos firmados");
                list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, SignValidity.VALIDITY_ERROR.NO_DATA));
            }
        }
        catch (AOInvalidFormatException aOInvalidFormatException) {
            Logger.getLogger("es.gob.afirma").info("Se ha pedido validar una firma como CAdES, pero no es CAdES: " + (Object)((Object)aOInvalidFormatException));
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN, (Exception)((Object)aOInvalidFormatException)));
        }
        catch (AOException aOException) {
            Logger.getLogger("es.gob.afirma").info("Se encontraron datos en la firma y no se pudieron extraer: " + (Object)((Object)aOException));
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.UNKOWN_ERROR));
        }
        try {
            ValidateBinarySignature.verifySignatures(byArray, byArray3, bl, list);
        }
        catch (CMSSignerDigestMismatchException cMSSignerDigestMismatchException) {
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA, (Exception)((Object)cMSSignerDigestMismatchException)));
        }
        catch (Exception exception) {
            list.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, null, exception));
        }
        list = ValidateBinarySignature.checkValidityKOPriority(list);
        list = ValidateBinarySignature.checkLongStandingValiditySign(list);
        return list;
    }

    private static void verifySignatures(byte[] byArray, byte[] byArray2, boolean bl, List<SignValidity> list) throws CMSException, CertificateException, IOException, OperatorCreationException {
        CMSSignedData cMSSignedData = byArray2 == null ? new CMSSignedData(byArray) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(byArray2), byArray);
        Store store = cMSSignedData.getCertificates();
        boolean bl2 = cMSSignedData.getSignedContent() != null;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (Object e : cMSSignedData.getSignerInfos().getSigners()) {
            String string = SignatureFormatDetectorPadesCades.resolveASN1Format(cMSSignedData, (SignerInformation)e);
            List<SignValidity> list2 = ValidateBinarySignature.verifySign(e, (Store<X509CertificateHolder>)store, certificateFactory, bl, string, bl2);
            for (SignValidity signValidity : list2) {
                if (SignValidity.SIGN_DETAIL_TYPE.UNKNOWN.equals((Object)signValidity.getValidity())) {
                    list.add(0, signValidity);
                    continue;
                }
                list.add(signValidity);
            }
        }
    }

    public static List<SignValidity> verifySign(Object object, Store<X509CertificateHolder> store, CertificateFactory certificateFactory, boolean bl, String string, boolean bl2) {
        ArrayList<SignValidity> arrayList = new ArrayList<SignValidity>();
        SignerInformation signerInformation = null;
        try {
            ContentVerifierProvider contentVerifierProvider;
            signerInformation = (SignerInformation)object;
            Iterator iterator = store.getMatches((Selector)new CertHolderBySignerIdSelector(signerInformation.getSID())).iterator();
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(((X509CertificateHolder)iterator.next()).getEncoded()));
            if (bl) {
                x509Certificate.checkValidity();
            }
            if (!signerInformation.verify(new SignerInformationVerifier((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider((Provider)new BouncyCastleProvider()).build(x509Certificate), (DigestCalculatorProvider)new BcDigestCalculatorProvider()))) {
                throw new CMSException("Firma no valida");
            }
        }
        catch (CertificateExpiredException certificateExpiredException) {
            arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_EXPIRED, certificateExpiredException));
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_NOT_VALID_YET, certificateNotYetValidException));
        }
        catch (CMSSignerDigestMismatchException cMSSignerDigestMismatchException) {
            if (bl2) {
                arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA, (Exception)((Object)cMSSignerDigestMismatchException)));
            }
        }
        catch (Exception exception) {
            arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CANT_VALIDATE_CERT, exception));
        }
        if (!("CAdES-BES".equals(string) || "No reconocido".equals(string) || "CAdES B-Level".equals(string) || "CAdES B-B-Level".equals(string) || "CMS".equals(string) || "CAdES-EPES".equals(string))) {
            arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, SignValidity.VALIDITY_ERROR.SIGN_PROFILE_NOT_CHECKED));
        }
        if (arrayList.size() == 0) {
            arrayList.add(new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null));
        }
        return arrayList;
    }
}

