/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signvalidation.ISignatureFormatDetector;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class SignatureFormatDetectorXades
implements ISignatureFormatDetector {
    private SignatureFormatDetectorXades() {
    }

    public static String getSignatureFormat(byte[] byArray) {
        String string = "No reconocido";
        if (AOFileUtils.isXML((byte[])byArray)) {
            try {
                Document document = Utils.getNewDocumentBuilder().parse(new ByteArrayInputStream(byArray));
                List<Element> list = SignatureFormatDetectorXades.getListSignatures(document);
                if (SignatureFormatDetectorXades.isXAdESEPES(list)) {
                    string = SignatureFormatDetectorXades.resolveXAdESBaselineFormat("XAdES-EPES", list);
                    if (string.equals("XAdES-EPES")) {
                        string = SignatureFormatDetectorXades.resolveXAdESNoBaselineFormat("XAdES-EPES", list);
                    }
                } else if (SignatureFormatDetectorXades.isXAdESBES(list) && (string = SignatureFormatDetectorXades.resolveXAdESBaselineFormat("XAdES-BES", list)).equals("XAdES-BES")) {
                    string = SignatureFormatDetectorXades.resolveXAdESNoBaselineFormat("XAdES-BES", list);
                }
            }
            catch (Exception exception) {
                string = "No reconocido";
            }
        }
        return string;
    }

    private static String resolveXAdESBaselineFormat(String string, List<Element> list) {
        String string2 = string;
        if (SignatureFormatDetectorXades.isXAdESBLevel(list)) {
            string2 = "XAdES B-Level";
            if (SignatureFormatDetectorXades.isXAdEST(list)) {
                string2 = "XAdES T-Level";
                if (SignatureFormatDetectorXades.isXAdESLTLevel(list)) {
                    string2 = "XAdES LT-Level";
                    if (SignatureFormatDetectorXades.isXAdESLTALevel(list)) {
                        string2 = "XAdES LTA-Level";
                    }
                } else {
                    SignatureFormatDetectorXades.resolveXAdESNoBaselineFormat(string2, list);
                }
            }
        }
        return string2;
    }

    private static String resolveXAdESNoBaselineFormat(String string, List<Element> list) {
        String string2 = string;
        if (SignatureFormatDetectorXades.isXAdESA(list)) {
            string2 = "XAdES-A";
        } else if (SignatureFormatDetectorXades.isXAdESXL1(list)) {
            string2 = "XAdES-XL1";
        } else if (SignatureFormatDetectorXades.isXAdESXL2(list)) {
            string2 = "XAdES-XL2";
        } else if (SignatureFormatDetectorXades.isXAdESX1(list)) {
            string2 = "XAdES-X1";
        } else if (SignatureFormatDetectorXades.isXAdESX2(list)) {
            string2 = "XAdES-X2";
        } else if (SignatureFormatDetectorXades.isXAdESC(list)) {
            string2 = "XAdES-C";
        } else if (SignatureFormatDetectorXades.isXAdEST(list) && !string2.equals("XAdES T-Level")) {
            string2 = "XAdES-T";
        }
        return string2;
    }

    private static Element getXMLElement(Element element, String string, String string2) {
        Element element2 = (Element)element.getElementsByTagNameNS(string, string2).item(0);
        if (element2 == null) {
            element2 = (Element)element.getElementsByTagName(string2).item(0);
        }
        return element2;
    }

    public static boolean hasSignaturePolicyIdentifier(Element element) {
        Element element2;
        Element element3;
        Element element4 = SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "SignedProperties");
        return element4 != null && (element3 = SignatureFormatDetectorXades.getXMLElement(element4, "http://uri.etsi.org/01903/v1.3.2#", "SignedSignatureProperties")) != null && (element2 = SignatureFormatDetectorXades.getXMLElement(element3, "http://uri.etsi.org/01903/v1.3.2#", "SignaturePolicyIdentifier")) != null;
    }

    private static boolean isXAdESLTALevel(List<Element> list) {
        return SignatureFormatDetectorXades.isXAdESA(list);
    }

    private static boolean isXAdESLTALevel(Element element) {
        return SignatureFormatDetectorXades.isXAdESA(element);
    }

    private static boolean isXAdESLTLevel(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (!SignatureFormatDetectorXades.isXAdESLTLevel(element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESLTLevel(Element element) {
        Element element2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        Element element3 = SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedProperties");
        if (element3 != null && (element2 = SignatureFormatDetectorXades.getXMLElement(element3, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties")) != null) {
            bl = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "CertificateValues") != null;
            bl = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "RevocationValues") != null;
            bl2 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.4.1#", "TimeStampValidationData") != null;
            bl3 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "CompleteCertificateRefs") != null;
            bl4 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "CompleteRevocationRefs") != null;
            bl5 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "AttributeCertificateRefs") != null;
            bl6 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "AttributeRevocationRefs") != null;
            bl7 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "SigAndRefsTimeStamp") != null;
            boolean bl9 = bl8 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "RefsOnlyTimeStamp") != null;
            if (SignatureFormatDetectorXades.checkLTLevel(bl, false, bl2, bl3, bl4, bl5, bl6, bl7, bl8)) {
                return true;
            }
        }
        return false;
    }

    private static boolean checkLTLevel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        return (bl && bl2 || bl3) && !bl4 && !bl5 && !bl6 && !bl7 && !bl8 && !bl9;
    }

    private static boolean isXAdESBLevel(List<Element> list) {
        Iterator<Element> iterator;
        if (!list.isEmpty() && (iterator = list.iterator()).hasNext()) {
            Element element = iterator.next();
            return SignatureFormatDetectorXades.isXAdESBLevel(element);
        }
        return false;
    }

    private static boolean isXAdESBLevel(Element element) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (element.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "QualifyingPropertiesReference").getLength() == 0) {
            Element element2 = null;
            if (element.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedProperties").getLength() > 0) {
                element2 = (Element)element.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedProperties").item(0);
                Element element3 = null;
                if (element2.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedSignatureProperties").getLength() > 0) {
                    element3 = (Element)element.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedSignatureProperties").item(0);
                    bl = element3.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SigningCertificate").getLength() > 0;
                    bl2 = element3.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SigningTime").getLength() > 0;
                }
                Element element4 = null;
                if (element2.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedDataObjectProperties").getLength() > 0) {
                    element4 = (Element)element2.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedDataObjectProperties").item(0);
                    Element element5 = SignatureFormatDetectorXades.getXMLElement(element4, "http://uri.etsi.org/01903/v1.3.2#", "DataObjectFormat");
                    boolean bl5 = bl3 = element5 != null;
                    if (element5 != null) {
                        bl3 = true;
                        boolean bl6 = bl4 = element5.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "MimeType").getLength() > 0;
                    }
                }
                if (bl2 && bl && bl3 && bl4) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isXAdESBBLevel(Element element) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (element.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "QualifyingPropertiesReference").getLength() == 0) {
            Element element2 = null;
            if (element.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedProperties").getLength() > 0) {
                element2 = (Element)element.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedProperties").item(0);
                Element element3 = null;
                if (element2.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedSignatureProperties").getLength() > 0) {
                    element3 = (Element)element.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedSignatureProperties").item(0);
                    bl = element3.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SigningCertificateV2").getLength() > 0;
                    bl2 = element3.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SigningTime").getLength() > 0;
                }
                Element element4 = null;
                if (element2.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedDataObjectProperties").getLength() > 0) {
                    element4 = (Element)element2.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedDataObjectProperties").item(0);
                    Element element5 = SignatureFormatDetectorXades.getXMLElement(element4, "http://uri.etsi.org/01903/v1.3.2#", "DataObjectFormat");
                    boolean bl5 = bl3 = element5 != null;
                    if (element5 != null) {
                        bl3 = true;
                        boolean bl6 = bl4 = element5.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "MimeType").getLength() > 0;
                    }
                }
                if (bl2 && bl && bl3 && bl4) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isXAdESA(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (!SignatureFormatDetectorXades.isXAdESA(element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESA(Element element) {
        Element element2;
        Element element3 = SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedProperties");
        if (element3 != null && (element2 = SignatureFormatDetectorXades.getXMLElement(element3, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties")) != null) {
            NodeList nodeList = element2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1 || !nodeList.item(i).getLocalName().equals("ArchiveTimeStamp")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESXL1(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (!SignatureFormatDetectorXades.isXAdESXL1(element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESXL1(Element element) {
        Element element2;
        Element element3 = SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedProperties");
        if (element3 != null && (element2 = SignatureFormatDetectorXades.getXMLElement(element3, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties")) != null) {
            Element element4 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "SigAndRefsTimeStamp");
            Element element5 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "CertificateValues");
            Element element6 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "RevocationValues");
            if (element4 != null && element5 != null && element6 != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESXL2(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (!SignatureFormatDetectorXades.isXAdESXL2(element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESXL2(Element element) {
        Element element2;
        Element element3 = SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedProperties");
        if (element3 != null && (element2 = SignatureFormatDetectorXades.getXMLElement(element3, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties")) != null) {
            Element element4 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "RefsOnlyTimeStamp");
            Element element5 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "CertificateValues");
            Element element6 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "RevocationValues");
            if (element4 != null && element5 != null && element6 != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESX1(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (!SignatureFormatDetectorXades.isXAdESX1(element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESX1(Element element) {
        Element element2;
        Element element3;
        Element element4 = SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedProperties");
        return element4 != null && (element3 = SignatureFormatDetectorXades.getXMLElement(element4, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties")) != null && (element2 = SignatureFormatDetectorXades.getXMLElement(element3, "http://uri.etsi.org/01903/v1.3.2#", "SigAndRefsTimeStamp")) != null;
    }

    private static boolean isXAdESX2(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (!SignatureFormatDetectorXades.isXAdESX2(element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESX2(Element element) {
        Element element2;
        Element element3;
        Element element4 = SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedProperties");
        return element4 != null && (element3 = SignatureFormatDetectorXades.getXMLElement(element4, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties")) != null && (element2 = SignatureFormatDetectorXades.getXMLElement(element3, "http://uri.etsi.org/01903/v1.3.2#", "RefsOnlyTimeStamp")) != null;
    }

    private static boolean isXAdESC(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (!SignatureFormatDetectorXades.isXAdESC(element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESC(Element element) {
        Element element2;
        Element element3 = SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedProperties");
        if (element3 != null && (element2 = SignatureFormatDetectorXades.getXMLElement(element3, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties")) != null) {
            Element element4 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "CompleteCertificateRefs");
            Element element5 = SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "CompleteRevocationRefs");
            if (element4 != null && element5 != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESEPES(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (!SignatureFormatDetectorXades.hasSignaturePolicyIdentifier(element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESBES(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "QualifyingProperties") == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdESBES(Element element) {
        return SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "QualifyingProperties") != null;
    }

    private static boolean isXAdEST(List<Element> list) {
        if (!list.isEmpty()) {
            for (Element element : list) {
                if (!SignatureFormatDetectorXades.isXAdEST(element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isXAdEST(Element element) {
        Element element2;
        Element element3 = SignatureFormatDetectorXades.getXMLElement(element, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedProperties");
        return element3 != null && (element2 = SignatureFormatDetectorXades.getXMLElement(element3, "http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties")) != null && SignatureFormatDetectorXades.getXMLElement(element2, "http://uri.etsi.org/01903/v1.3.2#", "SignatureTimeStamp") != null;
    }

    public static String resolveSignerXAdESFormat(Element element) {
        String string = "No reconocido";
        if (element != null) {
            if (SignatureFormatDetectorXades.isXAdESEPES(element)) {
                string = SignatureFormatDetectorXades.resolveXAdESBaselineFormat("XAdES-EPES", element);
                if (string.equals("XAdES-EPES")) {
                    string = SignatureFormatDetectorXades.resolveXAdESNoBaselineFormat("XAdES-EPES", element);
                }
            } else if (SignatureFormatDetectorXades.isXAdESBES(element) && (string = SignatureFormatDetectorXades.resolveXAdESBaselineFormat("XAdES-BES", element)).equals("XAdES-BES")) {
                string = SignatureFormatDetectorXades.resolveXAdESNoBaselineFormat("XAdES-BES", element);
            }
        }
        return string;
    }

    private static boolean isXAdESEPES(Element element) {
        return SignatureFormatDetectorXades.hasSignaturePolicyIdentifier(element);
    }

    private static String resolveXAdESBaselineFormat(String string, Element element) {
        String string2 = string;
        if (SignatureFormatDetectorXades.isXAdESBLevel(element)) {
            string2 = "XAdES B-Level";
            if (SignatureFormatDetectorXades.isXAdEST(element)) {
                string2 = "XAdES T-Level";
                if (SignatureFormatDetectorXades.isXAdESLTLevel(element)) {
                    string2 = "XAdES LT-Level";
                    if (SignatureFormatDetectorXades.isXAdESLTALevel(element)) {
                        string2 = "XAdES LTA-Level";
                    }
                } else {
                    SignatureFormatDetectorXades.resolveXAdESNoBaselineFormat(string2, element);
                }
            }
        } else if (SignatureFormatDetectorXades.isXAdESBBLevel(element)) {
            string2 = "XAdES B-B-Level";
        }
        return string2;
    }

    private static String resolveXAdESNoBaselineFormat(String string, Element element) {
        String string2 = string;
        if (SignatureFormatDetectorXades.isXAdESA(element)) {
            string2 = "XAdES-A";
        } else if (SignatureFormatDetectorXades.isXAdESXL1(element)) {
            string2 = "XAdES-XL1";
        } else if (SignatureFormatDetectorXades.isXAdESXL2(element)) {
            string2 = "XAdES-XL2";
        } else if (SignatureFormatDetectorXades.isXAdESX1(element)) {
            string2 = "XAdES-X1";
        } else if (SignatureFormatDetectorXades.isXAdESX2(element)) {
            string2 = "XAdES-X2";
        } else if (SignatureFormatDetectorXades.isXAdESC(element)) {
            string2 = "XAdES-C";
        } else if (SignatureFormatDetectorXades.isXAdEST(element) && !string2.equals("XAdES T-Level")) {
            string2 = "XAdES-T";
        }
        return string2;
    }

    public static boolean isXAdESBaseline(String string) {
        return string.equals("XAdES B-Level") || string.equals("XAdES T-Level") || string.equals("XAdES LT-Level") || string.equals("XAdES LTA-Level");
    }

    public static List<Element> getListSignatures(Document document) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element.getParentNode() != null && ("XMLTimeStamp".equals(element.getParentNode().getLocalName()) || "XMLTimeStamp".equals(element.getParentNode().getLocalName()))) continue;
                arrayList.add(element);
            }
        }
        return arrayList;
    }
}

