/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import com.aowagie.text.pdf.AcroFields;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfReader;
import es.gob.afirma.signvalidation.ISignatureFormatDetector;
import es.gob.afirma.signvalidation.PDFSignatureDictionary;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSObjectIdentifiers;
import org.spongycastle.asn1.esf.ESFAttributes;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.cms.SignerInformation;
import org.spongycastle.cms.SignerInformationStore;
import org.spongycastle.util.CollectionStore;

public class SignatureFormatDetectorPadesCades
implements ISignatureFormatDetector {
    private static final ASN1ObjectIdentifier ID_ATTRIBUTE_CERTIFICATE_REFERENCES = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.44");
    private static final ASN1ObjectIdentifier ID_ATTRIBUTE_REVOCATION_REFERENCES = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.45");
    private static final ASN1ObjectIdentifier ID_LONG_TERM_VALIDATION = new ASN1ObjectIdentifier("0.4.0.1733.2.2");
    private static final ASN1ObjectIdentifier ID_ARCHIVE_TIME_STAMP_V3 = new ASN1ObjectIdentifier("0.4.0.1733.2.4");
    public static final PdfName DSS_DICTIONARY_NAME = new PdfName("DSS");
    public static final PdfName CADES_SUBFILTER_VALUE = new PdfName("ETSI.CAdES.detached");
    public static final PdfName TST_SUBFILTER_VALUE = new PdfName("ETSI.RFC3161");
    public static final PdfName DOC_TIME_STAMP_DICTIONARY_NAME = new PdfName("DocTimeStamp");
    static String FORMAT_CADES_BES = "CAdES-BES";
    static String FORMAT_CMS = "CMS";
    static String FORMAT_CMS_T = "CMS-T";

    private static boolean isPAdESBLevel(PDFSignatureDictionary pDFSignatureDictionary) {
        PdfDictionary pdfDictionary = pDFSignatureDictionary.getDictionary();
        PdfName pdfName = pDFSignatureDictionary.getDictionary().getAsName(PdfName.SUBFILTER);
        if (pdfName.equals((Object)CADES_SUBFILTER_VALUE) && pdfDictionary.get(PdfName.M) != null) {
            try {
                CMSSignedData cMSSignedData = SignatureFormatDetectorPadesCades.getCMSSignature(pDFSignatureDictionary);
                for (SignerInformation signerInformation : cMSSignedData.getSignerInfos().getSigners()) {
                    AttributeTable attributeTable = signerInformation.getSignedAttributes();
                    if (attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate) == null) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static boolean isPAdESBBLevel(PDFSignatureDictionary pDFSignatureDictionary) {
        PdfDictionary pdfDictionary = pDFSignatureDictionary.getDictionary();
        PdfName pdfName = pDFSignatureDictionary.getDictionary().getAsName(PdfName.SUBFILTER);
        if (pdfName.equals((Object)CADES_SUBFILTER_VALUE) && pdfDictionary.get(PdfName.M) != null) {
            try {
                CMSSignedData cMSSignedData = SignatureFormatDetectorPadesCades.getCMSSignature(pDFSignatureDictionary);
                for (SignerInformation signerInformation : cMSSignedData.getSignerInfos().getSigners()) {
                    AttributeTable attributeTable = signerInformation.getSignedAttributes();
                    if (attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2) == null) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static boolean isPAdESTLevel(PDFSignatureDictionary pDFSignatureDictionary, PdfReader pdfReader) {
        try {
            int n = 0;
            int n2 = 0;
            CMSSignedData cMSSignedData = SignatureFormatDetectorPadesCades.getCMSSignature(pDFSignatureDictionary);
            if (!cMSSignedData.getCertificates().getMatches(null).isEmpty()) {
                SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
                List list = (List)signerInformationStore.getSigners();
                SignerInformation signerInformation = (SignerInformation)list.get(0);
                if (signerInformation.getUnsignedAttributes() != null && signerInformation.getUnsignedAttributes().getAll(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken) != null) {
                    n = signerInformation.getUnsignedAttributes().getAll(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken).size();
                }
                n2 = SignatureFormatDetectorPadesCades.countDocumentTimeStampDictionaries(pdfReader);
                if (n == 1 && n2 == 0 || n == 0 && n2 == 1) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isPAdESLTLevel(PDFSignatureDictionary pDFSignatureDictionary, PdfReader pdfReader) {
        if (SignatureFormatDetectorPadesCades.isPAdESTLevel(pDFSignatureDictionary, pdfReader)) {
            if (pdfReader.getCatalog().get(DSS_DICTIONARY_NAME) != null) {
                return true;
            }
            AcroFields acroFields = pdfReader.getAcroFields();
            List list = acroFields.getSignatureNames();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                try {
                    PdfReader pdfReader2 = new PdfReader(acroFields.extractRevision(string));
                    if (pdfReader2.getCatalog().getAsDict(DSS_DICTIONARY_NAME) == null) continue;
                    return true;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean isPAdESLTALevel(PDFSignatureDictionary pDFSignatureDictionary, PdfReader pdfReader) {
        int n = 0;
        int n2 = 0;
        try {
            CMSSignedData cMSSignedData = SignatureFormatDetectorPadesCades.getCMSSignature(pDFSignatureDictionary);
            if (!cMSSignedData.getCertificates().getMatches(null).isEmpty()) {
                SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
                List list = (List)signerInformationStore.getSigners();
                SignerInformation signerInformation = (SignerInformation)list.get(0);
                if (signerInformation.getUnsignedAttributes() != null && signerInformation.getUnsignedAttributes().getAll(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken) != null) {
                    n = signerInformation.getUnsignedAttributes().getAll(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken).size();
                }
                n2 = SignatureFormatDetectorPadesCades.countDocumentTimeStampDictionaries(pdfReader);
                if (n > 1 || n2 > 1) {
                    if (pdfReader.getCatalog().get(DSS_DICTIONARY_NAME) != null) {
                        return true;
                    }
                    AcroFields acroFields = pdfReader.getAcroFields();
                    List list2 = acroFields.getSignatureNames();
                    for (int i = 0; i < list2.size(); ++i) {
                        String string = (String)list2.get(i);
                        PdfReader pdfReader2 = new PdfReader(acroFields.extractRevision(string));
                        if (pdfReader2.getCatalog().getAsDict(DSS_DICTIONARY_NAME) == null) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int countDocumentTimeStampDictionaries(PdfReader pdfReader) {
        int n = 0;
        AcroFields acroFields = pdfReader.getAcroFields();
        List list = acroFields.getSignatureNames();
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2 = (String)list.get(i);
            PdfDictionary pdfDictionary = acroFields.getSignatureDictionary(string2);
            String string3 = null;
            if (pdfDictionary.get(PdfName.TYPE) != null) {
                string3 = pdfDictionary.get(PdfName.TYPE).toString();
            }
            if (!(string = pdfDictionary.get(PdfName.SUBFILTER).toString()).equalsIgnoreCase(TST_SUBFILTER_VALUE.toString()) || string3 != null && !string3.equals(DOC_TIME_STAMP_DICTIONARY_NAME.toString())) continue;
            ++n;
        }
        return n;
    }

    public static String resolvePDFFormat(byte[] byArray) {
        String string;
        block14: {
            string = "No reconocido";
            try {
                PdfReader pdfReader = new PdfReader(byArray);
                PDFSignatureDictionary pDFSignatureDictionary = SignatureFormatDetectorPadesCades.obtainLatestSignatureFromPDF(pdfReader);
                if (SignatureFormatDetectorPadesCades.isPAdESBLevel(pDFSignatureDictionary)) {
                    string = "PAdES B-Level";
                    if (SignatureFormatDetectorPadesCades.isPAdESLTALevel(pDFSignatureDictionary, pdfReader)) {
                        string = "PAdES LTA-Level";
                    } else if (SignatureFormatDetectorPadesCades.isPAdESLTLevel(pDFSignatureDictionary, pdfReader)) {
                        string = "PAdES LT-Level";
                    } else if (SignatureFormatDetectorPadesCades.isPAdESTLevel(pDFSignatureDictionary, pdfReader)) {
                        string = "PAdES T-Level";
                    }
                    break block14;
                }
                if (SignatureFormatDetectorPadesCades.isPAdESBBLevel(pDFSignatureDictionary)) {
                    string = "PAdES B-B-Level";
                    if (SignatureFormatDetectorPadesCades.isPAdESLTALevel(pDFSignatureDictionary, pdfReader)) {
                        string = "PAdES LTA-Level";
                    } else if (SignatureFormatDetectorPadesCades.isPAdESLTLevel(pDFSignatureDictionary, pdfReader)) {
                        string = "PAdES LT-Level";
                    } else if (SignatureFormatDetectorPadesCades.isPAdESTLevel(pDFSignatureDictionary, pdfReader)) {
                        string = "PAdES T-Level";
                    }
                    break block14;
                }
                return SignatureFormatDetectorPadesCades.getFormatOfPAdESSignature(pDFSignatureDictionary, pdfReader);
            }
            catch (Exception exception) {
                string = "No reconocido";
            }
        }
        return string;
    }

    private static String getFormatOfPAdESSignature(PDFSignatureDictionary pDFSignatureDictionary, PdfReader pdfReader) {
        String string = "No reconocido";
        if (SignatureFormatDetectorPadesCades.isPAdESLTV(pdfReader)) {
            string = "PAdES-LTV";
        } else if (SignatureFormatDetectorPadesCades.isPAdESEPES(pDFSignatureDictionary)) {
            string = "PAdES-EPES";
        } else if (SignatureFormatDetectorPadesCades.isPAdESBES(pDFSignatureDictionary)) {
            string = "PAdES-BES";
        } else if (SignatureFormatDetectorPadesCades.isPAdESBasic(pDFSignatureDictionary)) {
            string = "PAdES-Basic";
        } else if (SignatureFormatDetectorPadesCades.isPDF(pDFSignatureDictionary)) {
            string = "PDF";
        }
        return string;
    }

    public static boolean isPAdESEPES(PDFSignatureDictionary pDFSignatureDictionary) {
        PdfName pdfName = pDFSignatureDictionary.getDictionary().getAsName(PdfName.SUBFILTER);
        if (pdfName.equals((Object)CADES_SUBFILTER_VALUE)) {
            try {
                CMSSignedData cMSSignedData = SignatureFormatDetectorPadesCades.getCMSSignature(pDFSignatureDictionary);
                SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
                List list = (List)signerInformationStore.getSigners();
                return SignatureFormatDetectorPadesCades.isCAdESEPES(list);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static boolean isPAdESBES(PDFSignatureDictionary pDFSignatureDictionary) {
        PdfName pdfName = pDFSignatureDictionary.getDictionary().getAsName(PdfName.SUBFILTER);
        if (pdfName.equals((Object)CADES_SUBFILTER_VALUE)) {
            try {
                CMSSignedData cMSSignedData = SignatureFormatDetectorPadesCades.getCMSSignature(pDFSignatureDictionary);
                SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
                List list = (List)signerInformationStore.getSigners();
                SignerInformation signerInformation = (SignerInformation)list.get(0);
                if (!SignatureFormatDetectorPadesCades.hasSignaturePolicyIdentifier(signerInformation)) {
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static boolean isPAdESBasic(PDFSignatureDictionary pDFSignatureDictionary) {
        PdfName pdfName = (PdfName)pDFSignatureDictionary.getDictionary().get(PdfName.SUBFILTER);
        return pdfName.equals((Object)PdfName.ADBE_PKCS7_DETACHED) || pdfName.equals((Object)PdfName.ADBE_PKCS7_SHA1);
    }

    public static boolean isPDF(PDFSignatureDictionary pDFSignatureDictionary) {
        PdfName pdfName = (PdfName)pDFSignatureDictionary.getDictionary().get(PdfName.SUBFILTER);
        return !pdfName.equals((Object)PdfName.ADBE_PKCS7_DETACHED) && !pdfName.equals((Object)PdfName.ADBE_PKCS7_SHA1) && !pdfName.equals((Object)CADES_SUBFILTER_VALUE);
    }

    private static boolean isPAdESLTV(PdfReader pdfReader) {
        if (pdfReader.getCatalog().get(DSS_DICTIONARY_NAME) != null) {
            return true;
        }
        return SignatureFormatDetectorPadesCades.countDocumentTimeStampDictionaries(pdfReader) > 0;
    }

    public static CMSSignedData getCMSSignature(PDFSignatureDictionary pDFSignatureDictionary) throws Exception {
        byte[] byArray = pDFSignatureDictionary.getDictionary().getAsString(PdfName.CONTENTS).getOriginalBytes();
        CMSSignedData cMSSignedData = null;
        cMSSignedData = new CMSSignedData(byArray);
        if (cMSSignedData.getSignerInfos().getSigners().size() == 0) {
            throw new Exception("No existen firmantes en el documento");
        }
        return cMSSignedData;
    }

    public static PDFSignatureDictionary obtainLatestSignatureFromPDF(PdfReader pdfReader) {
        PDFSignatureDictionary pDFSignatureDictionary = null;
        int n = -1;
        AcroFields acroFields = pdfReader.getAcroFields();
        List list = acroFields.getSignatureNames();
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            String string;
            String string2 = (String)list.get(i);
            PdfDictionary pdfDictionary = acroFields.getSignatureDictionary(string2);
            String string3 = null;
            if (pdfDictionary.get(PdfName.TYPE) != null) {
                string3 = pdfDictionary.get(PdfName.TYPE).toString();
            }
            if ((string = pdfDictionary.get(PdfName.SUBFILTER).toString()).equalsIgnoreCase(new PdfName("ETSI.RFC3161").toString()) || string3 != null && !string3.equalsIgnoreCase(PdfName.SIG.toString()) || (n2 = acroFields.getRevision(string2)) <= n) continue;
            n = n2;
            pDFSignatureDictionary = new PDFSignatureDictionary(n2, pdfDictionary, string2);
        }
        return pDFSignatureDictionary;
    }

    private static boolean isCAdESEPES(List<SignerInformation> list) {
        if (list != null && list.size() > 0) {
            for (SignerInformation signerInformation : list) {
                if (SignatureFormatDetectorPadesCades.isCAdESEPES(signerInformation)) {
                    return true;
                }
                SignerInformationStore signerInformationStore = signerInformation.getCounterSignatures();
                if (signerInformationStore == null || signerInformationStore.size() <= 0 || !SignatureFormatDetectorPadesCades.isCAdESEPES((List)signerInformationStore.getSigners())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isCAdESEPES(SignerInformation signerInformation) {
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        return attributeTable != null && attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId) != null;
    }

    public static boolean isASN1Format(byte[] byArray) {
        try {
            CMSSignedData cMSSignedData = new CMSSignedData(byArray);
            cMSSignedData.getSignedContent().getContentType();
            return cMSSignedData.getSignedContent() == null || CMSObjectIdentifiers.signedData.equals((Object)cMSSignedData.getSignedContent().getContentType());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String resolveASN1Format(CMSSignedData cMSSignedData, SignerInformation signerInformation) {
        String string = "No reconocido";
        try {
            if (SignatureFormatDetectorPadesCades.isCMS(signerInformation)) {
                string = FORMAT_CMS;
                if (SignatureFormatDetectorPadesCades.isCAdEST(signerInformation)) {
                    string = FORMAT_CMS_T;
                }
            } else if (SignatureFormatDetectorPadesCades.isCAdESEPES(signerInformation)) {
                string = SignatureFormatDetectorPadesCades.resolveFormatOfCAdESEPESSignature(cMSSignedData, signerInformation);
            } else if (SignatureFormatDetectorPadesCades.isCAdESBES(signerInformation)) {
                string = FORMAT_CADES_BES;
                if (SignatureFormatDetectorPadesCades.isCAdESBLevel(signerInformation)) {
                    string = "CAdES B-Level";
                    if (SignatureFormatDetectorPadesCades.isCAdEST(signerInformation)) {
                        string = "CAdES T-Level";
                        if (SignatureFormatDetectorPadesCades.isCAdESLTLevel(signerInformation, cMSSignedData)) {
                            string = "CAdES LT-Level";
                            if (SignatureFormatDetectorPadesCades.isCAdESLTALevel(signerInformation)) {
                                string = "CAdES LTA-Level";
                            }
                        } else {
                            string = SignatureFormatDetectorPadesCades.resolveCAdESNoBaselineFormat(string, signerInformation);
                        }
                    } else {
                        string = SignatureFormatDetectorPadesCades.resolveCAdESNoBaselineFormat(string, signerInformation);
                    }
                }
            } else if (SignatureFormatDetectorPadesCades.isCAdESBBLevel(signerInformation)) {
                string = "CAdES B-B-Level";
                if (SignatureFormatDetectorPadesCades.isCAdEST(signerInformation)) {
                    string = "CAdES T-Level";
                    if (SignatureFormatDetectorPadesCades.isCAdESLTLevel(signerInformation, cMSSignedData)) {
                        string = "CAdES LT-Level";
                        if (SignatureFormatDetectorPadesCades.isCAdESLTALevel(signerInformation)) {
                            string = "CAdES LTA-Level";
                        }
                    } else {
                        string = SignatureFormatDetectorPadesCades.resolveCAdESNoBaselineFormat(string, signerInformation);
                    }
                } else {
                    string = SignatureFormatDetectorPadesCades.resolveCAdESNoBaselineFormat(string, signerInformation);
                }
            }
        }
        catch (Exception exception) {
            string = "No reconocido";
        }
        return string;
    }

    private static boolean isCMS(SignerInformation signerInformation) {
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        return attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate) == null && attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2) == null && attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_otherSigCert) == null;
    }

    private static boolean isCAdEST(SignerInformation signerInformation) {
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        return attributeTable != null && attributeTable.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken) != null;
    }

    private static String resolveFormatOfCAdESEPESSignature(CMSSignedData cMSSignedData, SignerInformation signerInformation) {
        String string = "CAdES-EPES";
        if (SignatureFormatDetectorPadesCades.isCAdESBLevel(signerInformation)) {
            string = "CAdES B-Level";
            if (SignatureFormatDetectorPadesCades.isCAdEST(signerInformation)) {
                string = "CAdES T-Level";
                if (SignatureFormatDetectorPadesCades.isCAdESLTLevel(signerInformation, cMSSignedData)) {
                    string = "CAdES LT-Level";
                    if (SignatureFormatDetectorPadesCades.isCAdESLTALevel(signerInformation)) {
                        string = "CAdES LTA-Level";
                    }
                }
            }
        } else {
            string = SignatureFormatDetectorPadesCades.resolveCAdESNoBaselineFormat(string, signerInformation);
        }
        return string;
    }

    private static String resolveCAdESNoBaselineFormat(String string, SignerInformation signerInformation) {
        String string2 = string;
        if (!string2.equals("CAdES T-Level") && SignatureFormatDetectorPadesCades.isCAdEST(signerInformation)) {
            string2 = "CAdES-T";
        }
        return string2;
    }

    public static boolean hasSignaturePolicyIdentifier(SignerInformation signerInformation) {
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        return attributeTable != null && attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId) != null;
    }

    private static boolean isCAdESBES(SignerInformation signerInformation) {
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        return attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate) != null || attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2) != null || attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_otherSigCert) != null;
    }

    private static boolean isCAdESBBLevel(SignerInformation signerInformation) {
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        return attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2) != null;
    }

    private static boolean isCAdESBLevel(SignerInformation signerInformation) {
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        return attributeTable.get(PKCSObjectIdentifiers.pkcs_9_at_signingTime) != null;
    }

    private static boolean isCAdESLTLevel(SignerInformation signerInformation, CMSSignedData cMSSignedData) {
        Iterator iterator;
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        CollectionStore collectionStore = (CollectionStore)cMSSignedData.getCRLs();
        return SignatureFormatDetectorPadesCades.checkUnsignedAttributesForCAdESLTLevel(attributeTable) && collectionStore != null && (iterator = collectionStore.iterator()).hasNext();
    }

    private static boolean checkUnsignedAttributesForCAdESLTLevel(AttributeTable attributeTable) {
        if (attributeTable != null) {
            if (attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_certificateRefs) != null) {
                return false;
            }
            if (attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_revocationRefs) != null) {
                return false;
            }
            if (attributeTable.get(ID_ATTRIBUTE_CERTIFICATE_REFERENCES) != null) {
                return false;
            }
            if (attributeTable.get(ID_ATTRIBUTE_REVOCATION_REFERENCES) != null) {
                return false;
            }
            if (attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp) != null) {
                return false;
            }
            if (attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp) != null) {
                return false;
            }
            if (attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_certValues) != null) {
                return false;
            }
            return SignatureFormatDetectorPadesCades.checkUnsignedAttributesForCAdESLTLevelAux(attributeTable);
        }
        return true;
    }

    private static boolean checkUnsignedAttributesForCAdESLTLevelAux(AttributeTable attributeTable) {
        if (attributeTable.get(PKCSObjectIdentifiers.id_aa_ets_revocationValues) != null) {
            return false;
        }
        if (attributeTable.get(ESFAttributes.archiveTimestamp) != null) {
            return false;
        }
        if (attributeTable.get(ESFAttributes.archiveTimestampV2) != null) {
            return false;
        }
        return attributeTable.get(ID_LONG_TERM_VALIDATION) == null;
    }

    private static boolean isCAdESLTALevel(SignerInformation signerInformation) {
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        return attributeTable != null && attributeTable.get(ID_ARCHIVE_TIME_STAMP_V3) != null;
    }
}

