/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

public final class SignValidity {
    private final SIGN_DETAIL_TYPE validity;
    private final VALIDITY_ERROR error;
    private final Exception errorException;

    public String toString() {
        String string = this.validityTypeToString();
        if (this.error == null) {
            return string;
        }
        switch (this.error) {
            case NO_DATA: {
                return string + ": no se puede comprobar la validez por no tener los datos firmados";
            }
            case CORRUPTED_SIGN: {
                return string + ": la informaci&oacute;n contenida en la firma no es consistente (certificados corruptos, etc.)";
            }
            case NO_MATCH_DATA: {
                return string + ": la firma no se corresponde con los datos firmados";
            }
            case NO_SIGN: {
                return string + ": no se encuentra la firma dentro del documento";
            }
            case CERTIFICATE_PROBLEM: {
                return string + ": no se puede extraer un certificado o este no es v&aacute;lido";
            }
            case CERTIFICATE_EXPIRED: {
                return string + ": existe un certificado de firma caducado";
            }
            case CERTIFICATE_NOT_VALID_YET: {
                return string + ": existe un certificado de firma que aun no es v&aacute;lido";
            }
            case CANT_VALIDATE_CERT: {
                return string + ": no se ha podido validar el certificado correctamente";
            }
            case ALGORITHM_NOT_SUPPORTED: {
                return string + ": la firma contiene un algoritmo no reconocido o no soportado";
            }
            case CA_NOT_SUPPORTED: {
                return string + ": no se soporta la CA de expedici&oacute;n";
            }
            case CRL_PROBLEM: {
                return string + ": existe algun problema con las CRLs incrustadas en la firma";
            }
            case PDF_UNKOWN_VALIDITY: {
                return string + ": no se puede comprobar la validez de la firma PDF";
            }
            case OOXML_UNKOWN_VALIDITY: {
                return string + ": no se puede comprobar la validez de la firma OOXML";
            }
            case ODF_UNKOWN_VALIDITY: {
                return string + ": no se puede comprobar la validez de la firma ODF";
            }
            case UNKOWN_ERROR: {
                return string + ": no se puede comprobar la validez de la firma";
            }
            case UNKOWN_SIGNATURE_FORMAT: {
                return string + ": los datos proporcionados no se corresponden con ning&uacute;n formato de firma reconocido";
            }
            case MODIFIED_DOCUMENT: {
                return string + ": el documento PDF es sospechoso de haberse modificado tras la firma";
            }
            case OVERLAPPING_SIGNATURE: {
                return string + ": las firmas del documento se solapan pudiendo ocultar informaci&oacute;n";
            }
            case MODIFIED_FORM: {
                return string + ": un formulario del documento fue modificado tras la firma";
            }
            case SUSPECTED_SIGNATURE: {
                return string + ": el documento es sospechoso y el usuario debe revisar la firma";
            }
            case SIGN_PROFILE_NOT_CHECKED: {
                return string + ": la firma contiene atributos longevos que Autofirma no puede validar. Para una validaci&oacute;n completa recurra a VALIDe.";
            }
            case CANT_VALIDATE_EXTERNALLY_DETACHED: {
                return string + ": no se permite la validaci&oacute;n de firmas con referencias externas";
            }
            case BAD_BUILD_SIGN: {
                return string + ": la firma no est&aacute; correctamente formada";
            }
            case CERTIFIED_SIGN_REVISION: {
                return string + ": El documento certificado no permit&iacute;a nuevas firmas";
            }
        }
        return string;
    }

    public SignValidity(SIGN_DETAIL_TYPE sIGN_DETAIL_TYPE, VALIDITY_ERROR vALIDITY_ERROR, Exception exception) {
        this.validity = sIGN_DETAIL_TYPE;
        this.error = vALIDITY_ERROR;
        this.errorException = exception;
    }

    public SignValidity(SIGN_DETAIL_TYPE sIGN_DETAIL_TYPE, VALIDITY_ERROR vALIDITY_ERROR) {
        this(sIGN_DETAIL_TYPE, vALIDITY_ERROR, null);
    }

    public SIGN_DETAIL_TYPE getValidity() {
        return this.validity;
    }

    public VALIDITY_ERROR getError() {
        return this.error;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public String validityTypeToString() {
        if (this.validity.equals((Object)SIGN_DETAIL_TYPE.OK) || this.validity.equals((Object)SIGN_DETAIL_TYPE.GENERATED)) {
            return "Firma valida";
        }
        if (this.validity.equals((Object)SIGN_DETAIL_TYPE.UNKNOWN)) {
            return "Validaci\u00f3n incompleta";
        }
        if (this.validity.equals((Object)SIGN_DETAIL_TYPE.PENDING_CONFIRM_BY_USER)) {
            return "Validez a confirmar por el usuario";
        }
        if (this.validity.equals((Object)SIGN_DETAIL_TYPE.KO)) {
            return "Firma no valida";
        }
        return null;
    }

    public static enum VALIDITY_ERROR {
        NO_DATA,
        CORRUPTED_SIGN,
        NO_MATCH_DATA,
        NO_SIGN,
        CERTIFICATE_PROBLEM,
        CERTIFICATE_EXPIRED,
        CERTIFICATE_NOT_VALID_YET,
        CANT_VALIDATE_CERT,
        ALGORITHM_NOT_SUPPORTED,
        CA_NOT_SUPPORTED,
        CRL_PROBLEM,
        PDF_UNKOWN_VALIDITY,
        OOXML_UNKOWN_VALIDITY,
        ODF_UNKOWN_VALIDITY,
        UNKOWN_ERROR,
        UNKOWN_SIGNATURE_FORMAT,
        MODIFIED_FORM,
        MODIFIED_DOCUMENT,
        OVERLAPPING_SIGNATURE,
        SUSPECTED_SIGNATURE,
        SIGN_PROFILE_NOT_CHECKED,
        CANT_VALIDATE_EXTERNALLY_DETACHED,
        BAD_BUILD_SIGN,
        CERTIFIED_SIGN_REVISION;

    }

    public static enum SIGN_DETAIL_TYPE {
        OK,
        KO,
        UNKNOWN,
        PENDING_CONFIRM_BY_USER,
        GENERATED;

    }
}

