/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.pades.AOPDFSigner;
import es.gob.afirma.signers.xades.AOFacturaESigner;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signvalidation.DataAnalizerUtil;
import es.gob.afirma.signvalidation.SignValider;
import java.util.logging.Logger;

public final class SignValiderFactory {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String SIGNER_VALIDER_CLASS_BINARY = "es.gob.afirma.signvalidation.ValidateBinarySignature";
    private static final String SIGNER_VALIDER_CLASS_PDF = "es.gob.afirma.signvalidation.ValidatePdfSignature";
    private static final String SIGNER_VALIDER_CLASS_XML = "es.gob.afirma.signvalidation.ValidateXMLSignature";

    private SignValiderFactory() {
    }

    public static SignValider getSignValider(byte[] byArray) throws IllegalArgumentException {
        String string;
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("No se han indicado datos de firma");
        }
        if (DataAnalizerUtil.isPDF(byArray)) {
            string = SIGNER_VALIDER_CLASS_PDF;
        } else if (DataAnalizerUtil.isFacturae(byArray)) {
            string = SIGNER_VALIDER_CLASS_XML;
        } else if (DataAnalizerUtil.isXML(byArray)) {
            string = SIGNER_VALIDER_CLASS_XML;
        } else {
            if (DataAnalizerUtil.isOOXML(byArray)) {
                LOGGER.warning("No hay un validador para OOXML");
                return null;
            }
            if (DataAnalizerUtil.isODF(byArray)) {
                LOGGER.warning("No hay un validador para ODF");
                return null;
            }
            string = SIGNER_VALIDER_CLASS_BINARY;
        }
        try {
            return (SignValider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido instanciar el validador '" + string + "': " + exception);
            return null;
        }
    }

    public static SignValider getSignValider(AOSigner aOSigner) throws IllegalArgumentException {
        String string = null;
        if (aOSigner instanceof AOCAdESSigner) {
            string = SIGNER_VALIDER_CLASS_BINARY;
        } else if (aOSigner instanceof AOXAdESSigner || aOSigner instanceof AOFacturaESigner) {
            string = SIGNER_VALIDER_CLASS_XML;
        } else if (aOSigner instanceof AOPDFSigner) {
            string = SIGNER_VALIDER_CLASS_PDF;
        }
        SignValider signValider = null;
        if (string != null) {
            try {
                signValider = (SignValider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido instanciar el validador '" + string + "': " + exception);
            }
        }
        return signValider;
    }
}

