/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import es.gob.afirma.core.RuntimeConfigNeededException;
import es.gob.afirma.signvalidation.SignValidity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class SignValider {
    private boolean relaxed = false;

    public void setRelaxed(boolean bl) {
        this.relaxed = bl;
    }

    public boolean isRelaxed() {
        return this.relaxed;
    }

    public abstract List<SignValidity> validate(byte[] var1) throws RuntimeConfigNeededException, IOException;

    public abstract List<SignValidity> validate(byte[] var1, boolean var2) throws RuntimeConfigNeededException, IOException;

    public abstract List<SignValidity> validate(byte[] var1, Properties var2) throws RuntimeConfigNeededException, IOException;

    protected static List<SignValidity> checkLongStandingValiditySign(List<SignValidity> list) {
        ArrayList<SignValidity> arrayList = new ArrayList<SignValidity>(list);
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (SignValidity.SIGN_DETAIL_TYPE.KO.equals((Object)list.get(i).getValidity())) {
                if (SignValidity.VALIDITY_ERROR.CERTIFICATE_EXPIRED.equals((Object)list.get(i).getError())) {
                    n = i;
                    continue;
                }
                bl = true;
                continue;
            }
            if (!SignValidity.SIGN_DETAIL_TYPE.UNKNOWN.equals((Object)list.get(i).getValidity()) || !SignValidity.VALIDITY_ERROR.SIGN_PROFILE_NOT_CHECKED.equals((Object)list.get(i).getError())) continue;
            n2 = i;
        }
        if (!bl && n != -1 && n2 != -1) {
            SignValidity signValidity = (SignValidity)arrayList.get(0);
            arrayList.set(0, list.get(n2));
            arrayList.set(n2, signValidity);
        }
        return arrayList;
    }

    protected static List<SignValidity> checkValidityKOPriority(List<SignValidity> list) {
        ArrayList<SignValidity> arrayList = new ArrayList<SignValidity>();
        for (SignValidity signValidity : list) {
            if (arrayList.contains(signValidity)) continue;
            if (SignValidity.SIGN_DETAIL_TYPE.KO.equals((Object)signValidity.getValidity())) {
                arrayList.add(0, signValidity);
                continue;
            }
            arrayList.add(signValidity);
        }
        return arrayList;
    }
}

