/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import es.gob.afirma.core.misc.SecureXmlBuilder;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.dereference.CustomUriDereferencer;
import es.gob.afirma.signvalidation.SignValider;
import es.gob.afirma.signvalidation.SignValidity;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class ValidateXMLSignature
extends SignValider {
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public SignValidity validate(byte[] byArray) {
        return this.validate(byArray, true);
    }

    @Override
    public SignValidity validate(byte[] byArray, Properties properties) {
        return this.validate(byArray, true);
    }

    @Override
    public SignValidity validate(byte[] byArray, boolean bl) {
        Document document;
        try {
            document = SecureXmlBuilder.getSecureDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN);
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN);
        }
        try {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeyValueKeySelector(), nodeList.item(i));
                XMLSignature xMLSignature = Utils.getDOMFactory().unmarshalXMLSignature(dOMValidateContext);
                if (!xMLSignature.validate(dOMValidateContext)) {
                    LOGGER.info("La firma es invalida");
                    return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA);
                }
                if (!xMLSignature.getSignatureValue().validate(dOMValidateContext)) {
                    LOGGER.info("El valor de la firma es invalido");
                    return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA);
                }
                if (bl) {
                    XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
                    XMLSignature xMLSignature2 = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
                    KeyInfo keyInfo = xMLSignature2.getKeyInfo();
                    X509Certificate x509Certificate = null;
                    for (XMLStructure xMLStructure : keyInfo.getContent()) {
                        if (!(xMLStructure instanceof X509Data)) continue;
                        X509Data x509Data = (X509Data)xMLStructure;
                        List<?> list = x509Data.getContent();
                        for (int j = 0; j < list.size(); ++j) {
                            if (!(list.get(j) instanceof X509Certificate)) continue;
                            x509Certificate = (X509Certificate)list.get(j);
                            try {
                                x509Certificate.checkValidity();
                                continue;
                            }
                            catch (CertificateExpiredException certificateExpiredException) {
                                return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_EXPIRED, certificateExpiredException);
                            }
                            catch (CertificateNotYetValidException certificateNotYetValidException) {
                                return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_NOT_VALID_YET, certificateNotYetValidException);
                            }
                        }
                    }
                }
                for (Reference reference : xMLSignature.getSignedInfo().getReferences()) {
                    if (reference.validate(dOMValidateContext)) continue;
                    LOGGER.info("La referencia '" + reference.getURI() + "' de la firma es invalida");
                    return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "No se ha podido validar la firma: " + exception, exception);
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, null, exception);
        }
        return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null);
    }

    private static final class SimpleKeySelectorResult
    implements KeySelectorResult {
        private final PublicKey pk;

        SimpleKeySelectorResult(PublicKey publicKey) {
            this.pk = publicKey;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }

    static final class KeyValueKeySelector
    extends KeySelector {
        KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Objeto KeyInfo nulo");
            }
            List<XMLStructure> list = keyInfo.getContent();
            try {
                xMLCryptoContext.setURIDereferencer((URIDereferencer)new CustomUriDereferencer());
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido instalar un dereferenciador a medida: " + exception);
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                XMLStructure xMLStructure = list.get(i);
                if (xMLStructure instanceof KeyValue) {
                    try {
                        object = ((KeyValue)xMLStructure).getPublicKey();
                    }
                    catch (KeyException keyException) {
                        throw new KeySelectorException(keyException);
                    }
                    return new SimpleKeySelectorResult((PublicKey)object);
                }
                if (!(xMLStructure instanceof X509Data)) continue;
                object = ((X509Data)xMLStructure).getContent();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Certificate)) continue;
                    return new SimpleKeySelectorResult(((Certificate)e).getPublicKey());
                }
            }
            throw new KeySelectorException("No se ha encontrado la clave publica dentro del XML firmado");
        }
    }
}

