/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import com.aowagie.text.pdf.AcroFields;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfReader;
import es.gob.afirma.core.RuntimeConfigNeededException;
import es.gob.afirma.signers.pades.common.PdfFormModifiedException;
import es.gob.afirma.signers.pades.common.SuspectedPSAException;
import es.gob.afirma.signvalidation.DataAnalizerUtil;
import es.gob.afirma.signvalidation.SignValider;
import es.gob.afirma.signvalidation.SignValidity;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public final class ValidatePdfSignature
extends SignValider {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final PdfName PDFNAME_ETSI_RFC3161 = new PdfName("ETSI.RFC3161");
    private static final PdfName PDFNAME_DOCTIMESTAMP = new PdfName("DocTimeStamp");
    private static final String DEFAULT_PAGES_TO_CHECK_PSA = "10";

    @Override
    public SignValidity validate(byte[] byArray) throws RuntimeConfigNeededException, IOException {
        return this.validate(byArray, true);
    }

    @Override
    public SignValidity validate(byte[] byArray, boolean bl) throws RuntimeConfigNeededException, IOException {
        Properties properties = new Properties();
        properties.setProperty("checkCertificates", Boolean.TRUE.toString());
        try {
            return this.validate(byArray, properties);
        }
        catch (RuntimeConfigNeededException runtimeConfigNeededException) {
            throw new IOException("No se dispone de la informacion necesaria para completar la validacion", runtimeConfigNeededException);
        }
    }

    @Override
    public SignValidity validate(byte[] byArray, Properties properties) throws RuntimeConfigNeededException, IOException {
        Object object;
        Object object2;
        AcroFields acroFields;
        PdfReader pdfReader;
        try {
            pdfReader = new PdfReader(byArray);
            acroFields = pdfReader.getAcroFields();
        }
        catch (Exception exception) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN);
        }
        List list = acroFields.getSignatureNames();
        if (list.size() == 0) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN);
        }
        for (String string : list) {
            boolean bl;
            object2 = acroFields.verifySignature(string);
            if (object2.getStrictHashAlgorithm() == null) {
                return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.ALGORITHM_NOT_SUPPORTED);
            }
            PdfDictionary pdfDictionary = acroFields.getSignatureDictionary(string);
            if (!PDFNAME_ETSI_RFC3161.equals((Object)pdfDictionary.get(PdfName.SUBFILTER)) && !PDFNAME_DOCTIMESTAMP.equals((Object)pdfDictionary.get(PdfName.SUBFILTER))) {
                try {
                    if (!object2.verify()) {
                        return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA);
                    }
                }
                catch (Exception exception) {
                    LOGGER.warning("Error validando una de las firmas del PDF: " + exception);
                    return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CORRUPTED_SIGN, exception);
                }
            }
            if (!(bl = Boolean.parseBoolean(properties.getProperty("checkCertificates", Boolean.TRUE.toString())))) continue;
            object = object2.getSigningCertificate();
            try {
                ((X509Certificate)object).checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_EXPIRED, certificateExpiredException);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_NOT_VALID_YET, certificateNotYetValidException);
            }
        }
        String string = properties.getProperty("allowModifiedForm");
        boolean bl = Boolean.parseBoolean(string);
        if (!bl && acroFields.getTotalRevisions() > 1 && (object2 = DataAnalizerUtil.checkPDFForm(pdfReader)) != null && !object2.isEmpty()) {
            if (string == null && this.isRelaxed()) {
                throw new PdfFormModifiedException("Se han detectado cambios en un formulario posteriores a la primera firma");
            }
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.MODIFIED_FORM);
        }
        object2 = properties.getProperty("allowShadowAttack");
        boolean bl2 = Boolean.parseBoolean((String)object2);
        String string2 = properties.getProperty("pagesToCheckShadowAttack", DEFAULT_PAGES_TO_CHECK_PSA);
        if (!bl && !bl2 && acroFields.getTotalRevisions() > 1 && acroFields.getRevision((String)list.get(0)) < acroFields.getTotalRevisions()) {
            object = acroFields.extractRevision((String)list.get(0));
            Throwable throwable = null;
            try {
                SignValidity signValidity = DataAnalizerUtil.checkPdfShadowAttack(byArray, (InputStream)object, string2);
                if (signValidity != null) {
                    if (this.isRelaxed() && signValidity.getValidity() == SignValidity.SIGN_DETAIL_TYPE.PENDING_CONFIRM_BY_USER && object2 == null) {
                        throw new SuspectedPSAException("PDF sospechoso de haber sufrido PDF Shadow Attack");
                    }
                    if (signValidity.getValidity() == SignValidity.SIGN_DETAIL_TYPE.PENDING_CONFIRM_BY_USER) {
                        signValidity = new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, signValidity.getError());
                    }
                    SignValidity signValidity2 = signValidity;
                    return signValidity2;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null);
    }
}

