/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.cms.AOCMSSigner;
import es.gob.afirma.signvalidation.CertHolderBySignerIdSelector;
import es.gob.afirma.signvalidation.SignValider;
import es.gob.afirma.signvalidation.SignValidity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessable;
import org.spongycastle.cms.CMSProcessableByteArray;
import org.spongycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.cms.CMSSignerDigestMismatchException;
import org.spongycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.spongycastle.cms.SignerInformation;
import org.spongycastle.cms.SignerInformationVerifier;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.spongycastle.operator.DigestCalculatorProvider;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.spongycastle.operator.bc.BcDigestCalculatorProvider;
import org.spongycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.spongycastle.util.Selector;
import org.spongycastle.util.Store;

public final class ValidateBinarySignature
extends SignValider {
    @Override
    public SignValidity validate(byte[] byArray) throws IOException {
        return ValidateBinarySignature.validate(byArray, null, true);
    }

    @Override
    public SignValidity validate(byte[] byArray, boolean bl) throws IOException {
        return ValidateBinarySignature.validate(byArray, null, bl);
    }

    @Override
    public SignValidity validate(byte[] byArray, Properties properties) throws IOException {
        return ValidateBinarySignature.validate(byArray, null, true);
    }

    public static SignValidity validate(byte[] byArray, byte[] byArray2) throws IOException {
        return ValidateBinarySignature.validate(byArray, byArray2, true);
    }

    public static SignValidity validate(byte[] byArray, byte[] byArray2, boolean bl) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("La firma a validar no puede ser nula");
        }
        AOCAdESSigner aOCAdESSigner = new AOCAdESSigner();
        if (!aOCAdESSigner.isSign(byArray) && !(aOCAdESSigner = new AOCMSSigner()).isSign(byArray)) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN);
        }
        try {
            if (byArray2 == null && aOCAdESSigner.getData(byArray) == null) {
                Logger.getLogger("es.gob.afirma").info("Se ha pedido validar una firma explicita sin proporcionar los datos firmados");
                return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.UNKNOWN, SignValidity.VALIDITY_ERROR.NO_DATA);
            }
        }
        catch (AOInvalidFormatException aOInvalidFormatException) {
            Logger.getLogger("es.gob.afirma").info("Se ha pedido validar una firma como CAdES, pero no es CAdES: " + (Object)((Object)aOInvalidFormatException));
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_SIGN, (Exception)((Object)aOInvalidFormatException));
        }
        catch (AOException aOException) {
            Logger.getLogger("es.gob.afirma").info("Se encontraron datos en la firma y no se pudieron extraer: " + (Object)((Object)aOException));
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.UNKOWN_ERROR);
        }
        try {
            ValidateBinarySignature.verifySignatures(byArray, byArray2 != null ? byArray2 : new AOCAdESSigner().getData(byArray), bl);
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_EXPIRED, certificateExpiredException);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.CERTIFICATE_NOT_VALID_YET, certificateNotYetValidException);
        }
        catch (CMSSignerDigestMismatchException cMSSignerDigestMismatchException) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, SignValidity.VALIDITY_ERROR.NO_MATCH_DATA, (Exception)((Object)cMSSignerDigestMismatchException));
        }
        catch (Exception exception) {
            return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.KO, null, exception);
        }
        return new SignValidity(SignValidity.SIGN_DETAIL_TYPE.OK, null);
    }

    private static void verifySignatures(byte[] byArray, byte[] byArray2, boolean bl) throws CMSException, CertificateException, IOException, OperatorCreationException {
        CMSSignedData cMSSignedData = byArray2 == null ? new CMSSignedData(byArray) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(byArray2), byArray);
        Store store = cMSSignedData.getCertificates();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (Object e : cMSSignedData.getSignerInfos().getSigners()) {
            SignerInformation signerInformation = (SignerInformation)e;
            Iterator iterator = store.getMatches((Selector)new CertHolderBySignerIdSelector(signerInformation.getSID())).iterator();
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(((X509CertificateHolder)iterator.next()).getEncoded()));
            if (bl) {
                x509Certificate.checkValidity();
            }
            if (signerInformation.verify(new SignerInformationVerifier((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), new JcaContentVerifierProviderBuilder().setProvider((Provider)new BouncyCastleProvider()).build(x509Certificate), (DigestCalculatorProvider)new BcDigestCalculatorProvider()))) continue;
            throw new CMSException("Firma no valida");
        }
    }
}

