/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

public final class SignValidity {
    private final SIGN_DETAIL_TYPE validity;
    private final VALIDITY_ERROR error;
    private final Exception errorException;

    public String toString() {
        if (this.validity.equals((Object)SIGN_DETAIL_TYPE.OK)) {
            return "Firma valida";
        }
        if (this.validity.equals((Object)SIGN_DETAIL_TYPE.UNKNOWN)) {
            return "Validaci\u00f3n incompleta";
        }
        if (this.validity.equals((Object)SIGN_DETAIL_TYPE.PENDING_CONFIRM_BY_USER)) {
            return "Validez a confirmar por el usuario";
        }
        if (this.error == null) {
            return "Firma no valida";
        }
        switch (this.error) {
            case NO_DATA: {
                return "Firma no valida: no se puede comprobar la validez por no tener los datos firmados";
            }
            case CORRUPTED_SIGN: {
                return "Firma no valida: la informacion contenida en la firma no es consistente (certificados corruptos, etc.)";
            }
            case NO_MATCH_DATA: {
                return "Firma no valida: la firma no se corresponde con los datos firmados";
            }
            case NO_SIGN: {
                return "Firma no valida: no se encuentra la firma dentro del documento";
            }
            case CERTIFICATE_PROBLEM: {
                return "Firma no valida: no se puede extraer un certificado o este no es valido";
            }
            case CERTIFICATE_EXPIRED: {
                return "Firma no valida: existe un certificado de firma caducado";
            }
            case CERTIFICATE_NOT_VALID_YET: {
                return "Firma no valida: existe un certificado de firma que aun no es valido";
            }
            case ALGORITHM_NOT_SUPPORTED: {
                return "Firma no valida: la firma contiene un algoritmo no reconocido o no soportado";
            }
            case CA_NOT_SUPPORTED: {
                return "Firma no valida: no se soporta la CA de expedicion";
            }
            case CRL_PROBLEM: {
                return "Firma no valida: existe algun problema con las CRLs incrustadas en la firma";
            }
            case PDF_UNKOWN_VALIDITY: {
                return "Firma no valida: no se puede comprobar la validez de la firma PDF";
            }
            case OOXML_UNKOWN_VALIDITY: {
                return "Firma no valida: no se puede comprobar la validez de la firma OOXML";
            }
            case ODF_UNKOWN_VALIDITY: {
                return "Firma no valida: no se puede comprobar la validez de la firma ODF";
            }
            case UNKOWN_ERROR: {
                return "Firma no valida: no se puede comprobar la validez de la firma";
            }
            case UNKOWN_SIGNATURE_FORMAT: {
                return "Firma no valida: los datos proporcionados no se corresponden con ningun formato de firma reconocido";
            }
            case MODIFIED_DOCUMENT: {
                return "Firma no valida: el documento PDF es sospechoso de haberse modificado tras la firma";
            }
            case OVERLAPPING_SIGNATURE: {
                return "Firma no valida: las firmas del documento se solapan pudiendo ocultar informacion";
            }
        }
        return "Firma no valida";
    }

    public SignValidity(SIGN_DETAIL_TYPE sIGN_DETAIL_TYPE, VALIDITY_ERROR vALIDITY_ERROR, Exception exception) {
        this.validity = sIGN_DETAIL_TYPE;
        this.error = vALIDITY_ERROR;
        this.errorException = exception;
    }

    public SignValidity(SIGN_DETAIL_TYPE sIGN_DETAIL_TYPE, VALIDITY_ERROR vALIDITY_ERROR) {
        this(sIGN_DETAIL_TYPE, vALIDITY_ERROR, null);
    }

    public SIGN_DETAIL_TYPE getValidity() {
        return this.validity;
    }

    public VALIDITY_ERROR getError() {
        return this.error;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public static enum VALIDITY_ERROR {
        NO_DATA,
        CORRUPTED_SIGN,
        NO_MATCH_DATA,
        NO_SIGN,
        CERTIFICATE_PROBLEM,
        CERTIFICATE_EXPIRED,
        CERTIFICATE_NOT_VALID_YET,
        ALGORITHM_NOT_SUPPORTED,
        CA_NOT_SUPPORTED,
        CRL_PROBLEM,
        PDF_UNKOWN_VALIDITY,
        OOXML_UNKOWN_VALIDITY,
        ODF_UNKOWN_VALIDITY,
        UNKOWN_ERROR,
        UNKOWN_SIGNATURE_FORMAT,
        MODIFIED_FORM,
        MODIFIED_DOCUMENT,
        OVERLAPPING_SIGNATURE,
        SUSPECTED_SIGNATURE;

    }

    public static enum SIGN_DETAIL_TYPE {
        OK,
        KO,
        UNKNOWN,
        PENDING_CONFIRM_BY_USER,
        GENERATED;

    }
}

