/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signvalidation;

import com.aowagie.text.pdf.AcroFields;
import com.aowagie.text.pdf.PRAcroForm;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfReader;
import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.cms.AOCMSSigner;
import es.gob.afirma.signers.odf.AOODFSigner;
import es.gob.afirma.signers.ooxml.AOOOXMLSigner;
import es.gob.afirma.signers.pades.AOPDFSigner;
import es.gob.afirma.signers.xades.AOFacturaESigner;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xmldsig.AOXMLDSigSigner;
import es.gob.afirma.signvalidation.SignValidity;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public final class DataAnalizerUtil {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private DataAnalizerUtil() {
    }

    public static X509Certificate isCertificate(byte[] byArray) throws CertificateException {
        if (byArray == null || byArray.length < 1) {
            throw new CertificateException("Los datos eran nulos o vacios");
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try {
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            try {
                return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)new String(byArray).replace("%0A", "").replace("%2F", "/").replace("%2B", "+").replace("%3D", "="))));
            }
            catch (Exception exception2) {
                throw new CertificateException("Los datos proporcionados no son un certificado X.509");
            }
        }
    }

    public static boolean isXML(byte[] byArray) {
        return AOFileUtils.isXML((byte[])byArray);
    }

    public static boolean isSignedXML(byte[] byArray) {
        try {
            return new AOXAdESSigner().isSign(byArray) || new AOXMLDSigSigner().isSign(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isPDF(byte[] byArray) {
        try {
            return new AOPDFSigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSignedPDF(byte[] byArray) {
        try {
            return new AOPDFSigner().isSign(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isBinary(byte[] byArray) {
        try {
            return new AOCMSSigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSignedBinary(byte[] byArray) {
        try {
            return new AOCMSSigner().isSign(byArray) || new AOCAdESSigner().isSign(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isFacturae(byte[] byArray) {
        try {
            return new AOFacturaESigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSignedFacturae(byte[] byArray) {
        try {
            return new AOFacturaESigner().isSign(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isODF(byte[] byArray) {
        try {
            return new AOODFSigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Ocurrio un error al analizar los datos: " + exception);
            return false;
        }
    }

    public static boolean isSignedODF(byte[] byArray) {
        try {
            return new AOODFSigner().isSign(byArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Ocurrio un error al analizar los datos: " + exception);
            return false;
        }
    }

    public static boolean isOOXML(byte[] byArray) {
        try {
            return new AOOOXMLSigner().isValidDataFile(byArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Ocurrio un error al analizar los datos: " + exception);
            return false;
        }
    }

    public static boolean isSignedOOXML(byte[] byArray) {
        try {
            return new AOOOXMLSigner().isSign(byArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Ocurrio un error al analizar los datos: " + exception);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SignValidity checkPdfShadowAttack(byte[] byArray, InputStream inputStream, String string) throws IOException {
        try (PDDocument pDDocument = PDDocument.load((byte[])byArray);
             PDDocument pDDocument2 = PDDocument.load((InputStream)inputStream);){
            PDFRenderer pDFRenderer = new PDFRenderer(pDDocument);
            PDFRenderer pDFRenderer2 = new PDFRenderer(pDDocument2);
            int n = "all".equalsIgnoreCase(string) ? pDDocument.getNumberOfPages() : Integer.parseInt(string);
            int n2 = 0;
            while (n2 < n) {
                BufferedImage bufferedImage;
                boolean bl = DataAnalizerUtil.checkSignatureOverlaping(pDDocument.getPage(n2).getAnnotations());
                if (bl) {
                    SignValidity signValidity = new SignValidity(SignValidity.SIGN_DETAIL_TYPE.PENDING_CONFIRM_BY_USER, SignValidity.VALIDITY_ERROR.OVERLAPPING_SIGNATURE);
                    return signValidity;
                }
                BufferedImage bufferedImage2 = pDFRenderer.renderImageWithDPI(n2, 40.0f, ImageType.GRAY);
                boolean bl2 = DataAnalizerUtil.checkImagesChanges(bufferedImage2, bufferedImage = pDFRenderer2.renderImageWithDPI(n2, 40.0f, ImageType.GRAY));
                if (!bl2) {
                    SignValidity signValidity = new SignValidity(SignValidity.SIGN_DETAIL_TYPE.PENDING_CONFIRM_BY_USER, SignValidity.VALIDITY_ERROR.MODIFIED_DOCUMENT);
                    return signValidity;
                }
                ++n2;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Error al cargar el fichero, se salta al siguiente");
        }
        return null;
    }

    public static boolean checkImagesChanges(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (DataAnalizerUtil.imageDimensionsEqual(bufferedImage, bufferedImage2)) {
            int n = DataAnalizerUtil.drawSubtractionImage(bufferedImage, bufferedImage2, null);
            return n == 0;
        }
        return false;
    }

    private static boolean imageDimensionsEqual(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage.getWidth() != bufferedImage2.getWidth() || bufferedImage.getHeight() != bufferedImage2.getHeight()) {
            LOGGER.log(Level.WARNING, "Las imagenes no tienen el mismo tamano");
            return false;
        }
        return true;
    }

    private static int drawSubtractionImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, BufferedImage bufferedImage3) {
        int n = 0;
        for (int i = 0; i < bufferedImage.getHeight() && i < bufferedImage2.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth() && j < bufferedImage2.getWidth(); ++j) {
                int n2 = bufferedImage.getRGB(j, i);
                int n3 = bufferedImage2.getRGB(j, i);
                int n4 = n2 >> 16 & 0xFF;
                int n5 = n2 >> 8 & 0xFF;
                int n6 = n2 & 0xFF;
                int n7 = n3 >> 16 & 0xFF;
                int n8 = n3 >> 8 & 0xFF;
                int n9 = n3 & 0xFF;
                int n10 = Math.abs(n4 - n7);
                n10 += Math.abs(n5 - n8);
                if ((n10 += Math.abs(n6 - n9)) > 0) {
                    ++n;
                }
                if (bufferedImage3 == null) continue;
                int n11 = (n10 /= 3) << 16 | n10 << 8 | n10;
                bufferedImage3.setRGB(j, i, n11);
            }
        }
        return n;
    }

    private static boolean checkSignatureOverlaping(List<PDAnnotation> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            boolean bl;
            Rectangle2D rectangle2D;
            if (!(list.get(i) instanceof PDAnnotationWidget) || (rectangle2D = DataAnalizerUtil.toJavaRectangle(list.get(i).getRectangle())).getWidth() == 0.0 || rectangle2D.getHeight() == 0.0 || !(bl = DataAnalizerUtil.checkIsOverlapping(rectangle2D, list, ++i))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkIsOverlapping(Rectangle2D rectangle2D, List<PDAnnotation> list, int n) {
        for (int i = n; i < list.size(); ++i) {
            Rectangle2D rectangle2D2 = DataAnalizerUtil.toJavaRectangle(list.get(i).getRectangle());
            if (rectangle2D.getMinX() > rectangle2D2.getMaxX() || rectangle2D2.getMinX() > rectangle2D.getMaxX()) {
                return false;
            }
            if (!(rectangle2D.getMinY() > rectangle2D2.getMaxY()) && !(rectangle2D2.getMinY() > rectangle2D.getMaxY())) continue;
            return false;
        }
        return true;
    }

    private static Rectangle2D toJavaRectangle(PDRectangle pDRectangle) {
        float f = pDRectangle.getLowerLeftX();
        float f2 = pDRectangle.getLowerLeftY();
        float f3 = pDRectangle.getUpperRightX() - pDRectangle.getLowerLeftX();
        float f4 = pDRectangle.getUpperRightY() - pDRectangle.getLowerLeftY();
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    public static Map<String, String> checkPDFForm(PdfReader pdfReader) throws IOException {
        PdfReader pdfReader2;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Map<String, PdfObject> map = DataAnalizerUtil.getFieldValues(pdfReader);
        AcroFields acroFields = pdfReader.getAcroFields();
        List list = acroFields.getSignatureNames();
        Object object = acroFields.extractRevision((String)list.get(list.size() - 1));
        Object object2 = null;
        try {
            pdfReader2 = new PdfReader((InputStream)object);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)object).close();
                }
            }
        }
        object = DataAnalizerUtil.getFieldValues(pdfReader2);
        for (String string : object.keySet()) {
            String string2;
            PdfObject pdfObject = (PdfObject)object.get(string);
            PdfObject pdfObject2 = map.remove(string);
            if (pdfObject != null) {
                string2 = pdfObject.toString();
                if (pdfObject2 != null) {
                    String string3 = pdfObject2.toString();
                    if (string2.equals(string3)) continue;
                    linkedHashMap.put(string, "El campo " + string + " ha sido modificado tras firma: " + string2 + " / " + string3);
                    continue;
                }
                linkedHashMap.put(string, "El campo " + string + " ha sido modificado tras firma: " + string2 + " / null");
                continue;
            }
            if (pdfObject2 == null) continue;
            string2 = pdfObject2.toString();
            linkedHashMap.put(string, "El campo " + string + " ha sido modificado tras firma: null / " + string2);
        }
        if (linkedHashMap.isEmpty()) {
            return null;
        }
        return linkedHashMap;
    }

    private static Map<String, PdfObject> getFieldValues(PdfReader pdfReader) {
        LinkedHashMap<String, PdfObject> linkedHashMap = new LinkedHashMap<String, PdfObject>();
        PRAcroForm pRAcroForm = pdfReader.getAcroForm();
        ArrayList arrayList = pRAcroForm.getFields();
        for (int i = 0; i < arrayList.size(); ++i) {
            PRAcroForm.FieldInformation fieldInformation = (PRAcroForm.FieldInformation)arrayList.get(i);
            if (fieldInformation.getInfo() == null) continue;
            String string = null;
            if (fieldInformation.getInfo().get(PdfName.FT) != null) {
                string = fieldInformation.getInfo().get(PdfName.FT).toString();
            }
            if (string != null && string.equals("/Sig")) continue;
            linkedHashMap.put(fieldInformation.getName(), fieldInformation.getInfo().get(PdfName.V));
        }
        return linkedHashMap;
    }
}

