/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xml.dereference;

import es.gob.afirma.signers.xml.dereference.NodeFilter;
import es.gob.afirma.signers.xml.dereference.XMLSignatureInput;
import es.gob.afirma.signers.xml.dereference.XMLUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.crypto.NodeSetData;
import org.w3c.dom.Node;

public final class ApacheNodeSetData
implements NodeSetData {
    private final XMLSignatureInput xi;

    ApacheNodeSetData(XMLSignatureInput xMLSignatureInput) {
        this.xi = xMLSignatureInput;
    }

    @Override
    public Iterator<Node> iterator() {
        if (this.xi.getNodeFilters() != null && !this.xi.getNodeFilters().isEmpty()) {
            return Collections.unmodifiableSet(this.getNodeSet(this.xi.getNodeFilters())).iterator();
        }
        try {
            return Collections.unmodifiableSet(this.xi.getNodeSet()).iterator();
        }
        catch (Exception exception) {
            throw new RuntimeException("unrecoverable error retrieving nodeset: " + exception, exception);
        }
    }

    private Set<Node> getNodeSet(List<NodeFilter> list) {
        if (this.xi.isNeedsToBeExpanded()) {
            XMLUtils.circumventBug2650(XMLUtils.getOwnerDocument(this.xi.getSubNode()));
        }
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        XMLUtils.getSet(this.xi.getSubNode(), linkedHashSet, null, !this.xi.isExcludeComments());
        LinkedHashSet<Node> linkedHashSet2 = new LinkedHashSet<Node>();
        for (Node node : linkedHashSet) {
            Iterator<NodeFilter> iterator = list.iterator();
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                NodeFilter nodeFilter = iterator.next();
                if (nodeFilter.isNodeInclude(node) == 1) continue;
                bl = true;
            }
            if (bl) continue;
            linkedHashSet2.add(node);
        }
        return linkedHashSet2;
    }
}

