/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xml;

import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.dsig.XMLSignatureFactory;

public class XmlDSigProviderHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String APACHE_PROVIDER_CLASS = "org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static final String SUN_PROVIDER_CLASS = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static Provider defaultProvider;
    private static boolean configured;

    public static void configureXmlDSigProvider() {
        XmlDSigProviderHelper.configureXmlDSigProvider(false, true);
    }

    public static void configureXmlDSigProvider(boolean bl, boolean bl2) {
        if (configured && !bl) {
            return;
        }
        try {
            defaultProvider = XMLSignatureFactory.getInstance("DOM").getProvider();
        }
        catch (Exception exception) {
            LOGGER.warning("No se encontro un proveedor por defecto para la generacion de firmas XML: " + exception);
        }
        System.setProperty("com.sun.org.apache.xml.internal.security.lineFeedOnly", "true");
        System.setProperty("org.apache.xml.security.ignoreLineBreaks", "true");
        String string = bl2 ? APACHE_PROVIDER_CLASS : SUN_PROVIDER_CLASS;
        try {
            XmlDSigProviderHelper.installProvider(string);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.SEVERE, "No se pudo dar preferencia al proveedor configurado", throwable);
        }
        try {
            Provider provider = XMLSignatureFactory.getInstance("DOM").getProvider();
            LOGGER.info("Se usara el proveedor '" + provider.getName() + "': " + provider.getClass().getName());
        }
        catch (NoSuchMechanismException noSuchMechanismException) {
            LOGGER.warning("No hay proveedor instalado para XMLDSig. Se reinstala el proveedor por defecto: " + noSuchMechanismException);
            Security.addProvider(defaultProvider);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error en la verificacion de los proveedores XML", exception);
        }
        configured = true;
    }

    private static void installProvider(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Provider provider = null;
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; provider == null && i < providerArray.length; ++i) {
            if (!string.equals(providerArray[i].getClass().getName())) continue;
            provider = providerArray[i];
        }
        if (provider != null) {
            Security.removeProvider(provider.getName());
            LOGGER.info("Damos preferencia al proveedor " + provider.getName() + ": " + provider.getClass().getName());
        } else {
            Class<?> clazz = Class.forName(string);
            provider = (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOGGER.info("Instalamos con la maxima preferencia el proveedor " + provider.getName() + ": " + provider.getClass().getName());
        }
        Security.insertProviderAt(provider, 1);
    }

    static {
        configured = false;
    }
}

