/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xml.dereference;

import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class XMLUtils {
    XMLUtils() {
    }

    static void getSet(Node node, Set<Node> set, Node node2, boolean bl) {
        if (node2 != null && XMLUtils.isDescendantOrSelf(node2, node)) {
            return;
        }
        XMLUtils.getSetRec(node, set, node2, bl);
    }

    static final void getSetRec(Node node, Set<Node> set, Node node2, boolean bl) {
        if (node == node2) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                set.add(node);
                Element element = (Element)node;
                if (element.hasAttributes()) {
                    object = ((Element)node).getAttributes();
                    for (int i = 0; i < object.getLength(); ++i) {
                        set.add(object.item(i));
                    }
                }
            }
            case 9: {
                Object object;
                for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (object.getNodeType() == 3) {
                        set.add((Node)object);
                        while (object != null && object.getNodeType() == 3) {
                            object = object.getNextSibling();
                        }
                        if (object == null) {
                            return;
                        }
                    }
                    XMLUtils.getSetRec((Node)object, set, node2, bl);
                }
                return;
            }
            case 8: {
                if (bl) {
                    set.add(node);
                }
                return;
            }
            case 10: {
                return;
            }
        }
        set.add(node);
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static void circumventBug2650(Document document) {
        Element element = document.getDocumentElement();
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (attr == null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650internal(document);
    }

    private static void circumventBug2650internal(Node node) {
        Node node2 = null;
        Node node3 = null;
        while (true) {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    if (!element.hasChildNodes()) break;
                    if (element.hasAttributes()) {
                        NamedNodeMap namedNodeMap = element.getAttributes();
                        int n = namedNodeMap.getLength();
                        for (Node node4 = element.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                            if (node4.getNodeType() != 1) continue;
                            Element element2 = (Element)node4;
                            for (int i = 0; i < n; ++i) {
                                Attr attr = (Attr)namedNodeMap.item(i);
                                if ("http://www.w3.org/2000/xmlns/" != attr.getNamespaceURI() || element2.hasAttributeNS("http://www.w3.org/2000/xmlns/", attr.getLocalName())) continue;
                                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName(), attr.getNodeValue());
                            }
                        }
                    }
                }
                case 5: 
                case 9: {
                    node2 = node;
                    node3 = node.getFirstChild();
                }
            }
            while (node3 == null && node2 != null) {
                node3 = node2.getNextSibling();
                node2 = node2.getParentNode();
            }
            if (node3 == null) {
                return;
            }
            node = node3;
            node3 = node.getNextSibling();
        }
    }

    public static boolean isDescendantOrSelf(Node node, Node node2) {
        if (node == node2) {
            return true;
        }
        Node node3 = node2;
        while (node3 != null) {
            if (node3 == node) {
                return true;
            }
            if (node3.getNodeType() == 2) {
                node3 = ((Attr)node3).getOwnerElement();
                continue;
            }
            node3 = node3.getParentNode();
        }
        return false;
    }
}

