/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xml.dereference;

import es.gob.afirma.core.misc.SecureXmlBuilder;
import es.gob.afirma.core.misc.http.UrlHttpManagerFactory;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import es.gob.afirma.signers.xml.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CustomUriDereferencer
implements URIDereferencer {
    private static final String ID = "Id";
    private static final String DEFAULT_SUN_XML_SIGNATURE_INPUT_CLASSNAME = "com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput";
    private static final String DEFAULT_APACHE_XML_SIGNATURE_INPUT_CLASSNAME = "org.apache.xml.security.signature.XMLSignatureInput";
    private static final String DEFAULT_SUN_OCTET_STREAM_DATA = "org.jcp.xml.dsig.internal.dom.ApacheOctetStreamData";
    private static final String DEFAULT_APACHE_OCTET_STREAM_DATA = "org.apache.jcp.xml.dsig.internal.dom.ApacheOctetStreamData";
    private static final String DEFAULT_SUN_NODESET_DATA = "org.jcp.xml.dsig.internal.dom.ApacheNodeSetData";
    private static final String DEFAULT_APACHE_NODESET_DATA = "org.apache.jcp.xml.dsig.internal.dom.ApacheNodeSetData";
    private final URIDereferencer defaultUriDereferencer = Utils.getDOMFactory().getURIDereferencer();

    private static Class<?> getNodesetDataClass() throws ClassNotFoundException {
        try {
            return Class.forName(DEFAULT_APACHE_NODESET_DATA);
        }
        catch (Error | Exception throwable) {
            return Class.forName(DEFAULT_SUN_NODESET_DATA);
        }
    }

    private static Class<?> getOctetStreamDataClass() throws ClassNotFoundException {
        try {
            return Class.forName(DEFAULT_APACHE_OCTET_STREAM_DATA);
        }
        catch (Error | Exception throwable) {
            return Class.forName(DEFAULT_SUN_OCTET_STREAM_DATA);
        }
    }

    private static Class<?> getXmlSignatureInputClass() throws ClassNotFoundException {
        try {
            return Class.forName(DEFAULT_APACHE_XML_SIGNATURE_INPUT_CLASSNAME);
        }
        catch (Error | Exception throwable) {
            return Class.forName(DEFAULT_SUN_XML_SIGNATURE_INPUT_CLASSNAME);
        }
    }

    @Override
    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        try {
            return this.defaultUriDereferencer.dereference(uRIReference, xMLCryptoContext);
        }
        catch (Exception exception) {
            String string = uRIReference.getURI();
            if (string.startsWith("http://") || string.startsWith("https://")) {
                byte[] byArray;
                Logger.getLogger("es.gob.afirma").info("Se ha pedido dereferenciar una URI externa: " + string);
                try {
                    byArray = UrlHttpManagerFactory.getInstalledManager().readUrl(string, UrlHttpMethod.GET);
                }
                catch (Exception exception2) {
                    throw new URIReferenceException("No se ha podido descargar manualmente el contenido externo (" + exception + "): " + exception2, exception2);
                }
                try {
                    return CustomUriDereferencer.getStreamData(SecureXmlBuilder.getSecureDocumentBuilder().parse(new ByteArrayInputStream(byArray)));
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new URIReferenceException("No se ha podido crear un XML a partir del contenido externo dereferenciado por error del analizador (" + exception + "): " + parserConfigurationException, parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    throw new URIReferenceException("No se ha podido crear un XML a partir del contenido externo dereferenciado por error SAX (" + exception + "): " + sAXException, sAXException);
                }
                catch (IOException iOException) {
                    throw new URIReferenceException("No se ha podido crear un XML a partir del contenido externo dereferenciado (" + exception + "): " + iOException, iOException);
                }
            }
            Attr attr = (Attr)((DOMURIReference)uRIReference).getHere();
            Document document = attr.getOwnerDocument();
            String string2 = attr.getNodeValue();
            if ("".equals(string2)) {
                try {
                    return CustomUriDereferencer.getStreamData(document);
                }
                catch (IOException iOException) {
                    throw new URIReferenceException("Error obteniendo los octetos del XML: " + iOException, iOException);
                }
            }
            Node node = CustomUriDereferencer.getNodeByInternalUriReference(string2, document);
            if (node == null) {
                throw new URIReferenceException(exception);
            }
            try {
                return CustomUriDereferencer.getStreamData(node);
            }
            catch (IOException iOException) {
                throw new URIReferenceException("Error obteniendo los octetos del XML: " + iOException, iOException);
            }
        }
    }

    public static Node getNodeByInternalUriReference(String string, Document document) {
        String string2 = string;
        if (string.length() > 0 && string.charAt(0) == '#') {
            string2 = string.substring(1);
        }
        return CustomUriDereferencer.getElementById(document, string2);
    }

    private static Data getStreamData(Node node) throws IOException {
        try {
            Class<?> clazz = CustomUriDereferencer.getXmlSignatureInputClass();
            Constructor<?> constructor = clazz.getConstructor(Node.class);
            Object obj = constructor.newInstance(node);
            Method method = clazz.getMethod("isOctetStream", new Class[0]);
            if (((Boolean)method.invoke(obj, new Object[0])).booleanValue()) {
                Class<?> clazz2 = CustomUriDereferencer.getOctetStreamDataClass();
                Constructor<?> constructor2 = clazz2.getConstructor(obj.getClass());
                return (Data)constructor2.newInstance(obj);
            }
            Constructor<?> constructor3 = CustomUriDereferencer.getNodesetDataClass().getConstructor(obj.getClass());
            return (Data)constructor3.newInstance(obj);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        catch (Error error) {
            throw new IOException(error);
        }
    }

    public static Element getElementById(Document document, String string) {
        if (document == null || string == null) {
            return null;
        }
        NodeList nodeList = document.getElementsByTagName("*");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Node node2 = namedNodeMap.item(j);
                if (!ID.equalsIgnoreCase(node2.getNodeName()) || !string.equals(node2.getNodeValue()) || !(node instanceof Element)) continue;
                return (Element)node;
            }
        }
        return null;
    }
}

