/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xml.style;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.signers.xml.style.CannotDereferenceException;
import es.gob.afirma.signers.xml.style.IsInnerlException;
import es.gob.afirma.signers.xml.style.ReferenceIsNotXmlException;
import es.gob.afirma.signers.xml.style.XmlStyleMessages;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XmlStyle {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private Element element;
    private final String type;
    private final String href;
    private final String encoding;

    public XmlStyle() {
        this.element = null;
        this.type = null;
        this.href = null;
        this.encoding = null;
    }

    public XmlStyle(byte[] byArray, boolean bl) throws IOException, CannotDereferenceException, IsInnerlException, ReferenceIsNotXmlException {
        Properties properties = XmlStyle.getStyleSheetHeader(new String(byArray));
        this.type = properties.getProperty("type");
        this.href = properties.getProperty("href");
        if (this.type != null && this.href != null) {
            LOGGER.info("Se ha encontrado una hoja de estilo asociada al XML a firmar: tipo=" + this.type + ", referencia=" + this.href);
            Document document = XmlStyle.dereferenceStyleSheet(this.href, bl);
            this.element = !this.href.startsWith(HTTP_PROTOCOL_PREFIX) && !this.href.startsWith(HTTPS_PROTOCOL_PREFIX) ? document.getDocumentElement() : null;
            this.encoding = document.getXmlEncoding();
        } else {
            this.encoding = null;
            this.element = null;
        }
    }

    public void setStyleElement(Element element) {
        this.element = element;
    }

    public Element getStyleElement() {
        return this.element;
    }

    public String getStyleType() {
        return this.type;
    }

    public String getStyleHref() {
        return this.href;
    }

    public String getStyleEncoding() {
        return this.encoding;
    }

    private static Properties getStyleSheetHeader(String string) throws IOException {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        int n = string.indexOf("<?xml-stylesheet ");
        if (n == -1) {
            return properties;
        }
        String string2 = string.substring(n);
        string2 = string2.substring(0, string2.indexOf(62) + 1).replace("<?xml-stylesheet ", "").replace("?>", "").replace(" ", "\n").replace("\"", "").replace("'", "");
        properties.load(new ByteArrayInputStream(string2.getBytes()));
        return properties;
    }

    private static Document dereferenceStyleSheet(String string, boolean bl) throws CannotDereferenceException, IsInnerlException, ReferenceIsNotXmlException {
        byte[] byArray;
        block25: {
            if (string == null || string.isEmpty()) {
                throw new CannotDereferenceException("La hoja de estilo era nula o vacia");
            }
            byArray = null;
            try {
                URI uRI = AOUtil.createURI((String)string);
                if (uRI.getScheme().equals("file")) {
                    throw new UnsupportedOperationException("No se aceptan dereferenciaciones directas con file://");
                }
                byArray = AOUtil.getDataFromInputStream((InputStream)AOUtil.loadFile((URI)uRI));
            }
            catch (Exception exception) {
                String[] stringArray = string.replace(File.separator, "/").split("/");
                String string2 = stringArray[stringArray.length - 1];
                if (string2.startsWith("#")) {
                    throw new IsInnerlException(exception);
                }
                if (!bl && string.startsWith("file://")) {
                    File file;
                    if (AOUIFactory.showConfirmDialog(null, (Object)XmlStyleMessages.getString("XmlStyle.5"), (String)XmlStyleMessages.getString("XmlStyle.6"), (int)AOUIFactory.OK_CANCEL_OPTION, (int)AOUIFactory.INFORMATION_MESSAGE) != AOUIFactory.OK_OPTION) break block25;
                    try {
                        file = AOUIFactory.getLoadFiles((String)XmlStyleMessages.getString("XmlStyle.7"), null, (String)string2, null, (String)XmlStyleMessages.getString("XmlStyle.8", string2), (boolean)false, (boolean)false, null, null)[0];
                    }
                    catch (AOCancelledOperationException aOCancelledOperationException) {
                        LOGGER.warning("El usuario ha cancelado la seleccion de hoja de estilo: " + (Object)((Object)aOCancelledOperationException));
                        throw new CannotDereferenceException("No se ha podido dereferenciar la hoja de estilo: " + (Object)((Object)aOCancelledOperationException), exception);
                    }
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        byArray = AOUtil.getDataFromInputStream((InputStream)fileInputStream);
                    }
                    catch (Exception exception2) {
                        throw new CannotDereferenceException("No se ha podido dereferenciar la hoja de estilo: " + exception, exception2);
                    }
                }
                throw new CannotDereferenceException("No se ha podido dereferenciar la hoja de estilo '" + string + "': " + exception, exception);
            }
        }
        try {
            if (byArray != null) {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            }
            throw new CannotDereferenceException("No se ha dereferenciado la hoja de estilo");
        }
        catch (Exception exception) {
            throw new ReferenceIsNotXmlException(exception);
        }
    }
}

