/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xml.dereference;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.signers.xml.dereference.NodeFilter;
import es.gob.afirma.signers.xml.dereference.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nu.xom.Node;
import nu.xom.canonical.Canonicalizer;
import nu.xom.converters.DOMConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XMLSignatureInput {
    private InputStream inputOctetStreamProxy = null;
    private Set<org.w3c.dom.Node> inputNodeSet = null;
    private org.w3c.dom.Node subNode = null;
    private final org.w3c.dom.Node excludeNode = null;
    private final boolean excludeComments = false;
    private final boolean isNodeSet = false;
    private byte[] bytes = null;
    private final String mimeType;
    private final String sourceURI;
    private final List<NodeFilter> nodeFilters = new ArrayList<NodeFilter>();
    private final boolean needsToBeExpanded = false;
    private DocumentBuilderFactory dfactory;

    public XMLSignatureInput(org.w3c.dom.Node node) {
        this.mimeType = null;
        this.sourceURI = null;
        this.subNode = node;
    }

    public boolean isNeedsToBeExpanded() {
        this.getClass();
        return false;
    }

    public Set<org.w3c.dom.Node> getNodeSet() throws ParserConfigurationException, IOException, SAXException {
        return this.getNodeSet(false);
    }

    public Set<org.w3c.dom.Node> getNodeSet(boolean bl) throws ParserConfigurationException, IOException, SAXException {
        if (this.inputNodeSet != null) {
            return this.inputNodeSet;
        }
        if (this.inputOctetStreamProxy == null && this.subNode != null) {
            if (bl) {
                XMLUtils.circumventBug2650(XMLUtils.getOwnerDocument(this.subNode));
            }
            this.inputNodeSet = new LinkedHashSet<org.w3c.dom.Node>();
            this.getClass();
            XMLUtils.getSet(this.subNode, this.inputNodeSet, this.excludeNode, false);
            return this.inputNodeSet;
        }
        if (this.isOctetStream()) {
            this.convertToNodes();
            LinkedHashSet<org.w3c.dom.Node> linkedHashSet = new LinkedHashSet<org.w3c.dom.Node>();
            XMLUtils.getSet(this.subNode, linkedHashSet, null, false);
            return linkedHashSet;
        }
        throw new RuntimeException("getNodeSet() called but no input data present");
    }

    public InputStream getOctetStream() throws IOException {
        if (this.inputOctetStreamProxy != null) {
            return this.inputOctetStreamProxy;
        }
        if (this.bytes != null) {
            this.inputOctetStreamProxy = new ByteArrayInputStream(this.bytes);
            return this.inputOctetStreamProxy;
        }
        return null;
    }

    public byte[] getBytes() throws IOException {
        byte[] byArray = this.getBytesFromInputStream();
        if (byArray != null) {
            return byArray;
        }
        if (this.getSubNode() instanceof Element) {
            return XMLSignatureInput.canonicalizeXml((Element)this.getSubNode(), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        }
        throw new IOException("Cannot get canonicalized bytes from non Element-type Node");
    }

    public boolean isNodeSet() {
        boolean bl;
        if (this.inputOctetStreamProxy == null && this.inputNodeSet != null) {
            bl = true;
        } else {
            this.getClass();
            bl = false;
        }
        return bl;
    }

    public boolean isOctetStream() {
        return (this.inputOctetStreamProxy != null || this.bytes != null) && this.inputNodeSet == null && this.subNode == null;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public org.w3c.dom.Node getSubNode() {
        return this.subNode;
    }

    boolean isExcludeComments() {
        this.getClass();
        return false;
    }

    private byte[] getBytesFromInputStream() throws IOException {
        if (this.bytes != null) {
            return this.bytes;
        }
        if (this.inputOctetStreamProxy == null) {
            return null;
        }
        try {
            this.bytes = AOUtil.getDataFromInputStream((InputStream)this.inputOctetStreamProxy);
        }
        finally {
            this.inputOctetStreamProxy.close();
        }
        return this.bytes;
    }

    public List<NodeFilter> getNodeFilters() {
        return this.nodeFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertToNodes() throws ParserConfigurationException, IOException, SAXException {
        if (this.dfactory == null) {
            this.dfactory = DocumentBuilderFactory.newInstance();
            this.dfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            this.dfactory.setValidating(false);
            this.dfactory.setNamespaceAware(true);
        }
        DocumentBuilder documentBuilder = this.dfactory.newDocumentBuilder();
        try {
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                }
            });
            Document document = documentBuilder.parse(this.getOctetStream());
            this.subNode = document;
        }
        catch (SAXException sAXException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write("<container>".getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(this.getBytes());
            byteArrayOutputStream.write("</container>".getBytes(StandardCharsets.UTF_8));
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            this.subNode = document.getDocumentElement().getFirstChild().getFirstChild();
        }
        finally {
            if (this.inputOctetStreamProxy != null) {
                this.inputOctetStreamProxy.close();
            }
            this.inputOctetStreamProxy = null;
            this.bytes = null;
        }
    }

    private static byte[] canonicalizeXml(Element element, String string) throws IOException {
        nu.xom.Element element2 = DOMConverter.convert((Element)element);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Canonicalizer canonicalizer = new Canonicalizer((OutputStream)byteArrayOutputStream, string);
        canonicalizer.write((Node)element2);
        return byteArrayOutputStream.toByteArray();
    }
}

