/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xml;

import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.dsig.XMLSignatureFactory;

public class XmlDSigProviderHelper {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String APACHE_XMLDSIG = "ApacheXMLDSig";
    private static final String XMLDSIG = "XMLDSig";
    private static Provider defaultProvider;
    private static boolean configured;

    public static void configureXmlDSigProvider() {
        if (configured) {
            return;
        }
        try {
            defaultProvider = XMLSignatureFactory.getInstance("DOM").getProvider();
        }
        catch (Exception exception) {
            LOGGER.warning("No se encontro un proveedor por defecto para la generacion de firmas XML: " + exception);
        }
        System.setProperty("com.sun.org.apache.xml.internal.security.lineFeedOnly", "true");
        System.setProperty("org.apache.xml.security.ignoreLineBreaks", "true");
        Provider provider = Security.getProvider(APACHE_XMLDSIG);
        if (provider == null) {
            try {
                XmlDSigProviderHelper.installProvider("org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI");
                Security.removeProvider(XMLDSIG);
            }
            catch (Throwable throwable) {
                LOGGER.warning("No se ha podido instalar el proveedor XMLDSig de Apache: " + throwable);
                try {
                    XmlDSigProviderHelper.installProvider("org.jcp.xml.dsig.internal.dom.XMLDSigRI");
                    Security.removeProvider(XMLDSIG);
                }
                catch (Throwable throwable2) {
                    LOGGER.warning("No se ha podido instalar el proveedor XMLDSig de Sun: " + throwable2);
                }
            }
        }
        try {
            Provider provider2 = XMLSignatureFactory.getInstance("DOM").getProvider();
            LOGGER.info("Se usara el proveedor '" + provider2.getName() + "': " + provider2.getClass().getName());
        }
        catch (NoSuchMechanismException noSuchMechanismException) {
            LOGGER.warning("No hay proveedor instalado para XMLDSig. Se reinstala el proveedor por defecto: " + noSuchMechanismException);
            Security.addProvider(defaultProvider);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error en la verificacion de los proveedores XML", exception);
        }
        configured = true;
    }

    private static void installProvider(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        boolean bl = false;
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; !bl && i < providerArray.length; ++i) {
            bl = string.equals(providerArray[i].getClass().getName());
        }
        if (!bl) {
            Class<?> clazz = Class.forName(string);
            Provider provider = (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOGGER.info("Instalamos el proveedor " + provider.getName() + ": " + provider.getClass().getName());
            Security.insertProviderAt(provider, 1);
        }
    }

    static {
        configured = false;
    }
}

