/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xml;

import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSimpleSignInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public final class Utils {
    private static final Logger LOGGER;
    private static DocumentBuilderFactory SECURE_BUILDER_FACTORY;

    private Utils() {
    }

    public static DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        return SECURE_BUILDER_FACTORY.newDocumentBuilder();
    }

    private static String addStyleSheetHeader(String string, String string2, String string3) {
        String string4;
        if (string3 == null) {
            return string;
        }
        String string5 = string4 = string2 != null ? string2 : "text/xsl";
        if (string == null || string.isEmpty()) {
            return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><?xml-stylesheet type=\"" + string4 + "\" href=\"" + string3 + "\"?>";
        }
        return string.replaceFirst(">", ">\r\n<?xml-stylesheet type=\"" + string4 + "\" href=\"" + string3 + "\"?>");
    }

    public static void addCustomTransforms(List<Transform> arrayList, Properties properties, String string) {
        ArrayList<Transform> arrayList2 = arrayList != null ? arrayList : new ArrayList<Transform>();
        Properties properties2 = properties != null ? properties : new Properties();
        int n = Integer.parseInt(properties2.getProperty("xmlTransforms", "0"));
        for (int i = 0; i < n; ++i) {
            TransformParameterSpec transformParameterSpec;
            String string2;
            block19: {
                string2 = properties2.getProperty("xmlTransform" + Integer.toString(i) + "Type");
                String string3 = properties2.getProperty("xmlTransform" + Integer.toString(i) + "Body");
                if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(string2) && string3 != null) {
                    try {
                        transformParameterSpec = new XPathFilterParameterSpec(string3, Collections.singletonMap(string, "http://www.w3.org/2000/09/xmldsig#"));
                        break block19;
                    }
                    catch (Exception exception) {
                        LOGGER.warning("No se han podido crear los parametros para una transformacion XPATH, se omitira: " + exception);
                        continue;
                    }
                }
                if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(string2) && string3 != null) {
                    XPathType.Filter filter;
                    String string4 = properties2.getProperty("xmlTransform" + Integer.toString(i) + "Subtype");
                    if ("subtract".equals(string4)) {
                        filter = XPathType.Filter.SUBTRACT;
                    } else if ("intersect".equals(string4)) {
                        filter = XPathType.Filter.INTERSECT;
                    } else if ("union".equals(string4)) {
                        filter = XPathType.Filter.UNION;
                    } else {
                        LOGGER.warning("Se ha solicitado aplicar una transformacion XPATH2 de un tipo no soportado: " + string4);
                        continue;
                    }
                    try {
                        transformParameterSpec = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType(string3, filter)));
                        break block19;
                    }
                    catch (Exception exception) {
                        LOGGER.warning("No se han podido crear los parametros para una transformacion XPATH2, se omitira: " + exception);
                        continue;
                    }
                }
                if ("http://www.w3.org/2000/09/xmldsig#base64".equals(string2)) {
                    transformParameterSpec = null;
                } else if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(string2)) {
                    transformParameterSpec = null;
                } else {
                    LOGGER.warning("Tipo de transformacion no soportada: " + string2);
                    continue;
                }
            }
            try {
                arrayList2.add(Utils.getDOMFactory().newTransform(string2, transformParameterSpec));
                continue;
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido aplicar la transformacion '" + string2 + "': " + exception);
            }
        }
    }

    public static List<Transform> getObjectReferenceTransforms(Node node, String string) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ArrayList<Transform> arrayList = new ArrayList<Transform>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!"Transforms".equals(nodeList.item(i).getNodeName()) && !(string + ":Transforms").equals(nodeList.item(i).getNodeName())) continue;
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (nodeList2.item(j).getNodeType() != 1) continue;
                arrayList.add(Utils.getDOMFactory().newTransform(Utils.getTransformAlgorithm(nodeList2.item(j)), Utils.getTransformParameterSpec(nodeList2.item(j), string)));
            }
            break;
        }
        return arrayList;
    }

    private static String getTransformAlgorithm(Node node) {
        Node node2;
        NamedNodeMap namedNodeMap;
        String string = null;
        if (node != null && (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem("Algorithm")) != null) {
            string = node2.getNodeValue();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TransformParameterSpec getTransformParameterSpec(Node node, String string) throws InvalidAlgorithmParameterException {
        void var2_7;
        void var2_8;
        Object var2_2 = null;
        String string2 = Utils.getTransformAlgorithm(node);
        if (string2 == null) return var2_8;
        if (!"http://www.w3.org/TR/1999/REC-xpath-19991116".equals(string2) && !"http://www.w3.org/2002/06/xmldsig-filter2".equals(string2)) return var2_8;
        if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(string2)) {
            void var2_5;
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!"XPath".equals(node2.getNodeName()) && !(string + ":XPath").equals(node2.getNodeName())) continue;
                if (string == null || string.isEmpty()) {
                    XPathFilterParameterSpec xPathFilterParameterSpec = new XPathFilterParameterSpec(node2.getTextContent());
                    break;
                }
                XPathFilterParameterSpec xPathFilterParameterSpec = new XPathFilterParameterSpec(node2.getTextContent(), Collections.singletonMap(string, "http://www.w3.org/2000/09/xmldsig#"));
                break;
            }
            if (var2_5 != null) return var2_8;
            throw new InvalidAlgorithmParameterException("No se ha indicado un cuerpo para una transformacion XPATH declarada");
        }
        if (!"http://www.w3.org/2002/06/xmldsig-filter2".equals(string2)) return var2_8;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XPathType.Filter filter;
            Node node3 = nodeList.item(i);
            if (!"XPath".equals(node3.getNodeName()) && !(string + ":XPath").equals(node3.getNodeName())) continue;
            Node node4 = node3.getAttributes().getNamedItem("Filter");
            if (node4 == null) throw new InvalidAlgorithmParameterException("No se ha declarado un subtipo para la transformacion XPATH2");
            String string3 = node4.getNodeValue();
            if (string3.equals("subtract")) {
                filter = XPathType.Filter.SUBTRACT;
            } else if (string3.equals("intersect")) {
                filter = XPathType.Filter.INTERSECT;
            } else {
                if (!string3.equals("union")) throw new InvalidAlgorithmParameterException("El subtipo '" + string3 + "' de la transformacion XPATH2 no es valido");
                filter = XPathType.Filter.UNION;
            }
            XPathFilter2ParameterSpec xPathFilter2ParameterSpec = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType(node3.getTextContent(), filter)));
            break;
        }
        if (var2_7 != null) return var2_8;
        throw new InvalidAlgorithmParameterException("No se ha indicado un cuerpo para una transformacion XPATH2 declarada");
    }

    public static void checkIllegalParams(String string, String string2, boolean bl, URI uRI, String string3, boolean bl2) {
        if (bl2) {
            if (string2 != null) {
                LOGGER.warning("El parametro 'mode' se ignora en las firmas XAdES");
            }
            if (string.equalsIgnoreCase("XAdES Externally Detached")) {
                if (uRI == null && !bl) {
                    throw new UnsupportedOperationException("Las firmas XML Externally Detached necesitan la URI para referenciar a los datos firmados");
                }
            } else if (uRI != null) {
                LOGGER.warning("Se ignorara el parametro 'uri' ya que este solo se utiliza con el formato XAdES Externally Detached");
            }
            if (!(string.equalsIgnoreCase("XAdES Detached") || string.equalsIgnoreCase("XAdES Enveloped") || string.equalsIgnoreCase("XAdES Enveloping") || string.equalsIgnoreCase("XAdES Externally Detached"))) {
                throw new UnsupportedOperationException("El formato de firma '" + string + "' no esta soportado");
            }
        } else {
            if (!string2.equalsIgnoreCase("implicit") && !string2.equalsIgnoreCase("explicit")) {
                throw new UnsupportedOperationException("El modo de firma '" + string2 + "' no esta soportado");
            }
            if (string.equalsIgnoreCase("XMLDSig Enveloped") && string2.equalsIgnoreCase("explicit")) {
                throw new UnsupportedOperationException("No se puede realizar una firma enveloped sobre un contenido explicito");
            }
            if (string.equalsIgnoreCase("XMLDSig Externally Detached") && string2.equalsIgnoreCase("implicit")) {
                throw new UnsupportedOperationException("No se puede realizar una firma XML Externally Detached con contenido Implicito");
            }
            if (string.equalsIgnoreCase("XMLDSig Externally Detached") && uRI == null && string3 == null) {
                throw new UnsupportedOperationException("La firma XML Externally Detached necesita un Message Digest precalculado o una URI accesible");
            }
            if (!(string.equalsIgnoreCase("XMLDSig Detached") || string.equalsIgnoreCase("XMLDSig Enveloped") || string.equalsIgnoreCase("XMLDSig Enveloping") || string.equalsIgnoreCase("XMLDSig Externally Detached"))) {
                throw new UnsupportedOperationException("El formato de firma '" + string + "' no esta soportado");
            }
        }
    }

    public static int countSubstring(String string, String string2) {
        int n = 0;
        for (int i = 0; i <= string.length() - string2.length(); ++i) {
            if (string2.charAt(0) != string.charAt(i) || !string2.equals(string.substring(i, i + string2.length()))) continue;
            ++n;
            i += string2.length() - 1;
        }
        return n;
    }

    public static byte[] writeXML(Node node, Map<String, String> hashtable, String string, String string2) {
        Hashtable hashtable2 = hashtable != null ? hashtable : new Hashtable(0);
        String string3 = hashtable2.containsKey("encoding") ? (String)hashtable2.get("encoding") : StandardCharsets.UTF_8.name();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.warning("La codificacion '" + string3 + "' no es valida, se usara la por defecto: " + unsupportedEncodingException);
            outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        }
        Utils.writeXMLwithXALAN(outputStreamWriter, node, string3);
        if (!AOFileUtils.isXML((byte[])byteArrayOutputStream.toByteArray())) {
            return byteArrayOutputStream.toByteArray();
        }
        try {
            return Utils.addStyleSheetHeader(new String(byteArrayOutputStream.toByteArray(), string3), string2, string).getBytes(string3);
        }
        catch (Exception exception) {
            LOGGER.warning("La codificacion '" + string3 + "' no es valida, se usara la por defecto del sistema: " + exception);
            return Utils.addStyleSheetHeader(new String(byteArrayOutputStream.toByteArray()), string2, string).getBytes();
        }
    }

    private static void writeXMLwithXALAN(Writer writer, Node node, String string) {
        Document document = node.getOwnerDocument();
        if (document.getFeature("Core", "3.0") == null || document.getFeature("LS", "3.0") == null) {
            throw new RuntimeException("La implementacion DOM cargada no permite la serializacion");
        }
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        lSOutput.setCharacterStream(writer);
        if (string != null) {
            lSOutput.setEncoding(string);
        }
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        lSSerializer.getDomConfig().setParameter("namespaces", Boolean.FALSE);
        lSSerializer.write(node, lSOutput);
    }

    public static AOSimpleSignInfo getSimpleSignInfoNode(String string, Element element) {
        byte[] byArray;
        Object object;
        Date date = null;
        if (string != null) {
            object = (Element)element.getElementsByTagNameNS(string, "SigningTime").item(0);
            if (object != null) {
                try {
                    date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(object.getTextContent());
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "No se ha podido recuperar la fecha de firma", exception);
                }
            } else {
                LOGGER.info("No se ha encontrado la hora de firma de una firma");
            }
        }
        object = new ArrayList();
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object.add(Utils.getCertificate(nodeList.item(i)));
        }
        AOSimpleSignInfo aOSimpleSignInfo = new AOSimpleSignInfo(object.toArray(new X509Certificate[object.size()]), date);
        aOSimpleSignInfo.setSignAlgorithm(((Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod").item(0)).getAttribute("Algorithm"));
        try {
            byArray = Base64.decode((String)((Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue").item(0)).getTextContent());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "No se pudo extraer el PKCS#1 de una firma", exception);
            byArray = null;
        }
        aOSimpleSignInfo.setPkcs1(byArray);
        return aOSimpleSignInfo;
    }

    public static String getStringInfoNode(Element element) {
        return AOUtil.getCN((X509Certificate)Utils.getCertificate(element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0)));
    }

    public static X509Certificate getCertificate(Node node) {
        return Utils.createCert(node.getTextContent().trim().replace("\r", "").replace("\n", "").replace(" ", "").replace("\t", ""));
    }

    public static String getCounterSignerReferenceId(Element element, NodeList nodeList) {
        String string = ((Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference").item(0)).getAttribute("URI").substring(1);
        String string2 = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("Id").equals(string)) continue;
            string2 = ((Element)element2.getParentNode()).getAttribute("Id");
            break;
        }
        return string2;
    }

    public static X509Certificate createCert(String string) {
        X509Certificate x509Certificate;
        if (string == null || string.isEmpty()) {
            LOGGER.severe("Se ha proporcionado una cadena nula o vacia, se devolvera null");
            return null;
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode((String)string));){
            x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(byteArrayInputStream);
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (Exception exception) {
                LOGGER.warning("Error cerrando el flujo de lectura del certificado: " + exception);
            }
        }
        catch (Exception exception) {
            LOGGER.severe("No se pudo decodificar el certificado en Base64, se devolvera null: " + exception);
            return null;
        }
        return x509Certificate;
    }

    public static XMLSignatureFactory getDOMFactory() {
        return XMLSignatureFactory.getInstance("DOM");
    }

    static {
        String[] stringArray;
        LOGGER = Logger.getLogger("es.gob.afirma");
        SECURE_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
        try {
            SECURE_BUILDER_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "No se ha podido establecer una caracteristica de seguridad en la factoria XML: " + exception);
        }
        for (String string : stringArray = new String[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", "http://javax.xml.XMLConstants/property/accessExternalSchema", "http://javax.xml.XMLConstants/property/accessExternalStylesheet"}) {
            try {
                SECURE_BUILDER_FACTORY.setAttribute(string, "");
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "No se ha podido establecer una propiedad de seguridad '" + string + "' en la factoria XML");
            }
        }
        SECURE_BUILDER_FACTORY.setValidating(false);
        SECURE_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

