/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.BEROctetString;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.cms.CMSProcessableByteArray;

final class CmsUtil {
    private CmsUtil() {
    }

    static ASN1OctetString firma(String string, PrivateKey privateKey, ASN1Set aSN1Set) throws AOException {
        byte[] byArray;
        byte[] byArray2;
        Signature signature;
        try {
            signature = Signature.getInstance(string);
        }
        catch (Exception exception) {
            throw new AOException("Error obteniendo la clase de firma para el algoritmo " + string, (Throwable)exception);
        }
        try {
            byArray2 = aSN1Set.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new AOException("Error obteniendo los atributos firmados", (Throwable)iOException);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (Exception exception) {
            throw new AOException("Error al inicializar la firma con la clave privada", (Throwable)exception);
        }
        try {
            signature.update(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new AOException("Error al configurar la informacion de firma", (Throwable)signatureException);
        }
        try {
            byArray = signature.sign();
        }
        catch (Exception exception) {
            throw new AOException("Error durante el proceso de firma", (Throwable)exception);
        }
        return new DEROctetString(byArray);
    }

    static ContentInfo getContentInfo(byte[] byArray, boolean bl, String string) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        if (!bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(byArray);
            try {
                cMSProcessableByteArray.write((OutputStream)byteArrayOutputStream);
            }
            catch (Exception exception) {
                throw new IOException("Error en la escritura del procesable CMS: " + exception, exception);
            }
            return new ContentInfo(aSN1ObjectIdentifier, (ASN1Encodable)new BEROctetString(byteArrayOutputStream.toByteArray()));
        }
        return new ContentInfo(aSN1ObjectIdentifier, null);
    }
}

