/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.cms.CoSigner;
import es.gob.afirma.signers.cms.CounterSigner;
import es.gob.afirma.signers.cms.GenSignedData;
import es.gob.afirma.signers.cms.ValidateCMSSignedData;
import es.gob.afirma.signers.pkcs7.ObtainContentSignedData;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.ReadNodesTree;
import es.gob.afirma.signers.pkcs7.SCChecker;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;

public final class AOCMSSigner
implements AOSigner {
    private String dataType = null;
    private final Map<String, byte[]> atrib = new HashMap<String, byte[]>();
    private final Map<String, byte[]> uatrib = new HashMap<String, byte[]>();
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        String string2;
        new SCChecker().checkSpongyCastle();
        Properties properties2 = properties != null ? properties : new Properties();
        String string3 = properties2.getProperty("precalculatedHashAlgorithm");
        byte[] byArray2 = null;
        if (string3 != null) {
            byArray2 = byArray;
        }
        P7ContentSignerParameters p7ContentSignerParameters = new P7ContentSignerParameters(byArray, string);
        if (this.dataType == null) {
            this.dataType = PKCSObjectIdentifiers.data.getId();
        }
        boolean bl = (string2 = properties2.getProperty("mode", "explicit")).equals("explicit") || string3 != null;
        try {
            return new GenSignedData().generateSignedData(p7ContentSignerParameters, bl, Boolean.parseBoolean(properties2.getProperty("applySystemDate", "true")), this.dataType, privateKey, certificateArray, this.atrib, this.uatrib, byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("Error en el algoritmo de firma: " + noSuchAlgorithmException, (Throwable)noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new AOException("Error en el certificado de firma: " + certificateException, (Throwable)certificateException);
        }
    }

    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        String string2;
        boolean bl;
        new SCChecker().checkSpongyCastle();
        Properties properties2 = properties != null ? properties : new Properties();
        String string3 = properties2.getProperty("precalculatedHashAlgorithm");
        byte[] byArray3 = null;
        if (string3 != null) {
            byArray3 = byArray;
        }
        P7ContentSignerParameters p7ContentSignerParameters = new P7ContentSignerParameters(byArray, string);
        if (this.dataType == null) {
            this.dataType = PKCSObjectIdentifiers.data.getId();
        }
        boolean bl2 = bl = (string2 = properties2.getProperty("mode", "explicit")).equals("explicit") || string3 != null;
        if (ValidateCMSSignedData.isCMSSignedData(byArray2)) {
            try {
                return new CoSigner().coSigner(p7ContentSignerParameters, byArray2, bl, this.dataType, privateKey, certificateArray, this.atrib, this.uatrib, byArray3);
            }
            catch (Exception exception) {
                throw new AOException("Error generando la Cofirma PKCS#7", (Throwable)exception);
            }
        }
        throw new AOException("Los datos no se corresponden con una firma CMS valida");
    }

    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        new SCChecker().checkSpongyCastle();
        if (this.dataType == null) {
            this.dataType = PKCSObjectIdentifiers.data.getId();
        }
        if (ValidateCMSSignedData.isCMSSignedData(byArray)) {
            try {
                return new CoSigner().coSigner(string, (X509Certificate[])certificateArray, byArray, this.dataType, privateKey, this.atrib, this.uatrib, null);
            }
            catch (Exception exception) {
                throw new AOException("Error generando la Cofirma PKCS#7", (Throwable)exception);
            }
        }
        throw new AOException("Los datos no se corresponden con una firma CMS valida");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        new SCChecker().checkSpongyCastle();
        P7ContentSignerParameters p7ContentSignerParameters = new P7ContentSignerParameters(byArray, string);
        if (this.dataType == null) {
            this.dataType = PKCSObjectIdentifiers.data.getId();
        }
        byte[] byArray2 = null;
        if (!ValidateCMSSignedData.isCMSSignedData(byArray)) throw new AOException("Los datos no se corresponden con una firma CMS valida");
        try {
            if (counterSignTarget == CounterSignTarget.TREE) {
                int[] nArray = new int[]{0};
                return new CounterSigner().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.TREE, nArray, privateKey, certificateArray, this.atrib, this.uatrib);
            }
            if (counterSignTarget == CounterSignTarget.LEAFS) {
                int[] nArray = new int[]{0};
                return new CounterSigner().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.LEAFS, nArray, privateKey, certificateArray, this.atrib, this.uatrib);
            }
            if (counterSignTarget == CounterSignTarget.NODES) {
                int[] nArray = new int[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    nArray[i] = (Integer)objectArray[i];
                }
                nArray = ReadNodesTree.simplyArray((int[])nArray);
                return new CounterSigner().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.NODES, nArray, privateKey, certificateArray, this.atrib, this.uatrib);
            }
            if (counterSignTarget != CounterSignTarget.SIGNERS) return byArray2;
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)objectArray[i];
            }
            ReadNodesTree readNodesTree = new ReadNodesTree();
            int[] nArray = readNodesTree.readNodesFromSigners(stringArray, byArray);
            return new CounterSigner().counterSigner(p7ContentSignerParameters, byArray, CounterSignTarget.SIGNERS, nArray, privateKey, certificateArray, this.atrib, this.uatrib);
        }
        catch (Exception exception) {
            throw new AOException("Error generando la Contrafirma PKCS#7", (Throwable)exception);
        }
    }

    public AOTreeModel getSignersStructure(byte[] byArray, Properties properties, boolean bl) throws AOInvalidFormatException, IOException {
        new SCChecker().checkSpongyCastle();
        ReadNodesTree readNodesTree = new ReadNodesTree();
        try {
            return readNodesTree.readNodesTree(byArray, bl);
        }
        catch (Exception exception) {
            LOGGER.severe(exception.toString());
            return null;
        }
    }

    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException, IOException {
        return this.getSignersStructure(byArray, null, bl);
    }

    public boolean isSign(byte[] byArray, Properties properties) throws IOException {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return ValidateCMSSignedData.isCMSSignedData(byArray);
    }

    public boolean isSign(byte[] byArray) throws IOException {
        return this.isSign(byArray, null);
    }

    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    public void addSignedAttribute(String string, byte[] byArray) {
        this.atrib.put(string, byArray);
    }

    public void addUnsignedAttribute(String string, byte[] byArray) {
        this.uatrib.put(string, byArray);
    }

    public byte[] getData(byte[] byArray, Properties properties) throws IOException, AOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Se han introducido datos nulos para su comprobacion");
        }
        if (!ValidateCMSSignedData.isCMSSignedData(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return ObtainContentSignedData.obtainData((byte[])byArray);
    }

    public byte[] getData(byte[] byArray) throws AOException, IOException {
        return this.getData(byArray, null);
    }

    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".csig";
    }

    public AOSignInfo getSignInfo(byte[] byArray, Properties properties) throws AOException, IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        AOSignInfo aOSignInfo = new AOSignInfo("CMS/PKCS#7");
        return aOSignInfo;
    }

    public AOSignInfo getSignInfo(byte[] byArray) throws AOException, IOException {
        return this.getSignInfo(byArray, null);
    }
}

