/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.signers.pkcs7.SCChecker;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;

final class ValidateCMSSignedData {
    private ValidateCMSSignedData() {
    }

    public static boolean isCMSSignedData(byte[] byArray) throws IOException {
        new SCChecker().checkSpongyCastle();
        boolean bl = true;
        try (ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);){
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            Enumeration enumeration = aSN1Sequence.getObjects();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            if (!aSN1ObjectIdentifier.equals((Object)PKCSObjectIdentifiers.signedData)) {
                bl = false;
            } else {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1TaggedObject.getObject();
                SignedData signedData = SignedData.getInstance((Object)aSN1Sequence2);
                ASN1Set aSN1Set = signedData.getSignerInfos();
                for (int i = 0; bl && i < aSN1Set.size(); ++i) {
                    SignerInfo signerInfo = SignerInfo.getInstance((Object)aSN1Set.getObjectAt(i));
                    bl = ValidateCMSSignedData.verifySignerInfo(signerInfo);
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    private static boolean verifySignerInfo(SignerInfo signerInfo) {
        boolean bl = true;
        ASN1Set aSN1Set = signerInfo.getAuthenticatedAttributes();
        Enumeration enumeration = aSN1Set.getObjects();
        while (bl && enumeration.hasMoreElements()) {
            Attribute attribute = Attribute.getInstance(enumeration.nextElement());
            if (!attribute.getAttrType().equals((Object)PKCSObjectIdentifiers.id_aa_ets_sigPolicyId)) continue;
            bl = false;
            Logger.getLogger("es.gob.afirma").warning("El signerInfo no es del tipo CMS, es del tipo CADES");
        }
        return bl;
    }
}

