/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.batch.client;

import es.gob.afirma.signers.batch.client.BatchDataResult;
import es.gob.afirma.signers.batch.client.BatchInfo;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONBatchInfo
implements BatchInfo {
    private static final String JSELEM_SINGLESIGNS = "singlesigns";
    private static final String JSELEM_DATAREFERENCE = "datareference";
    private static final String JSELEM_FORMAT = "format";
    private static final String JSELEM_SUBOPERATION = "suboperation";
    private static final String JSELEM_EXTRAPARAMS = "extraparams";
    private static final String JSELEM_ID = "id";
    private static final String JSELEM_RESULT = "result";
    private static final String JSELEM_DESCRIPTION = "description";
    private final JSONObject batch;

    public JSONBatchInfo(JSONObject jSONObject) {
        this.batch = jSONObject;
    }

    @Override
    public void updateResults(List<BatchDataResult> list) {
        JSONArray jSONArray = this.batch.getJSONArray(JSELEM_SINGLESIGNS);
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            String string = jSONObject.getString(JSELEM_ID);
            boolean bl = false;
            for (int j = 0; j < list.size() && !bl; ++j) {
                BatchDataResult batchDataResult = list.get(j);
                if (!batchDataResult.getId().equals(string)) continue;
                jSONObject.remove(JSELEM_DATAREFERENCE);
                jSONObject.remove(JSELEM_FORMAT);
                jSONObject.remove(JSELEM_SUBOPERATION);
                jSONObject.remove(JSELEM_EXTRAPARAMS);
                jSONObject.put(JSELEM_RESULT, (Object)batchDataResult.getResult().name());
                if (batchDataResult.getDescription() != null) {
                    jSONObject.put(JSELEM_DESCRIPTION, (Object)batchDataResult.getDescription());
                }
                bl = true;
            }
        }
    }

    @Override
    public String getInfoString() {
        return this.batch.toString();
    }
}

