/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.batch.client;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.LoggerUtil;
import es.gob.afirma.core.misc.SecureXmlBuilder;
import es.gob.afirma.core.misc.http.HttpError;
import es.gob.afirma.core.misc.http.UrlHttpManagerFactory;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.TriphaseData;
import es.gob.afirma.core.signers.TriphaseDataSigner;
import es.gob.afirma.signers.batch.client.BatchDataResult;
import es.gob.afirma.signers.batch.client.BatchInfo;
import es.gob.afirma.signers.batch.client.JSONBatchInfoParser;
import es.gob.afirma.signers.batch.client.JSONPreSignBatchParser;
import es.gob.afirma.signers.batch.client.PresignBatch;
import es.gob.afirma.signers.batch.client.TriphaseDataParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class BatchSigner {
    private static final String BATCH_XML_PARAM = "xml";
    private static final String BATCH_JSON_PARAM = "json";
    private static final String BATCH_CRT_PARAM = "certs";
    private static final String BATCH_TRI_PARAM = "tridata";
    private static final String EQU = "=";
    private static final String AMP = "&";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private BatchSigner() {
    }

    public static String signXML(String string, String string2, String string3, Certificate[] certificateArray, PrivateKey privateKey) throws CertificateEncodingException, IOException, AOException {
        byte[] byArray;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("El lote de firma no puede ser nulo ni vacio");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("La URL de preproceso de lotes no puede se nula ni vacia");
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("La URL de postproceso de lotes no puede ser nula ni vacia");
        }
        if (certificateArray == null || certificateArray.length < 1) {
            throw new IllegalArgumentException("La cadena de certificados del firmante no puede ser nula ni vacia");
        }
        String string4 = string.replace("+", "-").replace("/", "_");
        try {
            byArray = UrlHttpManagerFactory.getInstalledManager().readUrl(string2 + "?" + BATCH_XML_PARAM + EQU + string4 + AMP + BATCH_CRT_PARAM + EQU + BatchSigner.getCertChainAsBase64(certificateArray), UrlHttpMethod.POST);
        }
        catch (HttpError httpError) {
            LOGGER.warning("El servicio de firma devolvio un  error durante la prefirma: " + httpError.getResponseDescription());
            throw httpError;
        }
        TriphaseData triphaseData = TriphaseData.parser((byte[])byArray);
        TriphaseData triphaseData2 = TriphaseDataSigner.doSign((AOPkcs1Signer)new AOPkcs1Signer(), (String)BatchSigner.getAlgorithmForXML(string), (PrivateKey)privateKey, (Certificate[])certificateArray, (TriphaseData)triphaseData, null);
        try {
            byArray = UrlHttpManagerFactory.getInstalledManager().readUrl(string3 + "?" + BATCH_XML_PARAM + EQU + string4 + AMP + BATCH_CRT_PARAM + EQU + BatchSigner.getCertChainAsBase64(certificateArray) + AMP + BATCH_TRI_PARAM + EQU + Base64.encode((byte[])triphaseData2.toString().getBytes(DEFAULT_CHARSET), (boolean)true), UrlHttpMethod.POST);
        }
        catch (HttpError httpError) {
            LOGGER.warning("El servicio de firma devolvio un  error durante la postfirma: " + httpError.getResponseDescription());
            throw httpError;
        }
        return new String(byArray, DEFAULT_CHARSET);
    }

    public static String signJSON(String string, String string2, String string3, Certificate[] certificateArray, PrivateKey privateKey) throws CertificateEncodingException, IOException, AOException {
        byte[] byArray;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("El lote de firma no puede ser nulo ni vacio");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("La URL de preproceso de lotes no puede se nula ni vacia");
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("La URL de postproceso de lotes no puede ser nula ni vacia");
        }
        if (certificateArray == null || certificateArray.length < 1) {
            throw new IllegalArgumentException("La cadena de certificados del firmante no puede ser nula ni vacia");
        }
        String string4 = string.replace("+", "-").replace("/", "_");
        try {
            byArray = UrlHttpManagerFactory.getInstalledManager().readUrl(string2 + "?" + BATCH_JSON_PARAM + EQU + string4 + AMP + BATCH_CRT_PARAM + EQU + BatchSigner.getCertChainAsBase64(certificateArray), UrlHttpMethod.POST);
        }
        catch (HttpError httpError) {
            LOGGER.warning("El servicio de firma devolvio un  error durante la prefirma: " + (Object)((Object)httpError));
            throw httpError;
        }
        PresignBatch presignBatch = JSONPreSignBatchParser.parseFromJSON(byArray);
        TriphaseData triphaseData = presignBatch.getTriphaseData();
        List<BatchDataResult> list = presignBatch.getErrors();
        if (triphaseData == null && list == null) {
            return JSONBatchInfoParser.buildEmptyResult().toString();
        }
        if (triphaseData == null) {
            return JSONBatchInfoParser.buildResult(list).toString();
        }
        if (list != null) {
            BatchInfo batchInfo = JSONBatchInfoParser.parse(Base64.decode((String)string));
            batchInfo.updateResults(list);
            byte[] byArray2 = batchInfo.getInfoString().getBytes(StandardCharsets.UTF_8);
            string4 = Base64.encode((byte[])byArray2, (boolean)true);
        }
        triphaseData = TriphaseDataSigner.doSign((AOPkcs1Signer)new AOPkcs1Signer(), (String)BatchSigner.getAlgorithmForJSON(string), (PrivateKey)privateKey, (Certificate[])certificateArray, (TriphaseData)triphaseData, null);
        try {
            byArray = UrlHttpManagerFactory.getInstalledManager().readUrl(string3 + "?" + BATCH_JSON_PARAM + EQU + string4 + AMP + BATCH_CRT_PARAM + EQU + BatchSigner.getCertChainAsBase64(certificateArray) + AMP + BATCH_TRI_PARAM + EQU + Base64.encode((byte[])TriphaseDataParser.triphaseDataToJsonString(triphaseData).getBytes(DEFAULT_CHARSET), (boolean)true), UrlHttpMethod.POST);
        }
        catch (HttpError httpError) {
            LOGGER.warning("El servicio de firma devolvio un  error durante la postfirma: " + (Object)((Object)httpError));
            throw httpError;
        }
        return new String(byArray, DEFAULT_CHARSET);
    }

    private static String getCertChainAsBase64(Certificate[] certificateArray) throws CertificateEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Certificate certificate : certificateArray) {
            stringBuilder.append(Base64.encode((byte[])certificate.getEncoded(), (boolean)true));
            stringBuilder.append(";");
        }
        String string = stringBuilder.toString();
        return string.substring(0, string.length() - 1);
    }

    private static String getAlgorithmForXML(String string) throws IOException {
        Document document;
        Object object;
        Object object2;
        byte[] byArray = Base64.decode((String)string.replace("-", "+").replace("_", "/"));
        try {
            object2 = new ByteArrayInputStream(byArray);
            object = null;
            try {
                document = SecureXmlBuilder.getSecureDocumentBuilder().parse((InputStream)object2);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.severe("Error al cargar el fichero XML de lote: " + exception + "\n" + LoggerUtil.getTrimBytes((byte[])byArray));
            throw new IOException("Error al cargar el fichero XML de lote: " + exception, exception);
        }
        object2 = document.getDocumentElement();
        if (!"signbatch".equalsIgnoreCase(object2.getNodeName())) {
            throw new IllegalArgumentException("No se encontro el nodo 'signbatch' en el XML proporcionado");
        }
        object = object2.getAttributes();
        if (object != null) {
            Node node = object.getNamedItem("algorithm");
            if (node != null) {
                return node.getNodeValue();
            }
            throw new IllegalArgumentException("El nodo 'signbatch' debe contener al manos el atributo de algoritmo");
        }
        throw new IllegalArgumentException("El nodo 'signbatch' debe contener al manos el atributo de algoritmo");
    }

    private static String getAlgorithmForJSON(String string) throws IOException {
        JSONObject jSONObject = null;
        String string2 = new String(Base64.decode((String)string), DEFAULT_CHARSET);
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            LOGGER.severe("Error al parsear JSON");
            throw new JSONException("El JSON de definicion de lote de firmas no esta formado correctamente");
        }
        if (jSONObject.has("algorithm")) {
            return jSONObject.getString("algorithm");
        }
        throw new IllegalArgumentException("El nodo 'signbatch' debe contener al manos el atributo de algoritmo");
    }
}

