/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.util.tree;

import java.util.ArrayList;
import java.util.List;

public final class AOTreeNode {
    private AOTreeNode parent = null;
    private List<AOTreeNode> children;
    private transient Object userObject;

    public AOTreeNode(Object object) {
        this.userObject = object;
    }

    private void insert(AOTreeNode aOTreeNode, int n) {
        if (aOTreeNode == null) {
            throw new IllegalArgumentException("EL nuevo hijo es nulo");
        }
        if (this.isNodeAncestor(aOTreeNode)) {
            throw new IllegalArgumentException("El nuevo hijo es ya un ancestro");
        }
        AOTreeNode aOTreeNode2 = aOTreeNode.getParent();
        if (aOTreeNode2 != null) {
            aOTreeNode2.remove(aOTreeNode);
        }
        aOTreeNode.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList<AOTreeNode>();
        }
        this.children.add(n, aOTreeNode);
    }

    private void remove(int n) {
        AOTreeNode aOTreeNode = this.getChildAt(n);
        this.children.remove(n);
        aOTreeNode.setParent(null);
    }

    public void setParent(AOTreeNode aOTreeNode) {
        this.parent = aOTreeNode;
    }

    public AOTreeNode getParent() {
        return this.parent;
    }

    public AOTreeNode getChildAt(int n) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("El nodo no tiene hijos");
        }
        return this.children.get(n);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    private int getIndex(AOTreeNode aOTreeNode) {
        if (aOTreeNode == null) {
            throw new IllegalArgumentException("Argumento nulo");
        }
        if (!this.isNodeChild(aOTreeNode)) {
            return -1;
        }
        return this.children.indexOf(aOTreeNode);
    }

    public Object getUserObject() {
        return this.userObject;
    }

    private void remove(AOTreeNode aOTreeNode) {
        if (aOTreeNode == null) {
            throw new IllegalArgumentException("Argumento nulo");
        }
        if (!this.isNodeChild(aOTreeNode)) {
            throw new IllegalArgumentException("El argumento no es un hijo");
        }
        this.remove(this.getIndex(aOTreeNode));
    }

    public void add(AOTreeNode aOTreeNode) {
        if (aOTreeNode != null && aOTreeNode.getParent() == this) {
            this.insert(aOTreeNode, this.getChildCount() - 1);
        } else {
            this.insert(aOTreeNode, this.getChildCount());
        }
    }

    private boolean isNodeAncestor(AOTreeNode aOTreeNode) {
        if (aOTreeNode == null) {
            return false;
        }
        AOTreeNode aOTreeNode2 = this;
        do {
            if (!aOTreeNode2.equals(aOTreeNode)) continue;
            return true;
        } while ((aOTreeNode2 = aOTreeNode2.getParent()) != null);
        return false;
    }

    private boolean isNodeChild(AOTreeNode aOTreeNode) {
        boolean bl = aOTreeNode == null ? false : (this.getChildCount() == 0 ? false : aOTreeNode.getParent() == this);
        return bl;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public String toString() {
        if (this.userObject == null) {
            return "null";
        }
        return this.userObject.toString();
    }
}

