/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.signers.der.DerInputStream;
import es.gob.afirma.core.signers.der.DerOutputStream;
import es.gob.afirma.core.signers.der.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SignatureException;

public final class Pkcs1Utils {
    private Pkcs1Utils() {
    }

    public static byte[] encodeSignature(byte[] byArray) throws SignatureException {
        try {
            int n = byArray.length >> 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            BigInteger bigInteger = new BigInteger(1, byArray2);
            System.arraycopy(byArray, n, byArray2, 0, n);
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            DerOutputStream derOutputStream = new DerOutputStream(byArray.length + 10);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (Exception exception) {
            throw new SignatureException("Could not encode signature", exception);
        }
    }

    public static byte[] decodeSignature(byte[] byArray) throws SignatureException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray, 0, byArray.length, false);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            if (derValueArray.length != 2 || derInputStream.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            BigInteger bigInteger = derValueArray[0].getPositiveBigInteger();
            BigInteger bigInteger2 = derValueArray[1].getPositiveBigInteger();
            byte[] byArray2 = Pkcs1Utils.trimZeroes(bigInteger.toByteArray());
            byte[] byArray3 = Pkcs1Utils.trimZeroes(bigInteger2.toByteArray());
            int n = Math.max(byArray2.length, byArray3.length);
            byte[] byArray4 = new byte[n << 1];
            System.arraycopy(byArray2, 0, byArray4, n - byArray2.length, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
            return byArray4;
        }
        catch (Exception exception) {
            throw new SignatureException("Invalid encoding for signature", exception);
        }
    }

    private static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

