/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.LoggerUtil;
import es.gob.afirma.core.misc.http.SSLErrorProcessor;
import es.gob.afirma.core.misc.http.UrlHttpManager;
import es.gob.afirma.core.misc.http.UrlHttpManagerFactory;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.signers.TriphaseData;
import es.gob.afirma.core.util.tree.AOTreeModel;
import java.io.IOException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AOPkcs1TriPhaseSigner
implements AOSigner {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String PROPERTY_NAME_SIGN_SERVER_URL = "serverUrl";
    private static final String OPERATION_PRESIGN = "pre";
    private static final String OPERATION_POSTSIGN = "post";
    private static final String CRYPTO_OPERATION_SIGN = "sign";
    private static final String PARAMETER_NAME_OPERATION = "op";
    private static final String PARAMETER_NAME_CRYPTO_OPERATION = "cop";
    private static final String HTTP_CGI = "?";
    private static final String HTTP_EQUALS = "=";
    private static final String HTTP_AND = "&";
    private static final String PARAMETER_NAME_DOCID = "doc";
    private static final String PARAMETER_NAME_ALGORITHM = "algo";
    private static final String PARAMETER_NAME_FORMAT = "format";
    private static final String PARAMETER_NAME_CERT = "cert";
    private static final String PARAMETER_NAME_SESSION_DATA = "session";
    private static final String PROPERTY_NAME_PRESIGN = "PRE";
    private static final String PROPERTY_NAME_PKCS1_SIGN = "PK1";
    private static final String SUCCESS = "OK";
    private final String signFormat;

    protected AOPkcs1TriPhaseSigner(String string) {
        this.signFormat = string;
    }

    public AOPkcs1TriPhaseSigner() {
        this("NONE");
    }

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOPkcs1TriPhaseSigner.triPhaseOperation(this.signFormat, CRYPTO_OPERATION_SIGN, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public final byte[] getData(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public byte[] getData(byte[] byArray, Properties properties) throws AOInvalidFormatException {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No se soporta la multifirma de firmas NONE");
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No se soporta la multifirma de firmas NONE");
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No se soporta la multifirma de firmas NONE");
    }

    @Override
    public final AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, Properties properties, boolean bl) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public boolean isSign(byte[] byArray, Properties properties) {
        return this.isSign(byArray);
    }

    @Override
    public boolean isSign(byte[] byArray) {
        return false;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".p1";
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    protected static byte[] triPhaseOperation(String string, String string2, byte[] byArray, String string3, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        byte[] byArray2;
        CharSequence charSequence;
        byte[] byArray3;
        byte[] byArray4;
        Object object;
        Object object2;
        String string4;
        URL uRL;
        if (properties == null) {
            throw new IllegalArgumentException("Se necesitan parametros adicionales");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("Es necesario proporcionar la clave privada de firma");
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Es necesario proporcionar el certificado de firma");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("No se ha proporcionado el identificador de documento a firmar");
        }
        try {
            uRL = new URL(properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("No se ha proporcionado una URL valida para el servidor de firma: " + properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL), exception);
        }
        String string5 = Base64.encode(byArray, true);
        UrlHttpManager urlHttpManager = UrlHttpManagerFactory.getInstalledManager();
        try {
            string4 = Base64.encode(certificateArray[0].getEncoded(), true);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AOException("Error decodificando la cadena de certificados: " + certificateEncodingException, certificateEncodingException);
        }
        SSLErrorProcessor sSLErrorProcessor = new SSLErrorProcessor(properties);
        try {
            object2 = new StringBuffer();
            ((StringBuffer)object2).append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_PRESIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(string2).append(HTTP_AND).append(PARAMETER_NAME_FORMAT).append(HTTP_EQUALS).append(string).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string3).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(string4).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string5);
            object = ((StringBuffer)object2).toString();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Se llamara por POST a la siguiente URL:\n" + LoggerUtil.getTrimStr((String)object));
            }
            byArray4 = urlHttpManager.readUrl((String)object, UrlHttpMethod.POST, sSLErrorProcessor);
            ((StringBuffer)object2).setLength(0);
        }
        catch (IOException iOException) {
            if (sSLErrorProcessor.isCancelled()) {
                LOGGER.info("El usuario no permite la importacion del certificado SSL de confianza del servicio de firma trifasica: " + LoggerUtil.getTrimStr(uRL.toString()));
            }
            throw new AOException("Error en la llamada de prefirma al servidor: " + iOException, iOException);
        }
        try {
            object2 = TriphaseData.parser(Base64.decode(byArray4, 0, byArray4.length, true));
        }
        catch (Exception exception) {
            LOGGER.severe("Error al analizar la prefirma enviada por el servidor: " + exception);
            throw new AOException("Error al analizar la prefirma enviada por el servidor: " + exception, exception);
        }
        object = ((TriphaseData)object2).getSign(0);
        try {
            byArray3 = new AOPkcs1Signer().sign(Base64.decode(((TriphaseData.TriSign)object).getProperty(PROPERTY_NAME_PRESIGN)), string3, privateKey, certificateArray, properties);
        }
        catch (IOException iOException) {
            LOGGER.severe("Error al decodificar la prefirma de los datos: " + iOException);
            throw new AOException("Error al decodificar la prefirma de los datos", iOException);
        }
        ((TriphaseData.TriSign)object).addProperty(PROPERTY_NAME_PKCS1_SIGN, Base64.encode(byArray3));
        String string6 = Base64.encode(((TriphaseData)object2).toString().getBytes(), true);
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_POSTSIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(string2).append(HTTP_AND).append(PARAMETER_NAME_FORMAT).append(HTTP_EQUALS).append(string).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string3).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(string4).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string5).append(HTTP_AND).append(PARAMETER_NAME_SESSION_DATA).append(HTTP_EQUALS).append(string6);
            byArray2 = urlHttpManager.readUrl(((StringBuffer)charSequence).toString(), UrlHttpMethod.POST);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de postfirma al servidor: " + iOException, iOException);
        }
        charSequence = new String(byArray2).trim();
        if (!((String)charSequence).startsWith(SUCCESS)) {
            throw new AOException("La firma trifasica no ha finalizado correctamente: " + (String)charSequence);
        }
        try {
            return Base64.decode(((String)charSequence).substring("OK NEWID=".length()), true);
        }
        catch (IOException iOException) {
            LOGGER.warning("El resultado de NEWID del servidor no estaba en Base64: " + iOException);
            throw new AOException("El resultado devuelto por el servidor no es correcto: " + iOException, iOException);
        }
    }
}

