/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.keystores.AOCancelledSMOperationException;
import es.gob.afirma.core.keystores.AuthenticationException;
import es.gob.afirma.core.keystores.LockedKeyStoreException;
import es.gob.afirma.core.keystores.PinException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOPkcs1Signer
implements AOSigner {
    private static final String PKCS1_FILE_SUFFIX = ".p1";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Object object;
        block19: {
            String string2;
            Provider provider;
            Object object2;
            if (string == null) {
                throw new IllegalArgumentException("Es necesario indicar el algoritmo de firma, no puede ser nulo");
            }
            LOGGER.fine("Se ha solicitado una firma '" + string + "' con una clave de tipo " + privateKey.getAlgorithm());
            if (properties != null) {
                object2 = properties.getProperty("Provider." + privateKey.getClass().getName());
                provider = Security.getProvider((String)object2);
            } else {
                provider = null;
            }
            try {
                object = privateKey.getAlgorithm();
                string2 = AOSignConstants.composeSignatureAlgorithmName(string, (String)object);
                object2 = provider != null ? Signature.getInstance(string2, provider) : Signature.getInstance(string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AOException("No se soporta el algoritmo de firma (" + string + "): " + noSuchAlgorithmException, noSuchAlgorithmException);
            }
            try {
                ((Signature)object2).initSign(privateKey);
            }
            catch (Exception exception) {
                throw new AOException("Error al inicializar la firma con la clave privada para el algoritmo '" + string + "': " + exception, exception);
            }
            try {
                ((Signature)object2).update(byArray);
            }
            catch (Exception exception) {
                throw new AOException("Error al configurar los datos a firmar: " + exception, exception);
            }
            try {
                object = ((Signature)object2).sign();
            }
            catch (Exception exception) {
                if ("es.gob.jmulticard.CancelledOperationException".equals(exception.getClass().getName())) {
                    throw new AOCancelledSMOperationException("Cancelacion del dialogo de JMulticard");
                }
                if ("es.gob.jmulticard.jse.provider.SignatureAuthException".equals(exception.getClass().getName())) {
                    if ("es.gob.jmulticard.card.AuthenticationModeLockedException".equals(exception.getCause().getClass().getName())) {
                        throw new LockedKeyStoreException("El almacen de claves esta bloqueado", exception);
                    }
                    if ("es.gob.jmulticard.card.BadPinException".equals(exception.getCause().getClass().getName())) {
                        throw new PinException("La contrasena del almacen o certificado es incorrecta", exception);
                    }
                    throw new AuthenticationException("Ocurrio un error de autenticacion al utilizar la clave de firma", exception);
                }
                throw new AOException("Error durante el proceso de firma PKCS#1: " + exception, exception);
            }
            if (certificateArray != null && certificateArray.length > 0) {
                try {
                    Signature signature = Signature.getInstance(string2);
                    signature.initVerify(certificateArray[0].getPublicKey());
                    signature.update(byArray);
                    if (!signature.verify((byte[])object)) {
                        throw new AOException("El PKCS#1 de firma obtenido no se genero con el certificado indicado");
                    }
                    break block19;
                }
                catch (Exception exception) {
                    throw new AOException("Error al verificar el PKCS#1 de la firma", exception);
                }
            }
            LOGGER.warning("No se ha proporcionado el certificado para comprobar la integridad del PKCS#1");
        }
        return object;
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se soporta la multifirma de las firmas NONE");
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se soporta la multifirma de las firmas NONE");
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se soporta la multifirma de las firmas NONE");
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        throw new UnsupportedOperationException("No se puede obtener la estructura de firmantes en PKCS#1");
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, Properties properties, boolean bl) {
        throw new UnsupportedOperationException("No se puede obtener la estructura de firmantes en PKCS#1");
    }

    @Override
    public boolean isSign(byte[] byArray, Properties properties) {
        return this.isSign(byArray);
    }

    @Override
    public boolean isSign(byte[] byArray) {
        return false;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        return byArray != null && byArray.length > 0;
    }

    @Override
    public String getSignedName(String string, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2 : "";
        if (string == null) {
            return "signature.p1";
        }
        if (string.toLowerCase(Locale.US).endsWith(PKCS1_FILE_SUFFIX)) {
            return string.substring(0, string.length() - PKCS1_FILE_SUFFIX.length()) + string3 + PKCS1_FILE_SUFFIX;
        }
        return string + string3 + PKCS1_FILE_SUFFIX;
    }

    @Override
    public byte[] getData(byte[] byArray) {
        throw new UnsupportedOperationException("No se pueden obtener los datos firmados en PKCS#1");
    }

    @Override
    public byte[] getData(byte[] byArray, Properties properties) {
        throw new UnsupportedOperationException("No se pueden obtener los datos firmados en PKCS#1");
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) {
        throw new UnsupportedOperationException("No se puede obtener informacion de las firmas PKCS#1");
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No se puede obtener informacion de las firmas PKCS#1");
    }
}

