/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.ParameterLocalAccessRequestedException;
import es.gob.afirma.core.misc.protocol.ProtocolVersion;
import es.gob.afirma.core.misc.protocol.UrlParameters;
import es.gob.afirma.core.signers.ExtraParamsProcessor;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class UrlParametersToSign
extends UrlParameters {
    private static final String FORMAT_PARAM = "format";
    private static final String ALGORITHM_PARAM = "algorithm";
    private static final String ID_PARAM = "id";
    private static final String VER_PARAM = "ver";
    private static final String STICKY_PARAM = "sticky";
    private static final String RESET_STICKY_PARAM = "resetsticky";
    private static final String[] KNOWN_PARAMETERS = new String[]{"format", "algorithm", "id", "ver", "sticky", "resetsticky", "properties", "dat", "gzip", "rtservlet", "stservlet", "key", "fileid", "keystore", "ksb64", "aw", "mcv", "appname"};
    private static final Set<String> SUPPORTED_SIGNATURE_ALGORITHMS = new HashSet<String>();
    private String operation;
    private String signFormat;
    private String signAlgorithm;
    private final boolean servicesRequired;
    private String minimumProtocolVersion;
    private boolean sticky;
    private boolean resetSticky;
    private String appName;
    private final Map<String, String> anotherParams = new HashMap<String, String>();

    public UrlParametersToSign() {
        this(false);
    }

    public UrlParametersToSign(boolean bl) {
        this.servicesRequired = bl;
        this.setData(null);
        this.setFileId(null);
        this.setRetrieveServletUrl(null);
    }

    public String getMinimumProtocolVersion() {
        return this.minimumProtocolVersion;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getSignatureFormat() {
        return this.signFormat;
    }

    public String getSignatureAlgorithm() {
        return this.signAlgorithm;
    }

    void setOperation(String string) {
        this.operation = string;
    }

    public void setSignFormat(String string) {
        this.signFormat = string;
    }

    void setSignAlgorithm(String string) {
        this.signAlgorithm = string;
    }

    void setMinimumProtocolVersion(String string) {
        this.minimumProtocolVersion = string;
    }

    public boolean getSticky() {
        return this.sticky;
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public void setResetSticky(boolean bl) {
        this.resetSticky = bl;
    }

    public boolean getResetSticky() {
        return this.resetSticky;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setSignParameters(Map<String, String> map) throws ParameterException {
        String string = null;
        if (map.containsKey(ID_PARAM)) {
            string = map.get(ID_PARAM);
        } else if (map.containsKey("fileid")) {
            string = map.get("fileid");
        }
        if (string != null) {
            if (string.length() > 20) {
                throw new ParameterException("La longitud del identificador de la operacion es mayor de 20 caracteres.");
            }
            for (char string4 : string.toLowerCase(Locale.ENGLISH).toCharArray()) {
                if (string4 >= 'a' && string4 <= 'z' || string4 >= '0' && string4 <= '9') continue;
                throw new ParameterException("El identificador de la firma debe ser alfanumerico.");
            }
            this.setSessionId(string);
        }
        if (map.containsKey(VER_PARAM)) {
            this.setMinimumProtocolVersion(map.get(VER_PARAM));
        } else {
            this.setMinimumProtocolVersion(Integer.toString(ProtocolVersion.VERSION_0.getVersion()));
        }
        if (map.containsKey("appname")) {
            this.appName = map.get("appname");
        }
        String string2 = map.get("op");
        this.setOperation(string2);
        if (this.getFileId() != null) {
            return;
        }
        if (this.servicesRequired) {
            if (map.containsKey("stservlet")) {
                URL string22;
                try {
                    string22 = UrlParametersToSign.validateURL(map.get("stservlet"));
                }
                catch (ParameterLocalAccessRequestedException parameterException) {
                    throw new ParameterLocalAccessRequestedException("La URL del servicio de guardado no puede ser local", parameterException);
                }
                catch (ParameterException string3) {
                    throw new ParameterException("Error al validar la URL del servicio de guardado: " + string3, string3);
                }
                this.setStorageServletUrl(string22);
            } else if (map.containsKey(ID_PARAM)) {
                throw new ParameterException("No se ha recibido la direccion del servlet para el guardado del resultado de la operacion");
            }
        }
        if (!map.containsKey(FORMAT_PARAM)) {
            throw new ParameterException("No se ha recibido el formato de firma");
        }
        String string3 = map.get(FORMAT_PARAM);
        this.setSignFormat(string3);
        if (!map.containsKey(ALGORITHM_PARAM)) {
            throw new ParameterException("No se ha recibido el algoritmo de firma");
        }
        String string4 = map.get(ALGORITHM_PARAM);
        if (!SUPPORTED_SIGNATURE_ALGORITHMS.contains(string4)) {
            throw new ParameterException("Algoritmo de firma no soportado: " + string4);
        }
        this.setSignAlgorithm(string4);
        String string5 = null;
        if (map.containsKey("properties")) {
            string5 = map.get("properties");
        }
        if (string5 != null && !string5.isEmpty()) {
            try {
                this.setExtraParams(AOUtil.base642Properties(string5));
            }
            catch (Exception exception) {
                LOGGER.severe("Las propiedades adicionales indicadas en el parametro 'properties' no se han podido cargar: " + exception);
                this.setExtraParams(new Properties());
            }
        } else {
            this.setExtraParams(new Properties());
        }
        if (map.containsKey(STICKY_PARAM)) {
            this.setSticky(Boolean.parseBoolean(map.get(STICKY_PARAM)));
        } else {
            this.setSticky(false);
        }
        if (map.containsKey(RESET_STICKY_PARAM)) {
            this.setResetSticky(Boolean.parseBoolean(map.get(RESET_STICKY_PARAM)));
        } else {
            this.setResetSticky(false);
        }
        this.setDefaultKeyStore(UrlParametersToSign.getKeyStoreName(map));
        this.setDefaultKeyStoreLib(UrlParametersToSign.getDefaultKeyStoreLib(map));
    }

    public void expandExtraParams() throws ExtraParamsProcessor.IncompatiblePolicyException {
        this.setExtraParams(ExtraParamsProcessor.expandProperties(this.getExtraParams(), this.data, this.getSignatureFormat()));
    }

    public Map<String, String> getAnotherParams() {
        return this.anotherParams;
    }

    public void setAnotherParams(Map<String, String> map) {
        for (String string : map.keySet().toArray(new String[0])) {
            if (UrlParametersToSign.contains(KNOWN_PARAMETERS, string)) continue;
            this.anotherParams.put(string, map.get(string));
        }
    }

    private static boolean contains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    static {
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA1");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA256");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA384");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA512");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA1withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA256withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA384withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA512withRSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA1withECDSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA256withECDSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA384withECDSA");
        SUPPORTED_SIGNATURE_ALGORITHMS.add("SHA512withECDSA");
    }
}

