/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.ParameterLocalAccessRequestedException;
import es.gob.afirma.core.misc.protocol.ProtocolVersion;
import es.gob.afirma.core.misc.protocol.UrlParameters;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class UrlParametersToSelectCert
extends UrlParameters {
    private static final String ID_PARAM = "id";
    private static final String VER_PARAM = "ver";
    private static final String STICKY_PARAM = "sticky";
    private static final String RESET_STICKY_PARAM = "resetsticky";
    private final boolean servicesRequired;
    private String minimumVerstion;
    private boolean sticky;
    private boolean resetSticky;

    public UrlParametersToSelectCert() {
        this(false);
    }

    public UrlParametersToSelectCert(boolean bl) {
        this.servicesRequired = bl;
        this.setData(null);
        this.setFileId(null);
        this.setRetrieveServletUrl(null);
    }

    public String getMinimumProtocolVersion() {
        return this.minimumVerstion;
    }

    void setMinimumProtocolVersion(String string) {
        this.minimumVerstion = string;
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public boolean getSticky() {
        return this.sticky;
    }

    public void setResetSticky(boolean bl) {
        this.resetSticky = bl;
    }

    public boolean getResetSticky() {
        return this.resetSticky;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelectCertParameters(Map<String, String> map) throws ParameterException {
        void var3_8;
        String string = null;
        if (map.containsKey(ID_PARAM)) {
            string = map.get(ID_PARAM);
        } else if (map.containsKey("fileid")) {
            string = map.get("fileid");
        }
        if (string != null) {
            if (string.length() > 20) {
                throw new ParameterException("La longitud del identificador de la operacion es mayor de 20 caracteres.");
            }
            for (char c : string.toLowerCase(Locale.ENGLISH).toCharArray()) {
                if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
                throw new ParameterException("El identificador de la sesion debe ser alfanumerico.");
            }
            this.setSessionId(string);
        }
        if (map.containsKey(VER_PARAM)) {
            this.setMinimumProtocolVersion(map.get(VER_PARAM));
        } else {
            this.setMinimumProtocolVersion(Integer.toString(ProtocolVersion.VERSION_0.getVersion()));
        }
        if (this.getFileId() != null) {
            return;
        }
        if (this.servicesRequired) {
            if (map.containsKey("stservlet")) {
                URL uRL;
                try {
                    uRL = UrlParametersToSelectCert.validateURL(map.get("stservlet"));
                }
                catch (ParameterLocalAccessRequestedException parameterLocalAccessRequestedException) {
                    throw new ParameterLocalAccessRequestedException("La URL del servicio de guardado no puede ser local", parameterLocalAccessRequestedException);
                }
                catch (ParameterException parameterException) {
                    throw new ParameterException("Error al validar la URL del servicio de guardado: " + parameterException, parameterException);
                }
                this.setStorageServletUrl(uRL);
            } else if (map.containsKey(ID_PARAM)) {
                throw new ParameterException("No se ha recibido la direccion del servlet para el guardado del resultado de la operacion");
            }
        }
        Object var3_6 = null;
        if (map.containsKey("properties")) {
            String string2 = map.get("properties");
        }
        if (var3_8 != null && !var3_8.isEmpty()) {
            try {
                this.setExtraParams(AOUtil.base642Properties((String)var3_8));
            }
            catch (Exception exception) {
                LOGGER.severe("Las propiedades adicionales indicadas en el parametro 'properties' no se han podido cargar: " + exception);
                this.setExtraParams(new Properties());
            }
        } else {
            this.setExtraParams(new Properties());
        }
        if (map.containsKey(STICKY_PARAM)) {
            this.setSticky(Boolean.parseBoolean(map.get(STICKY_PARAM)));
        } else {
            this.setSticky(false);
        }
        if (map.containsKey(RESET_STICKY_PARAM)) {
            this.setResetSticky(Boolean.parseBoolean(map.get(RESET_STICKY_PARAM)));
        } else {
            this.setResetSticky(false);
        }
        this.setDefaultKeyStore(UrlParametersToSelectCert.getKeyStoreName(map));
        this.setDefaultKeyStoreLib(UrlParametersToSelectCert.getDefaultKeyStoreLib(map));
    }
}

