/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.ParameterLocalAccessRequestedException;
import es.gob.afirma.core.misc.protocol.ProtocolVersion;
import es.gob.afirma.core.misc.protocol.UrlParameters;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class UrlParametersForBatch
extends UrlParameters {
    private static final String ID_PARAM = "id";
    private static final String PARAM_BATCH_POSTSIGNER = "batchpostsignerurl";
    private static final String PARAM_BATCH_PRESIGNER = "batchpresignerurl";
    private static final String PARAM_VER = "ver";
    private static final String PARAM_STICKY = "sticky";
    private static final String RESET_STICKY_PARAM = "resetsticky";
    private static final String PARAM_NEED_CERT = "needcert";
    private static final String PARAM_JSON_BATCH = "jsonbatch";
    private static final String PARAM_LOCAL_BATCH_PROCESS = "localBatchProcess";
    private String batchPreSignerUrl = null;
    private String batchPostSignerUrl = null;
    private final boolean servicesRequired;
    private String minimumProtocolVersion;
    private boolean sticky;
    private boolean resetSticky;
    private boolean certNeeded;
    private boolean jsonBatch;
    private boolean localBatchProcess;
    private String appName;

    public UrlParametersForBatch() {
        this(false);
    }

    public UrlParametersForBatch(boolean bl) {
        this.servicesRequired = bl;
    }

    public boolean isJsonBatch() {
        return this.jsonBatch;
    }

    public void setJsonBatch(boolean bl) {
        this.jsonBatch = bl;
    }

    public boolean isLocalBatchProcess() {
        return this.localBatchProcess;
    }

    public void setLocalBatchProcess(boolean bl) {
        this.localBatchProcess = bl;
    }

    public String getBatchPresignerUrl() {
        return this.batchPreSignerUrl;
    }

    void setBatchPresignerUrl(String string) {
        this.batchPreSignerUrl = string;
    }

    public void setSticky(boolean bl) {
        this.sticky = bl;
    }

    public boolean getSticky() {
        return this.sticky;
    }

    public void setResetSticky(boolean bl) {
        this.resetSticky = bl;
    }

    public boolean getResetSticky() {
        return this.resetSticky;
    }

    public boolean isCertNeeded() {
        return this.certNeeded;
    }

    public void setCertNeeded(boolean bl) {
        this.certNeeded = bl;
    }

    public String getBatchPostSignerUrl() {
        return this.batchPostSignerUrl;
    }

    void setBatchPostsignerUrl(String string) {
        this.batchPostSignerUrl = string;
    }

    public String getAppName() {
        return this.appName;
    }

    void setAppName(String string) {
        this.appName = string;
    }

    public void setBatchParameters(Map<String, String> map) throws ParameterException {
        Object object;
        if (map.containsKey(ID_PARAM) || map.containsKey("fileid")) {
            Object object2 = object = map.containsKey(ID_PARAM) ? map.get(ID_PARAM) : map.get("fileid");
            if (((String)object).length() > 20) {
                throw new ParameterException("La longitud del identificador de la operacion es mayor de 20 caracteres.");
            }
            for (char c : ((String)object).toLowerCase(Locale.ENGLISH).toCharArray()) {
                if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
                throw new ParameterException("El identificador de la firma debe ser alfanumerico.");
            }
            this.setSessionId((String)object);
        }
        if (map.containsKey(PARAM_VER)) {
            this.setMinimumProtocolVersion(map.get(PARAM_VER));
        } else {
            this.setMinimumProtocolVersion(Integer.toString(ProtocolVersion.VERSION_0.getVersion()));
        }
        if (map.containsKey("appname")) {
            this.appName = map.get("appname");
        }
        if (this.getFileId() != null) {
            return;
        }
        if (map.containsKey(PARAM_LOCAL_BATCH_PROCESS)) {
            this.setLocalBatchProcess(Boolean.parseBoolean(map.get(PARAM_LOCAL_BATCH_PROCESS)));
        }
        if (!this.isLocalBatchProcess()) {
            if (!map.containsKey(PARAM_BATCH_POSTSIGNER)) {
                throw new ParameterException("No se ha recibido la URL del postprocesador de lotes");
            }
            if (!map.containsKey(PARAM_BATCH_PRESIGNER)) {
                throw new ParameterException("No se ha recibido la URL del preprocesador de lotes");
            }
            this.setBatchPostsignerUrl(UrlParametersForBatch.validateURL(map.get(PARAM_BATCH_POSTSIGNER)).toString());
            this.setBatchPresignerUrl(UrlParametersForBatch.validateURL(map.get(PARAM_BATCH_PRESIGNER)).toString());
        }
        if (this.servicesRequired) {
            if (map.containsKey("stservlet")) {
                try {
                    object = UrlParametersForBatch.validateURL(map.get("stservlet"));
                }
                catch (ParameterLocalAccessRequestedException parameterLocalAccessRequestedException) {
                    throw new ParameterLocalAccessRequestedException("La URL del servicio de guardado no puede ser local", parameterLocalAccessRequestedException);
                }
                catch (ParameterException parameterException) {
                    throw new ParameterException("Error al validar la URL del servicio de guardado: " + parameterException, parameterException);
                }
                this.setStorageServletUrl((URL)object);
            } else if (map.containsKey(ID_PARAM)) {
                throw new ParameterException("No se ha recibido la direccion del servlet para el guardado del resultado de la operacion");
            }
        }
        object = null;
        if (map.containsKey("properties")) {
            object = map.get("properties");
        }
        if (object != null && !((String)object).isEmpty()) {
            try {
                this.setExtraParams(AOUtil.base642Properties((String)object));
            }
            catch (Exception exception) {
                LOGGER.severe("Las propiedades adicionales indicadas en el parametro 'properties' no se han podido cargar: " + exception);
                this.setExtraParams(new Properties());
            }
        } else {
            this.setExtraParams(new Properties());
        }
        if (map.containsKey(PARAM_STICKY)) {
            this.setSticky(Boolean.parseBoolean(map.get(PARAM_STICKY)));
        } else {
            this.setSticky(false);
        }
        if (map.containsKey(RESET_STICKY_PARAM)) {
            this.setResetSticky(Boolean.parseBoolean(map.get(RESET_STICKY_PARAM)));
        } else {
            this.setResetSticky(false);
        }
        if (map.containsKey(PARAM_NEED_CERT)) {
            this.setCertNeeded(Boolean.parseBoolean(map.get(PARAM_NEED_CERT)));
        } else {
            this.setCertNeeded(false);
        }
        if (map.containsKey(PARAM_JSON_BATCH)) {
            this.setJsonBatch(Boolean.parseBoolean(map.get(PARAM_JSON_BATCH)));
        }
        this.setDefaultKeyStore(UrlParametersForBatch.getKeyStoreName(map));
        this.setDefaultKeyStoreLib(UrlParametersForBatch.getDefaultKeyStoreLib(map));
    }

    public String getMinimumProtocolVersion() {
        return this.minimumProtocolVersion;
    }

    void setMinimumProtocolVersion(String string) {
        this.minimumProtocolVersion = string;
    }
}

