/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.http.DataDownloader;
import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.ParameterLocalAccessRequestedException;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UrlParameters {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    protected static final String PROPERTIES_PARAM = "properties";
    protected static final String DATA_PARAM = "dat";
    protected static final String GZIPPED_DATA_PARAM = "gzip";
    protected static final String RETRIEVE_SERVLET_PARAM = "rtservlet";
    protected static final String STORAGE_SERVLET_PARAM = "stservlet";
    protected static final int MAX_ID_LENGTH = 20;
    private static final int CIPHER_KEY_LENGTH = 8;
    protected static final String KEY_PARAM = "key";
    protected static final String FILE_ID_PARAM = "fileid";
    protected static final String KEYSTORE_OLD_PARAM = "keystore";
    protected static final String KEYSTORE_PARAM = "ksb64";
    protected static final String ACTIVE_WAITING_PARAM = "aw";
    protected static final String MINIMUM_CLIENT_VERSION_PARAM = "mcv";
    protected static final String APP_NAME_PARAM = "appname";
    private static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    protected byte[] data = null;
    private String fileId = null;
    private byte[] desKey = null;
    private URL retrieveServletUrl = null;
    private URL storageServerUrl = null;
    private String id = null;
    private String minimumClientVersion = null;
    private boolean activeWaiting = false;
    private String defaultKeyStore = null;
    private String defaultKeyStoreLib = null;
    private Properties extraParams = null;
    private String filename = null;

    public Properties getExtraParams() {
        if (this.extraParams == null) {
            this.extraParams = new Properties();
        }
        return this.extraParams;
    }

    void setExtraParams(Properties properties) {
        this.extraParams = properties != null ? properties : new Properties();
    }

    public String getFileName() {
        return this.filename;
    }

    void setFilename(String string) {
        this.filename = string;
    }

    public String getDefaultKeyStore() {
        return this.defaultKeyStore;
    }

    void setDefaultKeyStore(String string) {
        this.defaultKeyStore = string;
    }

    public String getDefaultKeyStoreLib() {
        return this.defaultKeyStoreLib;
    }

    void setDefaultKeyStoreLib(String string) {
        this.defaultKeyStoreLib = string;
    }

    public void setData(byte[] byArray) {
        this.data = byArray != null ? Arrays.copyOf(byArray, byArray.length) : null;
    }

    void setFileId(String string) {
        this.fileId = string;
    }

    private void setDesKey(byte[] byArray) {
        this.desKey = byArray != null ? Arrays.copyOf(byArray, byArray.length) : null;
    }

    void setRetrieveServletUrl(URL uRL) {
        this.retrieveServletUrl = uRL;
    }

    public byte[] getData() {
        return this.data != null ? Arrays.copyOf(this.data, this.data.length) : null;
    }

    public String getFileId() {
        return this.fileId;
    }

    public byte[] getDesKey() {
        return this.desKey != null ? Arrays.copyOf(this.desKey, this.desKey.length) : null;
    }

    public URL getRetrieveServletUrl() {
        return this.retrieveServletUrl;
    }

    public URL getStorageServletUrl() {
        return this.storageServerUrl;
    }

    protected void setStorageServletUrl(URL uRL) {
        this.storageServerUrl = uRL;
    }

    public boolean isActiveWaiting() {
        return this.activeWaiting;
    }

    protected void setActiveWaiting(boolean bl) {
        this.activeWaiting = bl;
    }

    public String getMinimumClientVersion() {
        return this.minimumClientVersion;
    }

    protected void setMinimumClientVersion(String string) {
        this.minimumClientVersion = string;
    }

    public String getId() {
        return this.id;
    }

    void setSessionId(String string) {
        this.id = string;
    }

    void setCommonParameters(Map<String, String> map) throws ParameterException {
        this.setDesKey(UrlParameters.verifyCipherKey(map));
        this.setActiveWaiting(map.containsKey(ACTIVE_WAITING_PARAM) && Boolean.parseBoolean(map.get(ACTIVE_WAITING_PARAM)));
        if (map.containsKey(MINIMUM_CLIENT_VERSION_PARAM)) {
            this.setMinimumClientVersion(map.get(MINIMUM_CLIENT_VERSION_PARAM));
        }
        if (!map.containsKey(DATA_PARAM)) {
            if (map.containsKey(FILE_ID_PARAM)) {
                this.setFileId(map.get(FILE_ID_PARAM));
                if (!map.containsKey(RETRIEVE_SERVLET_PARAM)) {
                    throw new ParameterException("No se ha recibido la direccion del servlet para la recuperacion de los datos a firmar");
                }
                try {
                    this.setRetrieveServletUrl(UrlParameters.validateURL(map.get(RETRIEVE_SERVLET_PARAM)));
                }
                catch (ParameterLocalAccessRequestedException parameterLocalAccessRequestedException) {
                    throw new ParameterLocalAccessRequestedException("La URL del servicio de recuperacion de datos no puede ser local", parameterLocalAccessRequestedException);
                }
                catch (ParameterException parameterException) {
                    throw new ParameterException("Error al validar la URL del servlet de recuperacion: " + parameterException, parameterException);
                }
            }
        } else {
            String string = map.get(DATA_PARAM);
            if (string.startsWith("file:/")) {
                throw new ParameterException("No se permite la lectura de ficheros locales: " + string);
            }
            try {
                this.setData(DataDownloader.downloadData(string, Boolean.parseBoolean(map.get(GZIPPED_DATA_PARAM))));
            }
            catch (Exception exception) {
                throw new ParameterException("No se han podido obtener los datos: " + exception, exception);
            }
        }
    }

    private static byte[] verifyCipherKey(Map<String, String> map) throws ParameterException {
        if (!map.containsKey(KEY_PARAM)) {
            return null;
        }
        String string = map.get(KEY_PARAM);
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() != 8) {
            throw new ParameterException("La longitud de la clave de cifrado no es correcta");
        }
        return string.getBytes();
    }

    protected static URL validateURL(String string) throws ParameterException {
        URL uRL;
        try {
            uRL = new URL(URLDecoder.decode(string, DEFAULT_ENCODING));
        }
        catch (Exception exception) {
            throw new ParameterException("La URL proporcionada para el servlet no es valida (" + string + "): " + exception);
        }
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            throw new ParameterException("El protocolo de la URL proporcionada para el servlet no esta soportado: " + uRL.getProtocol());
        }
        if ("localhost".equals(uRL.getHost()) || "127.0.0.1".equals(uRL.getHost())) {
            throw new ParameterLocalAccessRequestedException("El host de la URL proporcionada para el Servlet es local");
        }
        if (uRL.toString().indexOf(63) != -1 || uRL.toString().indexOf(61) != -1) {
            throw new ParameterException("Se han encontrado parametros en la URL del servlet");
        }
        return uRL;
    }

    protected static String getKeyStoreName(Map<String, String> map) {
        String string = null;
        if (map.get(KEYSTORE_OLD_PARAM) != null) {
            string = map.get(KEYSTORE_OLD_PARAM);
        } else if (map.get(KEYSTORE_PARAM) != null) {
            try {
                string = new String(Base64.decode(map.get(KEYSTORE_PARAM)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string != null) {
            int n = string.indexOf(58);
            if (n == -1) {
                return string;
            }
            if (string.length() > 1) {
                return string.substring(0, n).trim();
            }
            LOGGER.info("El almacen indicado no es valido ('" + string + "'), se usara el por defecto del sistema operativo");
        }
        return null;
    }

    protected static String getDefaultKeyStoreLib(Map<String, String> map) {
        String string = null;
        if (map.get(KEYSTORE_OLD_PARAM) != null) {
            string = map.get(KEYSTORE_OLD_PARAM);
        } else if (map.get(KEYSTORE_PARAM) != null) {
            try {
                string = new String(Base64.decode(map.get(KEYSTORE_PARAM)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n != -1 && n < string.length() - 1) {
            return UrlParameters.cleanupPath(string.substring(n + 1));
        }
        return null;
    }

    private static String cleanupPath(String string) {
        String string2 = string.trim().replace("\"", "").replace("'", "");
        try {
            string2 = new File(string2).getCanonicalPath();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Ruta de fichero no valida", exception);
            string2 = null;
        }
        return string2;
    }
}

