/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.SecureXmlBuilder;
import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.UrlParametersForBatch;
import es.gob.afirma.core.misc.protocol.UrlParametersToLoad;
import es.gob.afirma.core.misc.protocol.UrlParametersToSave;
import es.gob.afirma.core.misc.protocol.UrlParametersToSelectCert;
import es.gob.afirma.core.misc.protocol.UrlParametersToSign;
import es.gob.afirma.core.misc.protocol.UrlParametersToSignAndSave;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ProtocolInvocationUriParserUtil {
    static final String DEFAULT_URL_ENCODING = StandardCharsets.UTF_8.name();
    private static final String DEFAULT_OPERATION = "SIGN";

    private ProtocolInvocationUriParserUtil() {
    }

    public static UrlParametersToSave getParametersToSave(Map<String, String> map, boolean bl) throws ParameterException {
        UrlParametersToSave urlParametersToSave = new UrlParametersToSave(bl);
        urlParametersToSave.setCommonParameters(map);
        urlParametersToSave.setSaveParameters(map);
        return urlParametersToSave;
    }

    public static UrlParametersForBatch getParametersToBatch(Map<String, String> map, boolean bl) throws ParameterException {
        UrlParametersForBatch urlParametersForBatch = new UrlParametersForBatch(bl);
        urlParametersForBatch.setCommonParameters(map);
        urlParametersForBatch.setBatchParameters(map);
        return urlParametersForBatch;
    }

    public static UrlParametersToLoad getParametersToLoad(Map<String, String> map) throws ParameterException {
        UrlParametersToLoad urlParametersToLoad = new UrlParametersToLoad();
        urlParametersToLoad.setCommonParameters(map);
        urlParametersToLoad.setLoadParameters(map);
        return urlParametersToLoad;
    }

    public static Map<String, String> parseXml(byte[] byArray) throws ParameterException {
        NodeList nodeList;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Element element = SecureXmlBuilder.getSecureDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
            hashMap.put("op", "op".equalsIgnoreCase(element.getNodeName()) ? DEFAULT_OPERATION : element.getNodeName());
            nodeList = element.getChildNodes();
        }
        catch (Exception exception) {
            throw new ParameterException("Error grave durante el analisis del XML: " + exception, exception);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"e".equals(node.getNodeName())) {
                throw new ParameterException("El XML no tiene la forma esperada");
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("k");
            Node node3 = namedNodeMap.getNamedItem("v");
            if (node2 == null || node3 == null) {
                throw new ParameterException("El XML no tiene la forma esperada");
            }
            try {
                hashMap.put(node2.getNodeValue(), URLDecoder.decode(node3.getNodeValue(), DEFAULT_URL_ENCODING));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger("es.gob.afirma").warning("Codificacion no soportada para la URL (" + DEFAULT_URL_ENCODING + "): " + unsupportedEncodingException);
                hashMap.put(node2.getNodeValue(), node3.getNodeValue());
            }
        }
        return hashMap;
    }

    public static UrlParametersToSign getParametersToSign(Map<String, String> map, boolean bl) throws ParameterException {
        UrlParametersToSign urlParametersToSign = new UrlParametersToSign(bl);
        urlParametersToSign.setCommonParameters(map);
        urlParametersToSign.setSignParameters(map);
        urlParametersToSign.setAnotherParams(map);
        return urlParametersToSign;
    }

    public static UrlParametersToSignAndSave getParametersToSignAndSave(Map<String, String> map, boolean bl) throws ParameterException {
        UrlParametersToSignAndSave urlParametersToSignAndSave = new UrlParametersToSignAndSave(bl);
        urlParametersToSignAndSave.setCommonParameters(map);
        urlParametersToSignAndSave.setSignAndSaveParameters(map);
        return urlParametersToSignAndSave;
    }

    public static UrlParametersToSelectCert getParametersToSelectCert(Map<String, String> map, boolean bl) throws ParameterException {
        UrlParametersToSelectCert urlParametersToSelectCert = new UrlParametersToSelectCert(bl);
        urlParametersToSelectCert.setCommonParameters(map);
        urlParametersToSelectCert.setSelectCertParameters(map);
        return urlParametersToSelectCert;
    }
}

