/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.ProtocolInvocationUriParserUtil;
import es.gob.afirma.core.misc.protocol.UrlParametersForBatch;
import es.gob.afirma.core.misc.protocol.UrlParametersToLoad;
import es.gob.afirma.core.misc.protocol.UrlParametersToSave;
import es.gob.afirma.core.misc.protocol.UrlParametersToSelectCert;
import es.gob.afirma.core.misc.protocol.UrlParametersToSign;
import es.gob.afirma.core.misc.protocol.UrlParametersToSignAndSave;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class ProtocolInvocationUriParser {
    private ProtocolInvocationUriParser() {
    }

    public static UrlParametersToSign getParametersToSign(String string) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToSign(string, false);
    }

    public static UrlParametersToSign getParametersToSign(String string, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSign(ProtocolInvocationUriParser.parserUri(string), bl);
    }

    public static UrlParametersToSign getParametersToSign(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToSign(byArray, false);
    }

    public static UrlParametersToSign getParametersToSign(byte[] byArray, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSign(ProtocolInvocationUriParserUtil.parseXml(byArray), bl);
    }

    public static UrlParametersToSignAndSave getParametersToSignAndSave(String string) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToSignAndSave(string, false);
    }

    public static UrlParametersToSignAndSave getParametersToSignAndSave(String string, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSignAndSave(ProtocolInvocationUriParser.parserUri(string), bl);
    }

    public static UrlParametersToSignAndSave getParametersToSignAndSave(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToSignAndSave(byArray, false);
    }

    public static UrlParametersToSignAndSave getParametersToSignAndSave(byte[] byArray, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSignAndSave(ProtocolInvocationUriParserUtil.parseXml(byArray), bl);
    }

    public static UrlParametersToSelectCert getParametersToSelectCert(String string) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToSelectCert(string, false);
    }

    public static UrlParametersToSelectCert getParametersToSelectCert(String string, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSelectCert(ProtocolInvocationUriParser.parserUri(string), bl);
    }

    public static UrlParametersToSelectCert getParametersToSelectCert(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToSelectCert(byArray, false);
    }

    public static UrlParametersToSelectCert getParametersToSelectCert(byte[] byArray, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSelectCert(ProtocolInvocationUriParserUtil.parseXml(byArray), bl);
    }

    public static UrlParametersToSave getParametersToSave(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToSave(byArray, false);
    }

    public static UrlParametersToSave getParametersToSave(byte[] byArray, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSave(ProtocolInvocationUriParserUtil.parseXml(byArray), bl);
    }

    public static UrlParametersToSave getParametersToSave(String string) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToSave(string, false);
    }

    public static UrlParametersToSave getParametersToSave(String string, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToSave(ProtocolInvocationUriParser.parserUri(string), bl);
    }

    public static UrlParametersForBatch getParametersToBatch(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToBatch(byArray, false);
    }

    public static UrlParametersForBatch getParametersToBatch(byte[] byArray, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToBatch(ProtocolInvocationUriParserUtil.parseXml(byArray), bl);
    }

    public static UrlParametersForBatch getParametersToBatch(String string) throws ParameterException {
        return ProtocolInvocationUriParser.getParametersToBatch(string, false);
    }

    public static UrlParametersForBatch getParametersToBatch(String string, boolean bl) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToBatch(ProtocolInvocationUriParser.parserUri(string), bl);
    }

    public static UrlParametersToLoad getParametersToLoad(String string) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToLoad(ProtocolInvocationUriParser.parserUri(string));
    }

    public static UrlParametersToLoad getParametersToLoad(byte[] byArray) throws ParameterException {
        return ProtocolInvocationUriParserUtil.getParametersToLoad(ProtocolInvocationUriParserUtil.parseXml(byArray));
    }

    private static Map<String, String> parserUri(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.substring(string.indexOf(63) + 1).split("&");
        for (String string2 : stringArray) {
            int n = string2.indexOf(61);
            if (n <= 0) continue;
            try {
                hashMap.put(string2.substring(0, n), n == string2.length() - 1 ? "" : URLDecoder.decode(string2.substring(n + 1), ProtocolInvocationUriParserUtil.DEFAULT_URL_ENCODING));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                hashMap.put(string2.substring(0, n), n == string2.length() - 1 ? "" : string2.substring(n + 1));
            }
        }
        Logger.getLogger("es.gob.afirma").info("URI recibida: " + (string.length() <= 300 ? string : string.substring(0, 300) + "..."));
        Object object = string.substring(string.indexOf("://") + "://".length(), string.indexOf(63) != -1 ? string.indexOf(63) : string.length());
        if (((String)object).endsWith("/")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        hashMap.put("op", (String)(((String)object).indexOf("/") == -1 ? object : ((String)object).substring(0, ((String)object).indexOf("/"))));
        return hashMap;
    }
}

