/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.http;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.misc.http.HttpError;
import es.gob.afirma.core.misc.http.HttpErrorProcessor;
import es.gob.afirma.core.misc.http.SSLConfig;
import es.gob.afirma.core.misc.http.SslSecurityManager;
import es.gob.afirma.core.misc.http.URLName;
import es.gob.afirma.core.misc.http.UrlHttpManager;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;

public class UrlHttpManagerImpl
implements UrlHttpManager {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String JAVA_PARAM_DISABLE_SSL_CHECKS = "disableSslChecks";
    public static final String JAVA_PARAM_SECURE_DOMAINS_LIST = "secureDomainsList";
    public static final int DEFAULT_TIMEOUT = -1;
    private static final String URN_SEPARATOR = ":";
    private static final String PROT_SEPARATOR = "://";
    private static final String ACCEPT = "Accept";

    protected UrlHttpManagerImpl() {
    }

    @Override
    public byte[] readUrl(String string, UrlHttpMethod urlHttpMethod) throws IOException {
        return this.readUrl(string, -1, null, null, urlHttpMethod);
    }

    @Override
    public byte[] readUrl(String string, UrlHttpMethod urlHttpMethod, HttpErrorProcessor httpErrorProcessor) throws IOException {
        return this.readUrl(string, -1, null, null, urlHttpMethod, httpErrorProcessor);
    }

    @Override
    public byte[] readUrl(String string, UrlHttpMethod urlHttpMethod, HttpErrorProcessor httpErrorProcessor, SSLConfig sSLConfig) throws IOException {
        return this.readUrl(string, -1, null, null, urlHttpMethod, httpErrorProcessor, sSLConfig);
    }

    @Override
    public byte[] readUrl(String string, int n, String string2, String string3, UrlHttpMethod urlHttpMethod) throws IOException {
        Properties properties = UrlHttpManagerImpl.buildHeaders(string2, string3);
        return this.readUrl(string, n, urlHttpMethod, properties);
    }

    private static Properties buildHeaders(String string, String string2) {
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty("Content-Type", string);
        }
        if (string2 != null) {
            properties.setProperty(ACCEPT, string2);
        }
        return properties;
    }

    @Override
    public byte[] readUrl(String string, int n, String string2, String string3, UrlHttpMethod urlHttpMethod, HttpErrorProcessor httpErrorProcessor) throws IOException {
        Properties properties = UrlHttpManagerImpl.buildHeaders(string2, string3);
        return this.readUrl(string, n, urlHttpMethod, properties, httpErrorProcessor);
    }

    @Override
    public byte[] readUrl(String string, int n, UrlHttpMethod urlHttpMethod, Properties properties) throws IOException {
        return this.readUrl(string, n, urlHttpMethod, properties, null);
    }

    @Override
    public byte[] readUrl(String string, int n, UrlHttpMethod urlHttpMethod, Properties properties, HttpErrorProcessor httpErrorProcessor) throws IOException {
        return this.readUrl(string, n, urlHttpMethod, properties, httpErrorProcessor, null);
    }

    @Override
    public byte[] readUrl(String string, int n, String string2, String string3, UrlHttpMethod urlHttpMethod, HttpErrorProcessor httpErrorProcessor, SSLConfig sSLConfig) throws IOException {
        Properties properties = UrlHttpManagerImpl.buildHeaders(string2, string3);
        return this.readUrl(string, n, urlHttpMethod, properties, httpErrorProcessor, sSLConfig);
    }

    @Override
    public byte[] readUrl(String string, int n, UrlHttpMethod urlHttpMethod, Properties properties, HttpErrorProcessor httpErrorProcessor, SSLConfig sSLConfig) throws IOException {
        byte[] byArray;
        Object object;
        String string2;
        String string3;
        String string4;
        if (string == null) {
            throw new IllegalArgumentException("La URL a leer no puede ser nula");
        }
        URLName uRLName = new URLName(string);
        if (uRLName.getUsername() != null || uRLName.getPassword() != null) {
            string4 = uRLName.getUsername() != null && uRLName.getPassword() != null ? uRLName.getUsername() + URN_SEPARATOR + uRLName.getPassword() : (uRLName.getUsername() != null ? uRLName.getUsername() : uRLName.getPassword());
            string3 = Base64.encode(string4.getBytes());
            string2 = uRLName.getProtocol() + PROT_SEPARATOR + uRLName.getHost() + (uRLName.getPort() != -1 ? URN_SEPARATOR + Integer.toString(uRLName.getPort()) : "") + "/" + (uRLName.getFile() != null ? uRLName.getFile() : "");
        } else {
            string2 = string;
            string3 = null;
        }
        string4 = null;
        String string5 = null;
        if (UrlHttpMethod.POST.equals((Object)urlHttpMethod) || UrlHttpMethod.PUT.equals((Object)urlHttpMethod)) {
            object = new StringTokenizer(string2, "?");
            string5 = ((StringTokenizer)object).nextToken();
            if (string2.contains("?")) {
                string4 = ((StringTokenizer)object).nextToken();
            }
        }
        object = new URL(string5 != null ? string5 : string2);
        try {
            HttpURLConnection httpURLConnection = Platform.OS.ANDROID.equals((Object)Platform.getOS()) || UrlHttpManagerImpl.isLocal((URL)object) ? (HttpURLConnection)((URL)object).openConnection(Proxy.NO_PROXY) : (HttpURLConnection)((URL)object).openConnection();
            boolean bl = sSLConfig == null && Boolean.parseBoolean(System.getProperty(JAVA_PARAM_DISABLE_SSL_CHECKS, "false"));
            boolean bl2 = UrlHttpManagerImpl.checkIsSecureDomain((URL)object);
            if (httpURLConnection instanceof HttpsURLConnection) {
                if (bl || bl2) {
                    try {
                        SslSecurityManager.disableSslChecks((HttpsURLConnection)httpURLConnection);
                        LOGGER.info("Deshabilitada la comprobacion SSL para el acceso al dominio: " + ((URL)object).getHost());
                    }
                    catch (Exception exception) {
                        LOGGER.warning("No se ha podido ajustar la confianza SSL, es posible que no se pueda completar la conexion: " + exception);
                    }
                } else if (sSLConfig != null) {
                    SslSecurityManager.setSslSecurity((HttpsURLConnection)httpURLConnection, sSLConfig);
                }
            }
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setRequestMethod(urlHttpMethod.toString());
            Properties properties2 = new Properties();
            if (properties != null) {
                properties2.putAll((Map<?, ?>)properties);
            }
            if (string3 != null && !properties2.containsKey("Authorization")) {
                httpURLConnection.addRequestProperty("Authorization", "Basic " + string3);
            }
            if (!properties2.containsKey(ACCEPT)) {
                httpURLConnection.addRequestProperty(ACCEPT, "*/*");
            }
            if (!properties2.containsKey("Connection")) {
                httpURLConnection.addRequestProperty("Connection", "keep-alive");
            }
            if (!properties2.containsKey("Host")) {
                httpURLConnection.addRequestProperty("Host", ((URL)object).getHost());
            }
            if (!properties2.containsKey("Origin")) {
                httpURLConnection.addRequestProperty("Origin", ((URL)object).getProtocol() + PROT_SEPARATOR + ((URL)object).getHost());
            }
            for (Map.Entry<Object, Object> object22 : properties2.entrySet()) {
                httpURLConnection.addRequestProperty((String)object22.getKey(), (String)object22.getValue());
            }
            if (string4 != null) {
                httpURLConnection.setRequestProperty("Content-Length", String.valueOf(string4.getBytes(StandardCharsets.UTF_8).length));
                httpURLConnection.setDoOutput(true);
                Throwable throwable = null;
                try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                    outputStream.write(string4.getBytes(StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            if (n != -1) {
                httpURLConnection.setConnectTimeout(n);
            }
            httpURLConnection.connect();
            int n2 = httpURLConnection.getResponseCode();
            String string6 = Integer.toString(n2);
            if (string6.startsWith("4") || string6.startsWith("5")) {
                throw new HttpError(n2, httpURLConnection.getResponseMessage(), AOUtil.getDataFromInputStream(httpURLConnection.getErrorStream()), string2);
            }
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                byArray = AOUtil.getDataFromInputStream(inputStream);
            }
        }
        catch (IOException iOException) {
            if (httpErrorProcessor != null) {
                LOGGER.log(Level.WARNING, "Fallo la conexion pero intentamos recuperarla: " + iOException);
                return httpErrorProcessor.processHttpError(iOException, this, string2, n, urlHttpMethod, properties);
            }
            throw iOException;
        }
        return byArray;
    }

    private static boolean isLocal(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("La URL no puede ser nula");
        }
        try {
            return InetAddress.getByName(uRL.getHost()).isLoopbackAddress();
        }
        catch (Exception exception) {
            LOGGER.warning("Error comprobando si una URL es el bucle local: " + exception);
            return false;
        }
    }

    private static boolean checkIsSecureDomain(URL uRL) {
        String string = System.getProperty(JAVA_PARAM_SECURE_DOMAINS_LIST);
        if (string != null && !string.isEmpty()) {
            String[] stringArray;
            String string2 = uRL.getHost();
            for (String string3 : stringArray = string.split(",")) {
                String string4 = string3.replace("*", "");
                if (!(string3.startsWith("*") && string3.endsWith("*") ? string2.contains(string4) : (string3.startsWith("*") ? string2.endsWith(string4) : (string3.endsWith("*") ? string2.startsWith(string4) : string2.equals(string4))))) continue;
                return true;
            }
        }
        return false;
    }

    static {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
    }
}

