/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.http;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.ui.CoreMessages;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;

public class TrustStoreManager {
    private static final char[] TRUSTED_KS_PWD = "changeit".toCharArray();
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private KeyStore ks;
    private final File tsPath;
    private static TrustStoreManager instance = null;

    public static TrustStoreManager getInstance() {
        return TrustStoreManager.getInstance(null);
    }

    public static TrustStoreManager getInstance(Object object) {
        if (instance == null) {
            instance = new TrustStoreManager(object);
        }
        return instance;
    }

    private TrustStoreManager(Object object) {
        block5: {
            this.tsPath = TrustStoreManager.getJKSFile();
            if (this.tsPath.isFile()) {
                try {
                    this.ks = this.loadTrustedKeyStore();
                }
                catch (Exception exception) {
                    int n = AOUIFactory.showConfirmDialog(object, CoreMessages.getString("AutofirmaTrustStore.0"), CoreMessages.getString("AutofirmaTrustStore.1"), AOUIFactory.YES_NO_OPTION, AOUIFactory.WARNING_MESSAGE);
                    if (n != AOUIFactory.OK_OPTION) break block5;
                    try {
                        Files.delete(this.tsPath.toPath());
                    }
                    catch (IOException iOException) {
                        LOGGER.warning("No se pudo eliminar el TrustStore corrupto: " + iOException);
                    }
                    this.ks = null;
                }
            }
        }
    }

    public X509Certificate[] getCertificates() throws KeyStoreException {
        if (this.ks == null) {
            return new X509Certificate[0];
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        Enumeration<String> enumeration = this.ks.aliases();
        while (enumeration.hasMoreElements()) {
            arrayList.add((X509Certificate)this.ks.getCertificate(enumeration.nextElement()));
        }
        return arrayList.toArray(new X509Certificate[0]);
    }

    public void importCerts(X509Certificate ... x509CertificateArray) throws KeyStoreException, IOException {
        if (x509CertificateArray == null) {
            return;
        }
        if (this.ks == null) {
            this.ks = TrustStoreManager.createTrustedKeystore();
        }
        for (X509Certificate x509Certificate : x509CertificateArray) {
            String string = this.searchCert(x509Certificate);
            if (string != null) continue;
            string = this.generateAlias(x509Certificate);
            this.ks.setCertificateEntry(string, x509Certificate);
        }
        this.store();
    }

    private String generateAlias(X509Certificate x509Certificate) throws KeyStoreException {
        String string;
        String string2 = string = x509Certificate.getSubjectX500Principal().toString();
        int n = 1;
        while (this.ks.containsAlias(string2)) {
            string2 = string + " (" + n + ")";
            ++n;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws KeyStoreException, IOException {
        TrustStoreManager trustStoreManager = instance;
        synchronized (trustStoreManager) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.tsPath);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                this.ks.store(bufferedOutputStream, TRUSTED_KS_PWD);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new KeyStoreException("No se ha podido guardar el almacen", exception);
            }
        }
    }

    public void deleteCert(X509Certificate x509Certificate) throws KeyStoreException, IOException {
        if (this.ks == null) {
            return;
        }
        String string = this.searchCert(x509Certificate);
        if (string == null) {
            LOGGER.warning("No se encontro en el almacen el certificado que desea eliminar");
            return;
        }
        this.ks.deleteEntry(string);
        this.store();
    }

    private String searchCert(X509Certificate x509Certificate) throws KeyStoreException {
        Enumeration<String> enumeration = this.ks.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            X509Certificate x509Certificate2 = (X509Certificate)this.ks.getCertificate(string);
            if (!x509Certificate2.equals(x509Certificate)) continue;
            return string;
        }
        return null;
    }

    private static KeyStore createTrustedKeystore() throws KeyStoreException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, TRUSTED_KS_PWD);
        }
        catch (Exception exception) {
            throw new KeyStoreException("No se ha podido crear un almacen vacio", exception);
        }
        return keyStore;
    }

    private KeyStore loadTrustedKeyStore() throws IOException, KeyStoreException {
        byte[] byArray;
        Object object = new FileInputStream(this.tsPath);
        Object object2 = null;
        try {
            byArray = AOUtil.getDataFromInputStream((InputStream)object);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)object).close();
                }
            }
        }
        try {
            object2 = new ByteArrayInputStream(byArray);
            Throwable throwable = null;
            try {
                object = KeyStore.getInstance("JKS");
                ((KeyStore)object).load((InputStream)object2, TRUSTED_KS_PWD);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException("No se ha podido cargar el almacen de confianza de la aplicacion", exception);
        }
        return object;
    }

    public static File getJKSFile() {
        return new File(Platform.getUserHome(), ".afirma" + File.separator + "TrustedCertsKeystore.jks");
    }
}

