/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.http;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.LoggerUtil;
import es.gob.afirma.core.misc.http.MultiX509TrustManager;
import es.gob.afirma.core.misc.http.SSLConfig;
import es.gob.afirma.core.misc.http.TrustStoreManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.PasswordCallback;

public final class SslSecurityManager {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    static final TrustManager[] DUMMY_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }};
    static final HostnameVerifier DUMMY_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };
    private static final String KEYSTORE = "javax.net.ssl.keyStore";
    private static final String KEYSTORE_PASS = "javax.net.ssl.keyStorePassword";
    private static final String KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String KEYSTORE_DEFAULT_TYPE = "JKS";
    private static final String SSL_CONTEXT = "SSL";
    private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = HttpsURLConnection.getDefaultHostnameVerifier();
    private static final SSLSocketFactory DEFAULT_SSL_SOCKET_FACTORY = HttpsURLConnection.getDefaultSSLSocketFactory();
    private static final SecureRandom secureRandom = new SecureRandom();
    private static boolean afirmaTrustStoreConfigured = false;

    private SslSecurityManager() {
    }

    public static void disableSslChecks(HttpsURLConnection httpsURLConnection) throws GeneralSecurityException {
        SSLContext sSLContext = SSLContext.getInstance(SSL_CONTEXT);
        sSLContext.init(null, DUMMY_TRUST_MANAGER, secureRandom);
        httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
        httpsURLConnection.setHostnameVerifier(DUMMY_HOSTNAME_VERIFIER);
    }

    public static void disableSslChecks() throws GeneralSecurityException {
        SslSecurityManager.setTrustManagerAndKeyManager(DUMMY_TRUST_MANAGER, DUMMY_HOSTNAME_VERIFIER, null, null);
    }

    public static void enableSslChecks() throws IOException, GeneralSecurityException {
        if (afirmaTrustStoreConfigured) {
            SslSecurityManager.configureAfirmaTrustManagers();
        } else {
            HttpsURLConnection.setDefaultSSLSocketFactory(DEFAULT_SSL_SOCKET_FACTORY);
            HttpsURLConnection.setDefaultHostnameVerifier(DEFAULT_HOSTNAME_VERIFIER);
        }
        LOGGER.fine("Habilitadas comprobaciones SSL");
    }

    private static void setTrustManagerAndKeyManager(TrustManager[] trustManagerArray, HostnameVerifier hostnameVerifier, KeyStore keyStore, PasswordCallback passwordCallback) throws KeyManagementException, NoSuchAlgorithmException {
        KeyManager[] keyManagerArray;
        if (trustManagerArray == null || trustManagerArray.length < 1) {
            throw new IllegalArgumentException("Es necesario proporcionar al menos un TrustManager");
        }
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("Es necesario proporcionar un HostnameVerifier");
        }
        SSLContext sSLContext = SSLContext.getInstance(SSL_CONTEXT);
        try {
            keyManagerArray = SslSecurityManager.getKeyManager(keyStore, passwordCallback);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "No ha sido posible obtener el KeyManager con el KeyStore '" + System.getProperty(KEYSTORE) + "', se usara null: " + exception, exception);
            keyManagerArray = null;
        }
        sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }

    private static KeyManager[] getKeyManager(KeyStore keyStore, PasswordCallback passwordCallback) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        Object object;
        char[] cArray;
        KeyStore keyStore2;
        if (keyStore != null) {
            LOGGER.info("Se usara el almacen de claves SSL proporcionado de forma directa: " + keyStore.getType());
            keyStore2 = keyStore;
            cArray = passwordCallback != null ? passwordCallback.getPassword() : new char[]{};
        } else {
            object = System.getProperty(KEYSTORE);
            String string = System.getProperty(KEYSTORE_PASS);
            String string2 = System.getProperty(KEYSTORE_TYPE);
            if (object == null || ((String)object).isEmpty()) {
                return null;
            }
            File file = new File((String)object);
            if (!file.isFile() || !file.canRead()) {
                LOGGER.warning("El KeyStore SSL no existe o no es legible: " + LoggerUtil.getCleanUserHomePath(file.getAbsolutePath()));
                return null;
            }
            keyStore2 = KeyStore.getInstance(string2 != null && !string2.isEmpty() ? string2 : KEYSTORE_DEFAULT_TYPE);
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                keyStore2.load(fileInputStream, string != null ? string.toCharArray() : null);
            }
            cArray = string != null ? string.toCharArray() : new char[]{};
        }
        object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        ((KeyManagerFactory)object).init(keyStore2, cArray);
        return ((KeyManagerFactory)object).getKeyManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureAfirmaTrustManagers() throws IOException, GeneralSecurityException {
        byte[] byArray;
        Object object;
        InputStream inputStream;
        File file = TrustStoreManager.getJKSFile();
        if (!file.isFile()) {
            return;
        }
        Object object2 = TrustStoreManager.getInstance();
        synchronized (object2) {
            inputStream = new FileInputStream(file);
            object = null;
            try {
                byArray = AOUtil.getDataFromInputStream(inputStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        object2 = KeyStore.getInstance(KEYSTORE_DEFAULT_TYPE);
        inputStream = new ByteArrayInputStream(byArray);
        object = null;
        try {
            ((KeyStore)object2).load(inputStream, "changeit".toCharArray());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (object != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        if (((KeyStore)object2).aliases() == null || !((KeyStore)object2).aliases().hasMoreElements()) {
            return;
        }
        inputStream = new X509TrustManager[2];
        object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        ((TrustManagerFactory)object).init((KeyStore)null);
        inputStream[0] = (X509TrustManager)((TrustManagerFactory)object).getTrustManagers()[0];
        object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        ((TrustManagerFactory)object).init((KeyStore)object2);
        inputStream[1] = (X509TrustManager)((TrustManagerFactory)object).getTrustManagers()[0];
        MultiX509TrustManager multiX509TrustManager = new MultiX509TrustManager((X509TrustManager[])inputStream);
        LOGGER.info("Se configura el almacen de confianza de Autofirma");
        SSLContext sSLContext = SSLContext.getInstance(SSL_CONTEXT);
        sSLContext.init(null, new TrustManager[]{multiX509TrustManager}, secureRandom);
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(DEFAULT_HOSTNAME_VERIFIER);
        afirmaTrustStoreConfigured = true;
    }

    public static void setSslSecurity(HttpsURLConnection httpsURLConnection, SSLConfig sSLConfig) {
        if (sSLConfig.getSSLSocketFactory() != null) {
            httpsURLConnection.setSSLSocketFactory(sSLConfig.getSSLSocketFactory());
        }
        if (sSLConfig.getHostnameVerifier() != null) {
            httpsURLConnection.setHostnameVerifier(sSLConfig.getHostnameVerifier());
        }
    }
}

