/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.http;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.http.HttpErrorProcessor;
import es.gob.afirma.core.misc.http.SslSecurityManager;
import es.gob.afirma.core.misc.http.TrustStoreManager;
import es.gob.afirma.core.misc.http.UrlHttpManager;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.ui.CoreMessages;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;

public class SSLErrorProcessor
implements HttpErrorProcessor {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String PROPERTY_HEADLESS = "headless";
    private static final String PROPERTY_SSL_HEADLESS = "sslOmitImportationDialog";
    private static boolean showingConfirmDialog = false;
    static final String TRUSTED_KS_PWD = "changeit";
    private boolean initialized = false;
    private boolean cancelled = false;
    private boolean headless;

    public SSLErrorProcessor() {
        this.headless = false;
    }

    public SSLErrorProcessor(Properties properties) {
        boolean bl = this.headless = properties != null && (Boolean.parseBoolean(properties.getProperty(PROPERTY_HEADLESS)) || Boolean.parseBoolean(properties.getProperty(PROPERTY_SSL_HEADLESS)));
        if (!this.headless) {
            boolean bl2 = false;
            try {
                bl2 = !SSLErrorProcessor.hasGraphicsEnvironment();
            }
            catch (Throwable throwable) {
                bl2 = true;
            }
            this.headless = bl2;
        }
    }

    private void initilize() {
        if (!this.initialized) {
            if (!this.headless) {
                boolean bl = false;
                try {
                    bl = !SSLErrorProcessor.hasGraphicsEnvironment();
                }
                catch (Throwable throwable) {
                    bl = true;
                }
                this.headless = bl;
            }
            this.initialized = true;
        }
    }

    private static boolean hasGraphicsEnvironment() {
        boolean bl;
        try {
            Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
            Method method = clazz.getMethod("isHeadless", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            bl = object instanceof Boolean ? (Boolean)object : true;
        }
        catch (Throwable throwable) {
            LOGGER.warning("No se pudo comprobar si hay entorno gr&aacute;fico: " + throwable);
            bl = true;
        }
        return !bl;
    }

    public SSLErrorProcessor(boolean bl) {
        this.headless = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] processHttpError(IOException iOException, UrlHttpManager urlHttpManager, String string, int n, UrlHttpMethod urlHttpMethod, Properties properties) throws IOException {
        if (!(iOException instanceof SSLHandshakeException)) {
            LOGGER.info("El error no es de tipo SSLHandShake y no la tratamos");
            throw iOException;
        }
        this.initilize();
        if (this.headless) {
            LOGGER.info("No se confia en el certificado SSL, pero no se pueden mostrar dialogos para importarlo en el almacen de confianza");
            throw iOException;
        }
        if (showingConfirmDialog) {
            LOGGER.info("Ya se esta mostrando un dialogo de consulta para la importacion del certificado de confianza. Se omitira este.");
            throw iOException;
        }
        X509Certificate[] x509CertificateArray = LOGGER;
        synchronized (LOGGER) {
            int n2;
            try {
                showingConfirmDialog = true;
                n2 = AOUIFactory.showConfirmDialog(null, CoreMessages.getString("SSLRequestPermissionDialog.2", new URL(string).getHost()), CoreMessages.getString("SSLRequestPermissionDialog.1"), AOUIFactory.YES_NO_OPTION, AOUIFactory.WARNING_MESSAGE);
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                this.cancelled = true;
                throw iOException;
            }
            catch (Exception exception) {
                throw iOException;
            }
            finally {
                showingConfirmDialog = false;
            }
            // ** MonitorExit[var8_7] (shouldn't be in output)
            if (n2 != AOUIFactory.YES_OPTION) {
                LOGGER.info("El usuario no importo el certificado en el almacen de confianza");
                this.cancelled = true;
                throw iOException;
            }
            try {
                x509CertificateArray = SSLErrorProcessor.downloadFromRemoteServer(string);
            }
            catch (Exception exception) {
                LOGGER.severe("Error al descargar certificados SSL del servidor: " + exception);
                throw new IOException(exception);
            }
            for (X509Certificate x509Certificate : x509CertificateArray) {
                LOGGER.info("Se importa en caliente en el almacen de confianza el certificado con el numero de serie: " + AOUtil.hexify(x509Certificate.getSerialNumber().toByteArray(), false));
            }
            try {
                TrustStoreManager.getInstance().importCerts(x509CertificateArray);
            }
            catch (Exception exception) {
                LOGGER.severe("Error al importar los certificados SSL en el almacen de confianza: " + exception);
                throw new IOException(exception);
            }
            try {
                SslSecurityManager.configureAfirmaTrustManagers();
            }
            catch (Exception exception) {
                LOGGER.severe("Error reconfigurando el contexto SSL con los nuevos certificados: " + exception);
                throw new IOException(exception);
            }
            return urlHttpManager.readUrl(string, n, urlHttpMethod, properties);
        }
    }

    private static X509Certificate[] downloadFromRemoteServer(String string) throws Exception {
        X509Certificate[] x509CertificateArray;
        URL uRL = new URL(string);
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        SslSecurityManager.disableSslChecks(httpsURLConnection);
        httpsURLConnection.connect();
        Certificate[] certificateArray = httpsURLConnection.getServerCertificates();
        httpsURLConnection.disconnect();
        if (certificateArray.length > 1) {
            x509CertificateArray = new X509Certificate[certificateArray.length - 1];
            for (int i = 1; i < certificateArray.length; ++i) {
                x509CertificateArray[i - 1] = (X509Certificate)certificateArray[i];
            }
        } else {
            x509CertificateArray = new X509Certificate[]{(X509Certificate)certificateArray[0]};
        }
        return x509CertificateArray;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

