/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.http;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;

public class MultiX509TrustManager
implements X509TrustManager {
    private final X509TrustManager[] tms;

    public MultiX509TrustManager(X509TrustManager[] x509TrustManagerArray) {
        this.tms = x509TrustManagerArray;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        CertificateException certificateException = null;
        for (int i = 0; i < this.tms.length && !bl; ++i) {
            try {
                this.tms[i].checkClientTrusted(x509CertificateArray, string);
                bl = true;
                continue;
            }
            catch (CertificateException certificateException2) {
                certificateException = certificateException2;
            }
        }
        if (!bl && certificateException != null) {
            throw certificateException;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        CertificateException certificateException = null;
        for (int i = 0; i < this.tms.length && !bl; ++i) {
            try {
                this.tms[i].checkServerTrusted(x509CertificateArray, string);
                bl = true;
                continue;
            }
            catch (CertificateException certificateException2) {
                certificateException = certificateException2;
            }
        }
        if (!bl && certificateException != null) {
            throw certificateException;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (X509TrustManager x509TrustManager : this.tms) {
            arrayList.addAll(Arrays.asList(x509TrustManager.getAcceptedIssuers()));
        }
        return arrayList.toArray(new X509Certificate[0]);
    }
}

