/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public class SecureXmlBuilder {
    private static DocumentBuilderFactory SECURE_BUILDER_FACTORY = null;
    private static SAXParserFactory SAX_FACTORY = null;

    public static DocumentBuilder getSecureDocumentBuilder() throws ParserConfigurationException {
        if (SECURE_BUILDER_FACTORY == null) {
            String[] stringArray;
            SECURE_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
            try {
                SECURE_BUILDER_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").log(Level.WARNING, "No se ha podido establecer el procesado seguro en la factoria XML: " + exception);
            }
            for (String string : stringArray = new String[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", "http://javax.xml.XMLConstants/property/accessExternalSchema", "http://javax.xml.XMLConstants/property/accessExternalStylesheet"}) {
                try {
                    SECURE_BUILDER_FACTORY.setAttribute(string, "");
                }
                catch (Exception exception) {
                    Logger.getLogger("es.gob.afirma").log(Level.FINE, "No se ha podido establecer una propiedad de seguridad '" + string + "' en la factoria XML");
                }
            }
            SECURE_BUILDER_FACTORY.setValidating(false);
            SECURE_BUILDER_FACTORY.setNamespaceAware(true);
        }
        return SECURE_BUILDER_FACTORY.newDocumentBuilder();
    }

    public static SAXParser getSecureSAXParser() throws ParserConfigurationException, SAXException {
        if (SAX_FACTORY == null) {
            SAX_FACTORY = SAXParserFactory.newInstance();
            try {
                SAX_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").log(Level.SEVERE, "No se ha podido establecer una caracteristica de seguridad en la factoria XML: " + exception);
            }
            try {
                SAX_FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
                SAX_FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").log(Level.FINE, "No se ha podido establecer una caracteristica de seguridad en la factoria SAX XML: " + exception);
            }
            SAX_FACTORY.setValidating(false);
            SAX_FACTORY.setNamespaceAware(true);
        }
        return SAX_FACTORY.newSAXParser();
    }
}

