/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc;

import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.LoggerUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOUtil {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String[] SUPPORTED_URI_SCHEMES = new String[]{"http", "https", "file", "urn"};
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private AOUtil() {
    }

    public static URI createURI(String string) throws URISyntaxException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("No se puede crear una URI a partir de un nulo");
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("La URI no puede ser una cadena vacia");
        }
        string2 = string2.replace('\\', '/');
        string2 = string2.replace(" ", "%20").replace("<", "%3C").replace(">", "%3E").replace("\"", "%22").replace("{", "%7B").replace("}", "%7D").replace("|", "%7C").replace("^", "%5E").replace("[", "%5B").replace("]", "%5D").replace("`", "%60");
        URI uRI = new URI(string2);
        String string3 = uRI.getScheme();
        for (String string4 : SUPPORTED_URI_SCHEMES) {
            if (!string4.equals(string3)) continue;
            return uRI;
        }
        if (string3 == null) {
            string2 = string2.replace("#", "%23");
            return AOUtil.createURI("file://" + string2);
        }
        if (string3.length() == 1 && Character.isLetter((char)string3.getBytes()[0])) {
            string2 = string2.replace("#", "%23");
            return AOUtil.createURI("file://" + string2);
        }
        throw new URISyntaxException(string2, "Tipo de URI no soportado");
    }

    public static InputStream loadFile(URI uRI) throws IOException {
        if (uRI == null) {
            throw new IllegalArgumentException("Se ha pedido el contenido de una URI nula");
        }
        if (uRI.getScheme().equals("file")) {
            String string = uRI.getSchemeSpecificPart();
            if (string.startsWith("//")) {
                string = string.substring(2);
            }
            return new FileInputStream(new File(string));
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRI.toURL().openStream());
        byte[] byArray = AOUtil.getDataFromInputStream(bufferedInputStream);
        return new ByteArrayInputStream(byArray);
    }

    public static byte[] getDataFromInputStream(InputStream inputStream) throws IOException {
        int n;
        if (inputStream == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String getCN(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        return AOUtil.getCN(x509Certificate.getSubjectX500Principal().toString());
    }

    public static String getCN(String string) {
        if (string == null) {
            return null;
        }
        String string2 = AOUtil.getRDNvalueFromLdapName("cn", string);
        if (string2 == null) {
            string2 = AOUtil.getRDNvalueFromLdapName("ou", string);
        }
        if (string2 != null) {
            return string2;
        }
        int n = string.indexOf(61);
        if (n != -1) {
            LOGGER.warning("No se ha podido obtener el Common Name ni la Organizational Unit, se devolvera el fragmento mas significativo");
            return AOUtil.getRDNvalueFromLdapName(string.substring(0, n), string);
        }
        LOGGER.warning("Principal no valido, se devolvera la entrada");
        return string;
    }

    public static String[] getOUS(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = AOUtil.getRDNvalueFromLdapName("ou", string);
        String string3 = string;
        while (string2 != null) {
            arrayList.add(string2);
            string3 = string3.replace("OU=" + string2, "");
            string2 = AOUtil.getRDNvalueFromLdapName("ou", string3);
        }
        return arrayList.toArray(new String[0]);
    }

    public static String getRDNvalueFromLdapName(String string, String string2) {
        int n = 0;
        while ((n = string2.toLowerCase(Locale.US).indexOf(string.toLowerCase(), n)) != -1) {
            if (n > 0 && string2.charAt(n - 1) != ',' && string2.charAt(n - 1) != ' ') {
                ++n;
                continue;
            }
            n += string.length();
            while (n < string2.length() && string2.charAt(n) == ' ') {
                ++n;
            }
            if (n >= string2.length()) {
                return null;
            }
            if (string2.charAt(n) != '=') continue;
            ++n;
            while (n < string2.length() && string2.charAt(n) == ' ') {
                ++n;
            }
            if (n >= string2.length()) {
                return "";
            }
            if (string2.charAt(n) == ',') {
                return "";
            }
            if (string2.charAt(n) == '\"') {
                if (++n >= string2.length()) {
                    return "";
                }
                int n2 = string2.indexOf(34, n);
                if (n2 == n) {
                    return "";
                }
                if (n2 != -1) {
                    return string2.substring(n, n2);
                }
                return string2.substring(n);
            }
            int n3 = string2.indexOf(44, n);
            if (n3 != -1) {
                return string2.substring(n, n3).trim();
            }
            return string2.substring(n).trim();
        }
        return null;
    }

    public static boolean isPseudonymCert(X509Certificate x509Certificate) {
        return AOUtil.getRDNvalueFromLdapName("2.5.4.65", x509Certificate.getSubjectX500Principal().getName("RFC2253")) != null;
    }

    public static String hexify(byte[] byArray, boolean bl) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (bl && n > 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append(HEX_CHARS[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(HEX_CHARS[byArray[i] & 0xF]);
            if (++n != 16) continue;
            if (bl && i < byArray.length - 1) {
                stringBuffer.append('\n');
            }
            n = 0;
        }
        return stringBuffer.toString();
    }

    public static String hexify(byte[] byArray, String string) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        for (int i = 0; i < byArray.length; ++i) {
            if (string != null && i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(HEX_CHARS[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(HEX_CHARS[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static void loadNativeLibrary(String string) throws IOException {
        if (string == null) {
            LOGGER.warning("No se puede cargar una biblioteca nula");
            return;
        }
        int n = string.lastIndexOf(46);
        File file = new File(string);
        File file2 = File.createTempFile(n < 1 ? file.getName() : file.getName().substring(0, file.getName().indexOf(46)), n < 1 || n == string.length() - 1 ? null : string.substring(n));
        AOUtil.copyFile(file, file2);
        file2.deleteOnExit();
        LOGGER.info("Cargamos " + LoggerUtil.getCleanUserHomePath(file2.getAbsolutePath()));
        System.load(file2.getAbsolutePath());
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (file == null || file2 == null) {
            throw new IllegalArgumentException("Ni origen ni destino de la copia pueden ser nulos");
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(file2);
             FileChannel fileChannel = fileInputStream.getChannel();
             FileChannel fileChannel2 = fileOutputStream.getChannel();){
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            fileChannel2.write(mappedByteBuffer);
        }
    }

    public static String[] split(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while (n != string.length() && (n2 = string.indexOf(string2, n)) != -1) {
            if (n == n2) {
                arrayList.add("");
            } else {
                arrayList.add(string.substring(n, n2));
            }
            n = n2 + string2.length();
        }
        if (n == string.length()) {
            arrayList.add("");
        } else {
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[0]);
    }

    public static String properties2Base64(Properties properties) throws IOException {
        if (properties == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, DEFAULT_ENCODING);
        properties.store(outputStreamWriter, "");
        return Base64.encode(byteArrayOutputStream.toByteArray(), true);
    }

    public static Properties base642Properties(String string) throws IOException {
        Properties properties = new Properties();
        if (string == null || string.isEmpty()) {
            return properties;
        }
        properties.load(new InputStreamReader((InputStream)new ByteArrayInputStream(Base64.decode(string.replace('-', '+').replace('_', '/'))), DEFAULT_ENCODING));
        return properties;
    }

    public static String propertiesAsString(Properties properties) throws IOException {
        if (properties == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : properties.keySet().toArray(new String[0])) {
            stringBuilder.append(string).append("=").append(properties.getProperty(string)).append("\n");
        }
        return stringBuilder.toString();
    }

    public static boolean isJava9orNewer() {
        String string = System.getProperty("java.version");
        if (string == null || string.isEmpty()) {
            LOGGER.warning("No se ha podido determinar la version de Java");
            return false;
        }
        try {
            if (string.startsWith("1.")) {
                return Integer.parseInt(string.substring(2, 3)) > 8;
            }
            String string2 = string;
            if (string2.indexOf(".") > -1) {
                string2 = string2.substring(0, string2.indexOf("."));
            }
            if (AOUtil.isOnlyNumber(string2)) {
                return Integer.parseInt(string2) > 8;
            }
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido determinar la version de Java (" + string + "):" + exception);
        }
        return false;
    }

    public static boolean isOnlyNumber(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return string.matches("^[0-9]+$");
    }
}

