/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core;

import es.gob.afirma.core.CustomRuntimeConfigNeededException;
import es.gob.afirma.core.RuntimeConfigNeededException;
import java.util.Properties;

public class AGEPolicyIncompatibilityException
extends CustomRuntimeConfigNeededException {
    private static final long serialVersionUID = 8278487852684799319L;
    public static final String REQUESTOR_SIGN_MSG_CODE = "agePolicyIncompatibilitySign";
    public static final String REQUESTOR_COSIGN_MSG_CODE = "agePolicyIncompatibilityCosign";
    public static final String REQUESTOR_COUNTERSIGN_MSG_CODE = "agePolicyIncompatibilityCounterSign";
    private static final String EXTRA_PARAM_NEEDED = "avoidAGEPolicyIncompatibilities";
    public static final int OP_SIGN = 1;
    public static final int OP_COSIGN = 2;
    public static final int OP_COUNTERSIGN = 3;

    public AGEPolicyIncompatibilityException(String string) {
        this(string, 1);
    }

    public AGEPolicyIncompatibilityException(String string, int n) {
        super(string, RuntimeConfigNeededException.RequestType.CONFIRM, AGEPolicyIncompatibilityException.getMessageCode(n), EXTRA_PARAM_NEEDED);
    }

    public AGEPolicyIncompatibilityException(String string, Throwable throwable) {
        this(string, 1, throwable);
    }

    public AGEPolicyIncompatibilityException(String string, int n, Throwable throwable) {
        super(string, RuntimeConfigNeededException.RequestType.CONFIRM, AGEPolicyIncompatibilityException.getMessageCode(n), EXTRA_PARAM_NEEDED, throwable);
    }

    @Override
    public void prepareOperationWithConfirmation(Properties properties) {
        if (properties != null) {
            properties.remove("policyIdentifier");
            properties.remove("policyIdentifierHash");
            properties.remove("policyIdentifierHashAlgorithm");
            properties.remove("policyDescription");
            properties.remove("policyQualifier");
        }
    }

    private static String getMessageCode(int n) {
        String string;
        switch (n) {
            case 2: {
                string = REQUESTOR_COSIGN_MSG_CODE;
                break;
            }
            case 3: {
                string = REQUESTOR_COUNTERSIGN_MSG_CODE;
                break;
            }
            default: {
                string = REQUESTOR_SIGN_MSG_CODE;
            }
        }
        return string;
    }
}

