/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.ui;

import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIManager;
import es.gob.afirma.core.ui.GenericFileFilter;
import es.gob.afirma.core.ui.KeyStoreDialogManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

public final class AOUIFactory {
    public static final int PLAIN_MESSAGE;
    public static final int YES_NO_OPTION;
    public static final int WARNING_MESSAGE;
    public static final int YES_OPTION;
    public static final int NO_OPTION;
    public static final int OK_CANCEL_OPTION;
    public static final int OK_OPTION;
    public static final int INFORMATION_MESSAGE;
    public static final int QUESTION_MESSAGE;
    public static final int ERROR_MESSAGE;
    private static AOUIManager uiManager;

    private AOUIFactory() {
    }

    public static void setUIManager(AOUIManager aOUIManager) {
        if (aOUIManager != null) {
            uiManager = aOUIManager;
        }
    }

    public static char[] getPassword(String string, Object object) {
        return uiManager.getPassword(string, object);
    }

    public static char[] getPassword(String string, Object object, String string2, boolean bl, Object object2) {
        return uiManager.getPassword(string, object, string2, bl, object2);
    }

    public static char[] getDoublePassword(String string, String string2, Object object, String string3, boolean bl, Object object2) {
        return uiManager.getDoublePassword(string, string2, object, string3, bl, object2);
    }

    public static int showConfirmDialog(Object object, Object object2, String string, int n, int n2) {
        return uiManager.showConfirmDialog(object, object2, string, n, n2);
    }

    public static void showMessageDialog(Object object, Object object2, String string, int n) {
        uiManager.showMessageDialog(object, object2, string, n);
    }

    public static void showMessageDialog(Object object, Object object2, String string, int n, Object object3) {
        uiManager.showMessageDialog(object, object2, string, n, object3);
    }

    public static void showErrorMessage(Object object, String string, int n, Throwable throwable) {
        uiManager.showErrorMessage(object, string, n, throwable);
    }

    public static void showErrorMessage(Object object, Object object2, String string, int n, Throwable throwable) {
        uiManager.showErrorMessage(object, object2, string, n, throwable);
    }

    public static Object showInputDialog(Object object, Object object2, String string, int n, Object object3, Object[] objectArray, Object object4) {
        return uiManager.showInputDialog(object, object2, string, n, object3, objectArray, object4);
    }

    public static String showCertificateSelectionDialog(Object object, KeyStoreDialogManager keyStoreDialogManager) {
        return uiManager.showCertificateSelectionDialog(object, keyStoreDialogManager);
    }

    public static File[] getLoadFiles(String string, String string2, String string3, String[] stringArray, String string4, boolean bl, boolean bl2, Object object, Object object2) {
        return uiManager.getLoadFiles(string, string2, string3, stringArray, string4, bl, bl2, object, object2);
    }

    public static File getSaveDataToFile(byte[] byArray, String string, String string2, String string3, List<GenericFileFilter> list, Object object) throws IOException {
        return uiManager.saveDataToFile(byArray, string, string2, string3, list, object);
    }

    static {
        try {
            if (Platform.OS.ANDROID.equals((Object)Platform.getOS())) {
                throw new UnsupportedOperationException("No se soporta GUI en Android");
            }
            String string = Platform.OS.MACOSX.equals((Object)Platform.getOS()) ? "es.gob.afirma.ui.core.jse.AWTUIManager" : "es.gob.afirma.ui.core.jse.JSEUIManager";
            try {
                uiManager = (AOUIManager)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").severe("No se ha podido instanciar la implementacion de gestor de interfaces graficas: " + exception);
            }
            PLAIN_MESSAGE = uiManager.getPlainMessageCode();
            YES_NO_OPTION = uiManager.getYesNoOptionCode();
            WARNING_MESSAGE = uiManager.getWarningMessageCode();
            YES_OPTION = uiManager.getYesOptionCode();
            NO_OPTION = uiManager.getNoOptionCode();
            OK_CANCEL_OPTION = uiManager.getOkCancelOptionCode();
            OK_OPTION = uiManager.getOkOptionCode();
            INFORMATION_MESSAGE = uiManager.getInformationMessageCode();
            QUESTION_MESSAGE = uiManager.getQuestionMessageCode();
            ERROR_MESSAGE = uiManager.getErrorMessageCode();
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("No se ha podido instanciar el gestor de interfaces graficas: " + exception, exception);
        }
    }
}

