/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.misc.LoggerUtil;
import es.gob.afirma.core.misc.SecureXmlBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TriphaseData {
    private final List<TriSign> signs;
    private String format;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public TriSign getTriSign(String string) {
        if (string == null) {
            throw new IllegalArgumentException("El ID de la firma no puede ser nulo");
        }
        for (TriSign triSign : this.signs) {
            if (!string.equals(triSign.getId())) continue;
            return triSign;
        }
        return null;
    }

    public List<TriSign> getTriSigns(String string) {
        if (string == null) {
            throw new IllegalArgumentException("El ID de la firma no puede ser nulo");
        }
        ArrayList<TriSign> arrayList = new ArrayList<TriSign>();
        for (TriSign triSign : this.signs) {
            if (!string.equals(triSign.getId())) continue;
            arrayList.add(new TriSign(triSign));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public List<TriSign> getTriSigns() {
        return this.signs;
    }

    public TriphaseData() {
        this.signs = new ArrayList<TriSign>();
        this.format = null;
    }

    public TriphaseData(List<TriSign> list) {
        this(list, null);
    }

    public TriphaseData(List<TriSign> list, String string) {
        this.signs = list;
        this.format = string;
    }

    public void addSignOperation(TriSign triSign) {
        this.signs.add(triSign);
    }

    public TriSign getSign(int n) {
        return this.signs.get(n);
    }

    public int getSignsCount() {
        return this.signs.size();
    }

    public static TriphaseData parser(byte[] byArray) throws IOException {
        Document document;
        if (byArray == null) {
            throw new IllegalArgumentException("El XML de entrada no puede ser nulo");
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            document = SecureXmlBuilder.getSecureDocumentBuilder().parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            Logger.getLogger("es.gob.afirma").severe("Error al cargar el fichero XML: " + exception + "\n" + LoggerUtil.getTrimBytes(byArray));
            throw new IOException("Error al cargar el fichero XML: " + exception, exception);
        }
        return TriphaseData.parser(document.getDocumentElement());
    }

    public static TriphaseData parser(Element element) throws IOException {
        Object object;
        if (element == null) {
            throw new IllegalArgumentException("El XML de entrada no puede ser nulo");
        }
        NodeList nodeList = element.getChildNodes();
        int n = TriphaseData.nextNodeElementIndex(nodeList, 0);
        Node node = nodeList.item(n);
        if (n == -1 || !"firmas".equalsIgnoreCase(node.getNodeName())) {
            throw new IllegalArgumentException("No se encontro el nodo 'firmas' en el XML proporcionado");
        }
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (object = namedNodeMap.getNamedItem("format")) != null) {
            string = object.getNodeValue();
        }
        object = TriphaseData.parseSignsNode(node);
        return new TriphaseData((List<TriSign>)object, string);
    }

    private static List<TriSign> parseSignsNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<TriSign> arrayList = new ArrayList<TriSign>();
        int n = TriphaseData.nextNodeElementIndex(nodeList, 0);
        while (n != -1) {
            Node node2;
            Node node3 = nodeList.item(n);
            String string = null;
            NamedNodeMap namedNodeMap = node3.getAttributes();
            if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem("Id")) != null) {
                string = node2.getNodeValue();
            }
            arrayList.add(new TriSign(TriphaseData.parseParamsListNode(node3), string));
            n = TriphaseData.nextNodeElementIndex(nodeList, n + 1);
        }
        return arrayList;
    }

    private static Map<String, String> parseParamsListNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        int n = TriphaseData.nextNodeElementIndex(nodeList, 0);
        while (n != -1) {
            Node node2 = nodeList.item(n);
            String string = node2.getAttributes().getNamedItem("n").getNodeValue();
            String string2 = node2.getTextContent().trim();
            concurrentHashMap.put(string, string2);
            n = TriphaseData.nextNodeElementIndex(nodeList, n + 1);
        }
        return concurrentHashMap;
    }

    private static int nextNodeElementIndex(NodeList nodeList, int n) {
        for (int i = n; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<xml>\n");
        stringBuilder.append(" <firmas");
        if (this.format != null) {
            stringBuilder.append(" format=\"");
            stringBuilder.append(this.format);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">\n");
        for (TriSign triSign : this.signs) {
            stringBuilder.append("  <firma");
            if (triSign.getId() != null) {
                stringBuilder.append(" Id=\"");
                stringBuilder.append(triSign.getId());
                stringBuilder.append("\"");
            }
            stringBuilder.append(">\n");
            for (String string : triSign.getDict().keySet()) {
                stringBuilder.append("   <param n=\"").append(string).append("\">").append(triSign.getProperty(string)).append("</param>\n");
            }
            stringBuilder.append("  </firma>\n");
        }
        stringBuilder.append(" </firmas>\n");
        stringBuilder.append("</xml>");
        return stringBuilder.toString();
    }

    public static final class TriSign {
        private final Map<String, String> dict;
        private final String id;

        public TriSign(TriSign triSign) {
            this.id = triSign.getId();
            this.dict = new ConcurrentHashMap<String, String>(triSign.getDict().size());
            Set<String> set = triSign.getDict().keySet();
            for (String string : set) {
                this.dict.put(string, triSign.getProperty(string));
            }
        }

        public TriSign(Map<String, String> map, String string) {
            if (map == null) {
                throw new IllegalArgumentException("El diccionario de propiedades de la firma no puede ser nulo");
            }
            this.dict = map;
            this.id = string != null ? string : UUID.randomUUID().toString();
        }

        public String toString() {
            return "Firma trifasica individual con identificador " + this.getId();
        }

        public String getId() {
            return this.id;
        }

        public String getProperty(String string) {
            return this.dict.get(string);
        }

        public void addProperty(String string, String string2) {
            this.dict.put(string, string2);
        }

        public void deleteProperty(String string) {
            this.dict.remove(string);
        }

        public Map<String, String> getDict() {
            return new ConcurrentHashMap<String, String>(this.dict);
        }
    }
}

