/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignConstants;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Properties;

public final class AdESPolicy {
    private static final String DEFAULT_HASH_ALGORITHM = "SHA-512";
    private String policyIdentifier = null;
    private String policyIdentifierHash = null;
    private String policyIdentifierHashAlgorithm = null;
    private URL policyQualifier = null;

    public AdESPolicy(String string, String string2, String string3, String string4) {
        this.setValues(string, string2, string3, string4);
    }

    private void setValues(String string, String string2, String string3, String string4) {
        block21: {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("El identificador de politica no puede ser nulo ni vacio");
            }
            this.policyIdentifier = string;
            if (string2 == null || "0".equals(string2)) {
                this.policyIdentifierHashAlgorithm = string3 == null ? DEFAULT_HASH_ALGORITHM : AOSignConstants.getDigestAlgorithmName(string3);
                try (InputStream inputStream = new URL(string).openStream();){
                    this.policyIdentifierHash = Base64.encode(MessageDigest.getInstance(this.policyIdentifierHashAlgorithm).digest(AOUtil.getDataFromInputStream(inputStream)));
                    break block21;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Si no se especifica la huella digital de la politica es necesario que el identificador sea una URL accesible universalmente: " + exception, exception);
                }
            }
            if (string3 == null || string3.isEmpty()) {
                throw new IllegalArgumentException("Si se indica la huella digital del identificador de politica es obligatorio indicar tambien el algoritmo");
            }
            if (!Base64.isBase64(string2.getBytes())) {
                throw new IllegalArgumentException("La huella digital de la politica debe estar en formato Base64");
            }
            this.policyIdentifierHash = string2;
            this.policyIdentifierHashAlgorithm = AOSignConstants.getDigestAlgorithmName(string3);
        }
        if (string4 != null && !string4.isEmpty()) {
            try {
                this.policyQualifier = new URL(string4);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("El calificador de la politica debe ser una URL valida", exception);
            }
        }
    }

    public String getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public String getPolicyIdentifierHash() {
        return this.policyIdentifierHash;
    }

    public String getPolicyIdentifierHashAlgorithm() {
        return this.policyIdentifierHashAlgorithm;
    }

    public URL getPolicyQualifier() {
        return this.policyQualifier;
    }

    public static AdESPolicy buildAdESPolicy(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Es necesario proporciona las propiedades de la politica");
        }
        String string = properties.getProperty("policyIdentifier");
        if (string == null) {
            return null;
        }
        return new AdESPolicy(string, properties.getProperty("policyIdentifierHash"), properties.getProperty("policyIdentifierHashAlgorithm"), properties.getProperty("policyQualifier"));
    }

    public Properties asExtraParams() {
        Properties properties = new Properties();
        properties.put("policyIdentifier", this.getPolicyIdentifier());
        if (this.getPolicyIdentifierHash() != null) {
            properties.put("policyIdentifierHash", this.getPolicyIdentifierHash());
        }
        if (this.getPolicyIdentifierHashAlgorithm() != null) {
            properties.put("policyIdentifierHashAlgorithm", this.getPolicyIdentifierHashAlgorithm());
        }
        if (this.getPolicyQualifier() != null) {
            properties.put("policyQualifier", this.getPolicyQualifier());
        }
        return properties;
    }

    public String toString() {
        return "Politica de firma: identificador='" + this.getPolicyIdentifier() + "', huella='" + this.getPolicyIdentifierHash() + "', algoritmo de huella='" + this.getPolicyIdentifierHashAlgorithm() + "', calificador='" + this.getPolicyQualifier();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AdESPolicy)) {
            return false;
        }
        AdESPolicy adESPolicy = (AdESPolicy)object;
        return adESPolicy.getPolicyIdentifier().equals(this.getPolicyIdentifier()) && adESPolicy.getPolicyIdentifierHash().equals(this.getPolicyIdentifierHash()) && adESPolicy.getPolicyIdentifierHashAlgorithm().equals(this.getPolicyIdentifierHashAlgorithm());
    }

    public int hashCode() {
        return this.getPolicyIdentifier().hashCode();
    }
}

