/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.protocol;

import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.misc.protocol.ParameterLocalAccessRequestedException;
import es.gob.afirma.core.misc.protocol.ProtocolVersion;
import es.gob.afirma.core.misc.protocol.ProtocoloMessages;
import es.gob.afirma.core.misc.protocol.UrlParameters;
import java.net.URL;
import java.util.Locale;
import java.util.Map;

public final class UrlParametersToSave
extends UrlParameters {
    private static final String TITLE_PARAM = "title";
    private static final String FILETYPE_DESCRIPTION_PARAM = "desc";
    private static final String FILENAME_PARAM = "filename";
    private static final String FILENAME_EXTS_PARAM = "exts";
    private static final String ID_PARAM = "id";
    private static final String VER_PARAM = "ver";
    private String title = null;
    private String filename = null;
    private String extensions = null;
    private String fileTypeDescription = null;
    private String minimumProtocolVersion = null;

    void setFileTypeDescription(String string) {
        this.fileTypeDescription = string;
    }

    void setExtensions(String string) {
        this.extensions = string;
    }

    @Override
    void setFilename(String string) {
        this.filename = string;
    }

    void setTitle(String string) {
        this.title = string;
    }

    void setMinimumProtocolVersion(String string) {
        this.minimumProtocolVersion = string;
    }

    public String getFileTypeDescription() {
        return this.fileTypeDescription;
    }

    public String getExtensions() {
        return this.extensions;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMinimumProtocolVersion() {
        return this.minimumProtocolVersion;
    }

    public void setSaveParameters(Map<String, String> map) throws ParameterException {
        if (!map.containsKey("fileid") && !map.containsKey("dat")) {
            throw new ParameterException("Error al validar la URL del servlet de recuperacion: La URI debe contener o un identificador de fichero o los datos a guardar");
        }
        String string = null;
        if (map.containsKey(ID_PARAM)) {
            string = map.get(ID_PARAM);
        } else if (map.containsKey("fileid")) {
            string = map.get("fileid");
        }
        if (string != null) {
            if (string.length() > 20) {
                throw new ParameterException("La longitud del identificador de la operacion es mayor de 20 caracteres.");
            }
            for (char c : string.toLowerCase(Locale.ENGLISH).toCharArray()) {
                if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
                throw new ParameterException("El identificador de la firma debe ser alfanumerico.");
            }
            this.setSessionId(string);
        }
        if (map.containsKey(VER_PARAM)) {
            this.setMinimumProtocolVersion(map.get(VER_PARAM));
        } else {
            this.setMinimumProtocolVersion(Integer.toString(ProtocolVersion.VERSION_0.getVersion()));
        }
        if (map.containsKey("stservlet")) {
            URL uRL;
            try {
                uRL = UrlParametersToSave.validateURL(map.get("stservlet"));
            }
            catch (ParameterLocalAccessRequestedException parameterException) {
                throw new ParameterLocalAccessRequestedException("La URL del servicio de guardado no puede ser local", parameterException);
            }
            catch (ParameterException parameterException) {
                throw new ParameterException("Error al validar la URL del servicio de guardado: " + parameterException, parameterException);
            }
            this.setStorageServletUrl(uRL);
        }
        this.setTitle(UrlParametersToSave.verifyTitle(map));
        this.setFilename(UrlParametersToSave.verifyFilename(map));
        this.setExtensions(UrlParametersToSave.verifyExtensions(map));
        this.setFileTypeDescription(UrlParametersToSave.verifyFileTypeDescription(map));
    }

    private static String verifyFilename(Map<String, String> map) throws ParameterException {
        String string = null;
        if (map.containsKey(FILENAME_PARAM)) {
            string = map.get(FILENAME_PARAM);
            for (char c : "\\/:*?\"<>|".toCharArray()) {
                if (string.indexOf(c) == -1) continue;
                throw new ParameterException("Se ha indicado un nombre de fichero con el caracter invalido: " + c);
            }
        }
        return string;
    }

    private static String verifyExtensions(Map<String, String> map) throws ParameterException {
        String string = null;
        if (map.containsKey(FILENAME_EXTS_PARAM)) {
            string = map.get(FILENAME_EXTS_PARAM);
            for (char c : "\\/:*?\"<>|; ".toCharArray()) {
                if (string.indexOf(c) == -1) continue;
                throw new ParameterException("Se ha indicado una lista de extensiones de nombre de fichero con caracteres invalidos: " + c);
            }
        }
        return string;
    }

    private static String verifyTitle(Map<String, String> map) {
        if (map.containsKey(TITLE_PARAM)) {
            return map.get(TITLE_PARAM);
        }
        return ProtocoloMessages.getString("ProtocolInvocationUriParser.1");
    }

    private static String verifyFileTypeDescription(Map<String, String> map) {
        String string = null;
        if (map.containsKey(FILETYPE_DESCRIPTION_PARAM)) {
            string = map.get(FILETYPE_DESCRIPTION_PARAM);
            if (map.containsKey(FILENAME_EXTS_PARAM) && !string.endsWith(")")) {
                StringBuilder stringBuilder = new StringBuilder(string).append(" (");
                for (String string2 : map.get(FILENAME_EXTS_PARAM).split(",")) {
                    stringBuilder.append("*.");
                    stringBuilder.append(string2);
                }
                stringBuilder.append(")");
                string = stringBuilder.toString();
            }
        }
        return string;
    }
}

